/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.ryantenney.metrics.spring.AbstractMetricMethodInterceptor;
import com.ryantenney.metrics.spring.AdviceFactory;
import com.ryantenney.metrics.spring.AnnotationFilter;
import com.ryantenney.metrics.spring.Util;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

class ExceptionMeteredMethodInterceptor
extends AbstractMetricMethodInterceptor<ExceptionMetered, Meter>
implements Ordered {
    public static final Class<ExceptionMetered> ANNOTATION = ExceptionMetered.class;
    public static final Pointcut POINTCUT = new AnnotationMatchingPointcut(null, ANNOTATION);
    public static final ReflectionUtils.MethodFilter METHOD_FILTER = new AnnotationFilter(ANNOTATION, 2469);

    public ExceptionMeteredMethodInterceptor(MetricRegistry metricRegistry, Class<?> targetClass) {
        super(metricRegistry, targetClass, ANNOTATION, METHOD_FILTER);
    }

    @Override
    protected Object invoke(MethodInvocation invocation, Meter meter, ExceptionMetered annotation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            if (annotation.cause().isAssignableFrom(t.getClass())) {
                meter.mark();
            }
            throw t;
        }
    }

    @Override
    protected Meter buildMetric(MetricRegistry metricRegistry, String metricName, ExceptionMetered annotation) {
        return metricRegistry.meter(metricName);
    }

    @Override
    protected String buildMetricName(Class<?> targetClass, Method method, ExceptionMetered annotation) {
        return Util.forExceptionMeteredMethod(targetClass, method, annotation);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static AdviceFactory adviceFactory(final MetricRegistry metricRegistry) {
        return new AdviceFactory(){

            @Override
            public Advice getAdvice(Object bean, Class<?> targetClass) {
                return new ExceptionMeteredMethodInterceptor(metricRegistry, targetClass);
            }
        };
    }
}

