/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.console;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.console.OConsoleApplication;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OTableFormatter {
    protected static final String MORE = "...";
    protected static final Set<String> prefixedColumns = new LinkedHashSet<String>(Arrays.asList("#", "@RID", "@CLASS"));
    protected final OConsoleApplication out;
    protected final SimpleDateFormat DEF_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected int minColumnSize = 4;
    protected int maxWidthSize = 150;

    public OTableFormatter(OConsoleApplication iConsole) {
        this.out = iConsole;
    }

    public void writeRecords(Collection<OIdentifiable> resultSet, int limit) {
        this.writeRecords(resultSet, limit, null);
    }

    public void writeRecords(Collection<OIdentifiable> resultSet, int limit, OCallable<Object, OIdentifiable> iAfterDump) {
        Map<String, Integer> columns = this.parseColumns(resultSet, limit);
        int fetched = 0;
        for (OIdentifiable record : resultSet) {
            this.dumpRecordInTable(fetched++, record, columns);
            if (iAfterDump != null) {
                iAfterDump.call((Object)record);
            }
            if (limit <= -1 || fetched < limit) continue;
            this.printHeaderLine(columns);
            this.out.message("\nLIMIT EXCEEDED: resultset contains more items not displayed (limit=" + limit + ")", new Object[0]);
            return;
        }
        if (fetched > 0) {
            this.printHeaderLine(columns);
        }
    }

    public int getMaxWidthSize() {
        return this.maxWidthSize;
    }

    public OTableFormatter setMaxWidthSize(int maxWidthSize) {
        this.maxWidthSize = maxWidthSize;
        return this;
    }

    public void dumpRecordInTable(int iIndex, OIdentifiable iRecord, Map<String, Integer> iColumns) {
        if (iIndex == 0) {
            this.printHeader(iColumns);
        }
        ArrayList<Object> vargs = new ArrayList<Object>();
        try {
            if (iRecord instanceof ODocument) {
                ((ODocument)iRecord).setLazyLoad(false);
            }
            StringBuilder format = new StringBuilder(this.maxWidthSize);
            for (Map.Entry<String, Integer> col : iColumns.entrySet()) {
                if (format.length() > 0) {
                    format.append('|');
                }
                format.append("%-" + col.getValue() + "s");
                Object value = this.getFieldValue(iIndex, iRecord, col.getKey());
                if (value != null) {
                    if (value instanceof ORidBag) {
                        ((ORidBag)value).size();
                    }
                    if (((String)(value = value.toString())).length() > col.getValue()) {
                        value = ((String)value).substring(0, col.getValue() - 3) + MORE;
                    }
                }
                vargs.add(value);
            }
            this.out.message("\n" + format.toString(), vargs.toArray());
        }
        catch (Throwable t) {
            this.out.message("%3d|%9s|%s\n", new Object[]{iIndex, iRecord.getIdentity(), "Error on loading record dued to: " + t});
        }
    }

    private Object getFieldValue(int iIndex, OIdentifiable iRecord, String iColumnName) {
        Object value = null;
        if (iColumnName.equals("#")) {
            value = iIndex;
        } else if (iColumnName.equals("@RID")) {
            value = iRecord.getIdentity().toString();
        } else if (iRecord instanceof ODocument) {
            value = ((ODocument)iRecord).field(iColumnName);
        } else if (iRecord instanceof ORecordBytes) {
            value = "<binary> (size=" + ((ORecordBytes)iRecord).toStream().length + " bytes)";
        } else if (iRecord instanceof OIdentifiable) {
            ORecord rec = iRecord.getRecord();
            if (rec instanceof ODocument) {
                value = ((ODocument)rec).field(iColumnName);
            } else if (rec instanceof ORecordBytes) {
                value = "<binary> (size=" + ((ORecordBytes)rec).toStream().length + " bytes)";
            }
        }
        if (value instanceof OMultiCollectionIterator) {
            value = "[" + ((OMultiCollectionIterator)value).size() + "]";
        } else if (value instanceof Collection) {
            value = "[" + ((Collection)value).size() + "]";
        } else if (value instanceof ORecord) {
            value = ((ORecord)value).getIdentity().equals(ORecordId.EMPTY_RECORD_ID) ? ((ORecord)value).toString() : ((ORecord)value).getIdentity().toString();
        } else if (value instanceof Date) {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
            value = db != null ? db.getStorage().getConfiguration().getDateTimeFormatInstance().format((Date)value) : this.DEF_DATEFORMAT.format((Date)value);
        } else if (value instanceof byte[]) {
            value = "byte[" + ((byte[])value).length + "]";
        }
        return value;
    }

    private void printHeader(Map<String, Integer> iColumns) {
        StringBuilder buffer = new StringBuilder("\n");
        this.printHeaderLine(iColumns);
        int i = 0;
        for (Map.Entry<String, Integer> column : iColumns.entrySet()) {
            String colName;
            if (i++ > 0) {
                buffer.append('|');
            }
            if ((colName = column.getKey()).length() > column.getValue()) {
                colName = colName.substring(0, column.getValue());
            }
            buffer.append(String.format("%-" + column.getValue() + "s", colName));
        }
        this.out.message(buffer.toString(), new Object[0]);
        this.printHeaderLine(iColumns);
    }

    private void printHeaderLine(Map<String, Integer> iColumns) {
        StringBuilder buffer = new StringBuilder("\n");
        if (iColumns.size() > 0) {
            int i = 0;
            for (Map.Entry<String, Integer> col : iColumns.entrySet()) {
                if (i++ > 0) {
                    buffer.append("+");
                }
                for (int k = 0; k < col.getValue(); ++k) {
                    buffer.append("-");
                }
            }
        }
        this.out.message(buffer.toString(), new Object[0]);
    }

    private Map<String, Integer> parseColumns(Collection<OIdentifiable> resultSet, int limit) {
        LinkedHashMap<String, Integer> columns = new LinkedHashMap<String, Integer>();
        for (String c : prefixedColumns) {
            columns.put(c, this.minColumnSize);
        }
        boolean tempRids = false;
        int fetched = 0;
        for (OIdentifiable oIdentifiable : resultSet) {
            ORecord oRecord = oIdentifiable.getRecord();
            for (String string : prefixedColumns) {
                columns.put(string, this.getColumnSize(fetched, oRecord, string, (Integer)columns.get(string)));
            }
            if (oRecord instanceof ODocument) {
                ((ODocument)oRecord).setLazyLoad(false);
                ODocument oDocument = (ODocument)oRecord;
                for (String fieldName : oDocument.fieldNames()) {
                    columns.put(fieldName, this.getColumnSize(fetched, (ORecord)oDocument, fieldName, (Integer)columns.get(fieldName)));
                }
            } else if (oRecord instanceof ORecordBytes) {
                columns.put("value", this.maxWidthSize - 15);
            }
            if (!tempRids && !oRecord.getIdentity().isPersistent()) {
                tempRids = true;
            }
            if (limit <= -1 || fetched++ < limit) continue;
            break;
        }
        if (tempRids) {
            columns.remove("@RID");
        }
        int width = 0;
        for (Map.Entry entry : columns.entrySet()) {
            width += ((Integer)entry.getValue()).intValue();
        }
        if (width > this.maxWidthSize) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(columns.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            Collections.reverse(arrayList);
            while (width > this.maxWidthSize) {
                int n = width;
                for (Map.Entry entry : arrayList) {
                    int redux = (Integer)entry.getValue() * 10 / 100;
                    if ((Integer)entry.getValue() - redux < this.minColumnSize) break;
                    entry.setValue((Integer)entry.getValue() - redux);
                    if ((width -= redux) > this.maxWidthSize) continue;
                    break;
                }
                if (width != n) continue;
                break;
            }
            columns.clear();
            for (String string : prefixedColumns) {
                columns.put(string, this.minColumnSize);
            }
            Collections.reverse(arrayList);
            for (Map.Entry entry : arrayList) {
                columns.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        if (tempRids) {
            columns.remove("@RID");
        }
        return columns;
    }

    private Integer getColumnSize(Integer iIndex, ORecord iRecord, String fieldName, Integer origSize) {
        String fieldValueAsString;
        Integer newColumnSize = origSize == null ? Integer.valueOf(fieldName.length()) : Integer.valueOf(Math.max(origSize, fieldName.length()));
        Object fieldValue = this.getFieldValue(iIndex, (OIdentifiable)iRecord, fieldName);
        if (fieldValue != null && (fieldValueAsString = fieldValue.toString()).length() > newColumnSize) {
            newColumnSize = fieldValueAsString.length();
        }
        if (newColumnSize < this.minColumnSize) {
            newColumnSize = this.minColumnSize;
        }
        return newColumnSize;
    }
}

