/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OHazelcastDistributedRequest
implements ODistributedRequest,
Externalizable {
    private long id;
    private ODistributedRequest.EXECUTION_MODE executionMode;
    private String senderNodeName;
    private String databaseName;
    private long senderThreadId;
    private OAbstractRemoteTask task;
    private ORID userRID;

    public OHazelcastDistributedRequest() {
    }

    public OHazelcastDistributedRequest(String senderNodeName, String databaseName, OAbstractRemoteTask payload, ODistributedRequest.EXECUTION_MODE iExecutionMode) {
        this.senderNodeName = senderNodeName;
        this.databaseName = databaseName;
        this.senderThreadId = Thread.currentThread().getId();
        this.task = payload;
        this.executionMode = iExecutionMode;
        this.id = -1L;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long iReqId) {
        this.id = iReqId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public OHazelcastDistributedRequest setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public OAbstractRemoteTask getTask() {
        return this.task;
    }

    public OHazelcastDistributedRequest setTask(OAbstractRemoteTask payload) {
        this.task = payload;
        return this;
    }

    public String getSenderNodeName() {
        return this.senderNodeName;
    }

    public OHazelcastDistributedRequest setSenderNodeName(String senderNodeName) {
        this.senderNodeName = senderNodeName;
        return this;
    }

    public ORID getUserRID() {
        return this.userRID;
    }

    public void setUserRID(ORID iUserRID) {
        this.userRID = iUserRID;
    }

    public ODistributedRequest.EXECUTION_MODE getExecutionMode() {
        return this.executionMode;
    }

    public OHazelcastDistributedRequest setExecutionMode(ODistributedRequest.EXECUTION_MODE executionMode) {
        this.executionMode = executionMode;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeUTF(this.senderNodeName);
        out.writeLong(this.senderThreadId);
        out.writeUTF(this.databaseName);
        out.writeObject(this.task);
        out.writeObject(this.userRID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.senderNodeName = in.readUTF();
        this.senderThreadId = in.readLong();
        this.databaseName = in.readUTF();
        this.task = (OAbstractRemoteTask)in.readObject();
        this.userRID = (ORID)in.readObject();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("id=");
        buffer.append(this.id);
        buffer.append(" from=");
        buffer.append(this.senderNodeName);
        if (this.task != null) {
            buffer.append(" task=");
            buffer.append(this.task.toString());
        }
        if (this.userRID != null) {
            buffer.append(" user=");
            buffer.append(this.userRID);
        }
        return buffer.toString();
    }
}

