/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.hazelcast.core.IQueue;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OFixTxTask;
import com.orientechnologies.orient.server.distributed.task.OResurrectRecordTask;
import com.orientechnologies.orient.server.distributed.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.task.OTxTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import com.orientechnologies.orient.server.hazelcast.ODistributedWorker;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedMessageService;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import com.orientechnologies.orient.server.hazelcast.OHotAlignmentNotPossibleExeption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class OHazelcastDistributedDatabase
implements ODistributedDatabase {
    public static final String NODE_QUEUE_PREFIX = "orientdb.node.";
    public static final String NODE_QUEUE_PENDING_POSTFIX = ".pending";
    private static final String NODE_LOCK_PREFIX = "orientdb.reqlock.";
    protected final OHazelcastPlugin manager;
    protected final OHazelcastDistributedMessageService msgService;
    protected final String databaseName;
    protected final Lock requestLock;
    protected final int numWorkers = 8;
    protected volatile boolean restoringMessages = false;
    protected AtomicBoolean status = new AtomicBoolean(false);
    protected List<ODistributedWorker> workers = new ArrayList<ODistributedWorker>();
    protected AtomicLong waitForMessageId = new AtomicLong(-1L);
    protected ConcurrentHashMap<ORID, String> lockManager = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Integer> queueSizes = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Integer> queueWarningCounter = new ConcurrentHashMap();

    public OHazelcastDistributedDatabase(OHazelcastPlugin manager, OHazelcastDistributedMessageService msgService, String iDatabaseName) {
        this.manager = manager;
        this.msgService = msgService;
        this.databaseName = iDatabaseName;
        this.requestLock = manager.getHazelcastInstance().getLock(NODE_LOCK_PREFIX + iDatabaseName);
        this.checkLocalNodeInConfiguration();
        msgService.getQueue(OHazelcastDistributedMessageService.getRequestQueueName(this.getLocalNodeName(), this.databaseName));
        msgService.getQueue(OHazelcastDistributedMessageService.getRequestQueueName(this.getLocalNodeName(), this.databaseName + ".insert"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode) {
        boolean groupByResponse;
        this.checkForServerOnline(iRequest);
        String databaseName = iRequest.getDatabaseName();
        if (iNodes.isEmpty()) {
            ODistributedServerLog.error((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"No nodes configured for database '%s' request: %s", (Object[])new Object[]{databaseName, iRequest});
            throw new ODistributedException("No nodes configured for partition '" + databaseName + "' request: " + iRequest);
        }
        ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(databaseName);
        OPair<String, IQueue>[] reqQueues = this.getRequestQueues(databaseName, iNodes, iRequest.getTask());
        iRequest.setSenderNodeName(this.getLocalNodeName());
        int onlineNodes = this.getAvailableNodes(iRequest, iNodes, databaseName, reqQueues);
        int quorum = this.calculateQuorum(iRequest, iClusterNames, cfg, onlineNodes, iExecutionMode);
        int queueSize = iNodes.size();
        int expectedSynchronousResponses = onlineNodes;
        if (iRequest.getTask().getResultStrategy() == OAbstractRemoteTask.RESULT_STRATEGY.UNION) {
            expectedSynchronousResponses = onlineNodes;
            groupByResponse = false;
        } else {
            groupByResponse = true;
        }
        boolean waitLocalNode = this.waitForLocalNode(cfg, iClusterNames, iNodes);
        ODistributedResponseManager currentResponseMgr = new ODistributedResponseManager((ODistributedServerManager)this.manager, iRequest, iNodes, expectedSynchronousResponses, quorum, waitLocalNode, iRequest.getTask().getSynchronousTimeout(expectedSynchronousResponses), iRequest.getTask().getTotalTimeout(queueSize), groupByResponse);
        long timeout = OGlobalConfiguration.DISTRIBUTED_QUEUE_TIMEOUT.getValueAsLong();
        int queueMaxSize = OGlobalConfiguration.DISTRIBUTED_QUEUE_MAXSIZE.getValueAsInteger();
        try {
            this.requestLock.lock();
            try {
                iRequest.setId(this.msgService.getMessageIdCounter().getAndIncrement());
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"sending request %s", (Object[])new Object[]{iRequest});
                }
                this.msgService.registerRequest(iRequest.getId(), currentResponseMgr);
                for (OPair<String, IQueue> entry : reqQueues) {
                    String node = (String)((Object)entry.getKey());
                    IQueue queue = (IQueue)entry.getValue();
                    if (queue == null) continue;
                    int nodeQueueSize = queue.size();
                    if (queueMaxSize > 0 && nodeQueueSize > queueMaxSize) {
                        ODistributedServerManager.DB_STATUS nodeStatus;
                        Integer nodeQueueWarnings;
                        Integer nodeQueuePrevSize = this.queueSizes.get(node);
                        if (nodeQueuePrevSize == null) {
                            nodeQueuePrevSize = 0;
                        }
                        if ((nodeQueueWarnings = this.queueWarningCounter.get(node)) == null) {
                            nodeQueueWarnings = 0;
                        }
                        if ((nodeStatus = this.manager.getDatabaseStatus(node, databaseName)) == ODistributedServerManager.DB_STATUS.SYNCHRONIZING || nodeStatus == ODistributedServerManager.DB_STATUS.BACKUP) {
                            queue.offer((Object)iRequest, timeout, TimeUnit.MILLISECONDS);
                            this.queueWarningCounter.remove(node);
                        } else if (nodeQueueSize < nodeQueuePrevSize || nodeQueueWarnings < 10) {
                            queue.offer((Object)iRequest, timeout, TimeUnit.MILLISECONDS);
                            if (System.currentTimeMillis() - this.manager.getLastClusterChangeOn() > 10000L) {
                                this.queueWarningCounter.put(node, nodeQueueWarnings + 1);
                                ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"queue '%s' has too many messages (%d), checking if the node is in stall (warnings=%d)", (Object[])new Object[]{queue.getName(), nodeQueueSize, nodeQueueWarnings});
                            } else {
                                this.queueWarningCounter.remove(node);
                                ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"queue '%s' has too many messages (%d), but the cluster shape is changed recently (%d secs)", (Object[])new Object[]{queue.getName(), nodeQueueSize, (System.currentTimeMillis() - this.manager.getLastClusterChangeOn()) / 1000L});
                            }
                        } else {
                            ODistributedServerLog.warn((Object)this, (String)this.getLocalNodeName(), (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"queue '%s' has too many messages (%d), treating the node as in stall: trying to restart it...", (Object[])new Object[]{queue.getName(), nodeQueueSize});
                            queue.clear();
                            this.queueWarningCounter.remove(node);
                            nodeQueueSize = 0;
                            this.manager.disconnectNode((String)((Object)entry.getKey()));
                        }
                    } else {
                        queue.offer((Object)iRequest, timeout, TimeUnit.MILLISECONDS);
                        this.queueWarningCounter.remove(node);
                    }
                    this.queueSizes.put(node, nodeQueueSize);
                }
            }
            finally {
                this.requestLock.unlock();
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"sent request %s", (Object[])new Object[]{iRequest});
            }
            Orient.instance().getProfiler().updateCounter("distributed.db." + databaseName + ".msgSent", "Number of replication messages sent from current node", 1L, "distributed.db.*.msgSent");
            return this.waitForResponse(iRequest, currentResponseMgr);
        }
        catch (Throwable e) {
            throw new ODistributedException("Error on executing distributed request (" + iRequest + ") against database '" + databaseName + (iClusterNames != null ? "." + iClusterNames : "") + "' to nodes " + iNodes, e);
        }
    }

    protected int getAvailableNodes(ODistributedRequest iRequest, Collection<String> iNodes, String databaseName, OPair<String, IQueue>[] reqQueues) {
        int availableNodes = 0;
        int i = 0;
        for (String node : iNodes) {
            boolean include = this.manager.isNodeAvailable(node, databaseName);
            if (include && reqQueues[i].getValue() != null) {
                ++availableNodes;
            } else if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"skip expected response from node '%s' for request %s because it's not online (queue=%s)", (Object[])new Object[]{node, iRequest, reqQueues[i].getValue() != null});
            }
            ++i;
        }
        return availableNodes;
    }

    public boolean isRestoringMessages() {
        return this.restoringMessages;
    }

    public OHazelcastDistributedDatabase configureDatabase(boolean iRestoreMessages, boolean iUnqueuePendingMessages, Callable<Void> iCallback) {
        String queueName = OHazelcastDistributedMessageService.getRequestQueueName(this.getLocalNodeName(), this.databaseName);
        IQueue requestQueue = this.msgService.getQueue(queueName);
        ODistributedWorker listenerThread = this.unqueuePendingMessages(iRestoreMessages, iUnqueuePendingMessages, queueName, requestQueue);
        this.workers.add(listenerThread);
        if (iCallback != null) {
            try {
                iCallback.call();
            }
            catch (Exception e) {
                throw new ODistributedException((Throwable)e);
            }
        }
        this.setOnline();
        return this;
    }

    public void setOnline() {
        if (this.status.compareAndSet(false, true)) {
            ODistributedServerLog.info((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Publishing online status for database %s.%s...", (Object[])new Object[]{this.getLocalNodeName(), this.databaseName});
            this.manager.setDatabaseStatus(this.getLocalNodeName(), this.databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
        }
    }

    public boolean lockRecord(ORID iRecord, String iNodeName) {
        boolean locked;
        boolean bl = locked = this.lockManager.putIfAbsent(iRecord, iNodeName) == null;
        if (ODistributedServerLog.isDebugEnabled()) {
            if (locked) {
                ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: locked record %s in database '%s' owned by server '%s'", (Object[])new Object[]{iRecord, this.databaseName, iNodeName});
            } else {
                ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: cannot lock record %s in database '%s' owned by server '%s'", (Object[])new Object[]{iRecord, this.databaseName, iNodeName});
            }
        }
        return locked;
    }

    public void unlockRecord(ORID iRecord) {
        this.lockManager.remove(iRecord);
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: unlocked record %s in database '%s'", (Object[])new Object[]{iRecord, this.databaseName});
        }
    }

    public void unlockRecords(String iNodeName) {
        int unlocked = 0;
        Iterator<Map.Entry<ORID, String>> it = this.lockManager.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ORID, String> v = it.next();
            if (v == null || !iNodeName.equals(v.getValue())) continue;
            it.remove();
            ++unlocked;
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: unlocked %d locks in database '%s' owned by server '%s'", (Object[])new Object[]{unlocked, this.databaseName, iNodeName});
        }
    }

    public OHazelcastDistributedDatabase setWaitForMessage(long iMessageId) {
        ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"waiting for message id %d (discard all previous ones if any)...", (Object[])new Object[]{iMessageId});
        this.waitForMessageId.set(iMessageId);
        return this;
    }

    public void shutdown() {
        for (int i = 0; i < this.workers.size(); ++i) {
            this.workers.get(i).shutdown();
        }
    }

    protected ODistributedWorker unqueuePendingMessages(boolean iRestoreMessages, boolean iUnqueuePendingMessages, String queueName, IQueue requestQueue) {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"listening for incoming requests on queue: %s", (Object[])new Object[]{queueName});
        }
        this.restoreMessagesBeforeFailure(iRestoreMessages);
        this.restoringMessages = this.msgService.checkForPendingMessages(requestQueue, queueName, iUnqueuePendingMessages);
        ODistributedWorker listenerThread = new ODistributedWorker(this, requestQueue, this.databaseName, 0, this.restoringMessages);
        listenerThread.initDatabaseInstance();
        listenerThread.start();
        return listenerThread;
    }

    protected void checkForServerOnline(ODistributedRequest iRequest) throws ODistributedException {
        ODistributedServerManager.NODE_STATUS srvStatus = this.manager.getNodeStatus();
        if (srvStatus == ODistributedServerManager.NODE_STATUS.OFFLINE || srvStatus == ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN) {
            ODistributedServerLog.error((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Local server is not online (status='%s'). Request %s will be ignored", (Object[])new Object[]{srvStatus, iRequest});
            throw new ODistributedException("Local server is not online (status='" + srvStatus + "'). Request " + iRequest + " will be ignored");
        }
    }

    protected boolean waitForLocalNode(ODistributedConfiguration cfg, Collection<String> iClusterNames, Collection<String> iNodes) {
        boolean waitLocalNode;
        block1: {
            block2: {
                waitLocalNode = false;
                if (!iNodes.contains(this.getLocalNodeName())) break block1;
                if (iClusterNames != null && !iClusterNames.isEmpty()) break block2;
                if (!cfg.isReadYourWrites(null).booleanValue()) break block1;
                waitLocalNode = true;
                break block1;
            }
            for (String clName : iClusterNames) {
                if (!cfg.isReadYourWrites(clName).booleanValue()) continue;
                waitLocalNode = true;
                break;
            }
        }
        return waitLocalNode;
    }

    protected int calculateQuorum(ODistributedRequest iRequest, Collection<String> clusterNames, ODistributedConfiguration cfg, int iAvailableNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode) {
        if (iAvailableNodes == 0 && iExecutionMode == ODistributedRequest.EXECUTION_MODE.RESPONSE) {
            throw new ODistributedException("Quorum cannot be reached because there are no nodes available");
        }
        String clusterName = clusterNames == null || clusterNames.isEmpty() ? null : clusterNames.iterator().next();
        int quorum = 1;
        OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType = iRequest.getTask().getQuorumType();
        switch (quorumType) {
            case NONE: {
                break;
            }
            case READ: {
                quorum = cfg.getReadQuorum(clusterName);
                break;
            }
            case WRITE: {
                quorum = cfg.getWriteQuorum(clusterName);
                break;
            }
            case ALL: {
                quorum = iAvailableNodes;
            }
        }
        if (quorum > iAvailableNodes) {
            boolean failureAvailableNodesLessQuorum = cfg.getFailureAvailableNodesLessQuorum(clusterName);
            if (failureAvailableNodesLessQuorum) {
                throw new ODistributedException("Quorum cannot be reached because it is major than available nodes and failureAvailableNodesLessQuorum=true");
            }
            ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"quorum less then available nodes, downgrade quorum to %d", (Object[])new Object[]{iAvailableNodes});
            quorum = iAvailableNodes;
        }
        return quorum;
    }

    protected ODistributedResponse waitForResponse(ODistributedRequest iRequest, ODistributedResponseManager currentResponseMgr) throws InterruptedException {
        long elapsed;
        if (iRequest.getExecutionMode() == ODistributedRequest.EXECUTION_MODE.NO_RESPONSE) {
            return null;
        }
        long beginTime = System.currentTimeMillis();
        if (!currentResponseMgr.waitForSynchronousResponses() && (elapsed = System.currentTimeMillis() - beginTime) > currentResponseMgr.getSynchTimeout()) {
            ODistributedServerLog.warn((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"timeout (%dms) on waiting for synchronous responses from nodes=%s responsesSoFar=%s request=%s", (Object[])new Object[]{elapsed, currentResponseMgr.getExpectedNodes(), currentResponseMgr.getRespondingNodes(), iRequest});
        }
        return currentResponseMgr.getFinalResponse();
    }

    protected OPair<String, IQueue>[] getRequestQueues(String iDatabaseName, Collection<String> nodes, OAbstractRemoteTask iTask) {
        OPair[] queues = new OPair[nodes.size()];
        int i = 0;
        for (String node : nodes) {
            String queueName = OHazelcastDistributedMessageService.getRequestQueueName(node, iDatabaseName);
            IQueue queue = this.msgService.getQueue(queueName);
            queues[i++] = new OPair((Comparable)((Object)node), queue);
        }
        return queues;
    }

    protected String getPendingRequestMapName() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(NODE_QUEUE_PREFIX);
        buffer.append(this.getLocalNodeName());
        buffer.append(NODE_QUEUE_PENDING_POSTFIX);
        return buffer.toString();
    }

    protected String getLocalNodeName() {
        return this.manager.getLocalNodeName();
    }

    protected void restoreMessagesBeforeFailure(boolean iRestoreMessages) {
        for (int i = 0; i < this.workers.size(); ++i) {
            this.workers.get(i).restoreMessagesBeforeFailure(iRestoreMessages);
        }
    }

    protected void hotAlignmentError(ODistributedRequest iLastPendingRequest, String iMessage, Object ... iParams) throws OHotAlignmentNotPossibleExeption {
        String msg = String.format(iMessage, iParams);
        ODistributedServerLog.warn((Object)this, (String)this.getLocalNodeName(), (String)iLastPendingRequest.getSenderNodeName(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)("- " + msg), (Object[])new Object[0]);
        throw new OHotAlignmentNotPossibleExeption(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLocalNodeInConfiguration() {
        Lock lock = this.manager.getLock("orientdb." + this.databaseName + ".cfg");
        lock.lock();
        try {
            ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(this.databaseName);
            boolean distribCfgDirty = false;
            List foundPartition = cfg.addNewNodeInServerList(this.getLocalNodeName());
            if (foundPartition != null) {
                this.manager.setDatabaseStatus(this.getLocalNodeName(), this.databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                ODistributedServerLog.info((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"adding node '%s' in partition: db=%s %s", (Object[])new Object[]{this.getLocalNodeName(), this.databaseName, foundPartition});
                distribCfgDirty = true;
            }
            String suffix2Search = "_" + this.getLocalNodeName();
            for (String c : cfg.getClusterNames()) {
                if (!c.endsWith(suffix2Search)) continue;
                String currentMaster = cfg.getMasterServer(c);
                if (this.getLocalNodeName().equals(currentMaster)) continue;
                ODistributedServerLog.warn((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"changing mastership of cluster '%s' from node '%s' to '%s'", (Object[])new Object[]{c, currentMaster, this.getLocalNodeName()});
                cfg.setMasterServer(c, this.getLocalNodeName());
                distribCfgDirty = true;
            }
            if (distribCfgDirty) {
                this.manager.updateCachedDatabaseConfiguration(this.databaseName, cfg.serialize(), true, true);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNodeInConfiguration(String iNode, boolean iForce) {
        Lock lock = this.manager.getLock("orientdb." + this.databaseName + ".cfg");
        lock.lock();
        try {
            ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(this.databaseName);
            if (!cfg.isHotAlignment()) {
                List foundPartition = cfg.removeNodeInServerList(iNode, iForce);
                if (foundPartition != null) {
                    ODistributedServerLog.info((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"removing node '%s' in partitions: db=%s %s", (Object[])new Object[]{iNode, this.databaseName, foundPartition});
                    this.msgService.removeQueue(OHazelcastDistributedMessageService.getRequestQueueName(iNode, this.databaseName));
                    this.msgService.removeQueue(OHazelcastDistributedMessageService.getRequestQueueName(iNode, this.databaseName + ".insert"));
                }
                this.manager.updateCachedDatabaseConfiguration(this.databaseName, cfg.serialize(), true, true);
            }
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)this, (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"unable to remove node or change mastership for '%s' in distributed configuration, db=%s", (Throwable)e, (Object[])new Object[]{iNode, this.databaseName});
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean checkIfOperationHasBeenExecuted(ODistributedRequest lastPendingRequest, OAbstractRemoteTask task) {
        boolean executeLastPendingRequest = false;
        if (task instanceof ODeleteRecordTask) {
            executeLastPendingRequest = ((ODeleteRecordTask)task).getRid().getRecord() != null;
        } else if (task instanceof OUpdateRecordTask) {
            ORecord rec = ((OUpdateRecordTask)task).getRid().getRecord();
            if (rec == null) {
                ODistributedServerLog.warn((Object)this, (String)this.getLocalNodeName(), (String)lastPendingRequest.getSenderNodeName(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"- cannot update deleted record %s, database could be not aligned", (Object[])new Object[]{((OUpdateRecordTask)task).getRid()});
            } else {
                executeLastPendingRequest = !rec.getRecordVersion().equals((Object)((OUpdateRecordTask)task).getVersion());
            }
        } else if (task instanceof OCreateRecordTask) {
            executeLastPendingRequest = ((OCreateRecordTask)task).getRid().getRecord() == null;
        } else if (task instanceof OSQLCommandTask) {
            if (!task.isIdempotent()) {
                this.hotAlignmentError(lastPendingRequest, "Not able to assure last command has been completed before last crash. Command='%s'", ((OSQLCommandTask)task).getPayload());
            }
        } else if (task instanceof OResurrectRecordTask) {
            if (((OResurrectRecordTask)task).getRid().getRecord() == null) {
                this.hotAlignmentError(lastPendingRequest, "Not able to resurrect deleted record '%s'", ((OResurrectRecordTask)task).getRid());
            }
        } else if (task instanceof OTxTask) {
            for (OAbstractRemoteTask t : ((OTxTask)task).getTasks()) {
                executeLastPendingRequest = this.checkIfOperationHasBeenExecuted(lastPendingRequest, t);
                if (!executeLastPendingRequest) continue;
                return true;
            }
        } else if (task instanceof OFixTxTask) {
            for (OAbstractRemoteTask t : ((OFixTxTask)task).getTasks()) {
                executeLastPendingRequest = this.checkIfOperationHasBeenExecuted(lastPendingRequest, t);
                if (!executeLastPendingRequest) continue;
                return true;
            }
        } else {
            this.hotAlignmentError(lastPendingRequest, "Not able to assure last operation has been completed before last crash. Task='%s'", task);
        }
        return executeLastPendingRequest;
    }
}

