/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class JdbcUrlUtils {
    static final String JDBC_URL_PREFIX = "jdbc:";

    private JdbcUrlUtils() {
    }

    static int getPort(String url) {
        return URI.create(url.substring(JDBC_URL_PREFIX.length())).getPort();
    }

    static String addUsernamePassword(String url, String userName, String password) throws URISyntaxException, UnsupportedEncodingException {
        URI uri = URI.create(url.substring(JDBC_URL_PREFIX.length()));
        HashMap<String, String> params = new HashMap<String, String>(Optional.ofNullable(uri.getQuery()).map(Stream::of).orElse(Stream.empty()).flatMap(par -> Arrays.stream(par.split("&"))).map(part -> part.split("=")).filter(part -> ((String[])part).length > 1).collect(Collectors.toMap(part -> part[0], part -> part[1])));
        params.put("user", URLEncoder.encode(userName, "UTF-8"));
        params.put("password", URLEncoder.encode(password, "UTF-8"));
        return JDBC_URL_PREFIX + new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), params.entrySet().stream().map(i -> (String)i.getKey() + "=" + (String)i.getValue()).collect(Collectors.joining("&")), uri.getFragment());
    }

    static String replaceDatabase(String url, String dbName) throws URISyntaxException {
        URI uri = URI.create(url.substring(JDBC_URL_PREFIX.length()));
        return JDBC_URL_PREFIX + new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/" + dbName, uri.getQuery(), uri.getFragment());
    }
}

