/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugins.jetty.config;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.mycila.testing.plugins.jetty.JettyRunWar;
import com.mycila.testing.plugins.jetty.NopServerLifeCycleListener;
import com.mycila.testing.plugins.jetty.ServerLifeCycleListener;
import com.mycila.testing.plugins.jetty.config.Config;
import com.mycila.testing.plugins.jetty.config.RawConfig;
import com.mycila.testing.plugins.jetty.locator.StrategyFileLocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfig
implements Config {
    public static final Class<? extends RawConfig> DEFAULT_CONFIG_CLASS = DefaultConfig.class;
    public static final String DEFAULT_WAR_LOCATION = "reg:.*\\.war";
    public static final int DEFAULT_SERVER_PORT = 9090;
    public static final String DEFAULT_SERVER_PORT_AS_STRING = Integer.toString(9090);
    public static final String DEFAULT_CONTEXT_PATH = "/its";
    public static final boolean DEFAULT_START_SERVER = true;
    public static final String DEFAULT_START_SERVER_AS_STRING = Boolean.toString(true);
    public static final boolean DEFAULT_DEPLOY_WEBAPP = true;
    public static final String DEFAULT_DEPLOY_WEBAPP_AS_STRING = Boolean.toString(true);
    public static final boolean DEFAULT_SKIP = false;
    public static final String DEFAULT_SKIP_AS_STRING = Boolean.toString(false);
    public static final Class<? extends ServerLifeCycleListener> DEFAULT_CYCLE_LISTENER_CLASS = NopServerLifeCycleListener.class;
    public static final String DEFAULT_CYCLE_LISTENER_CLASS_AS_STRING = DEFAULT_CYCLE_LISTENER_CLASS.getName();
    private String warLocation = "reg:.*\\.war";
    private int serverPort = 9090;
    private String contextPath = "/its";
    private boolean startServer = true;
    private boolean deployWebapp = true;
    private boolean skip = false;
    private Class<? extends ServerLifeCycleListener> serverLifeCycleListenerClass = DEFAULT_CYCLE_LISTENER_CLASS;
    private Class<?> sourceClass;
    private Method sourceMethod;
    private JettyRunWar sourceConfig;

    public DefaultConfig() {
    }

    public DefaultConfig(Properties config) {
        try {
            this.setWarLocation(config.getProperty("warLocation", DEFAULT_WAR_LOCATION));
            this.setServerPort(Integer.parseInt(config.getProperty("serverPort", DEFAULT_SERVER_PORT_AS_STRING)));
            this.setContextPath(config.getProperty("contextPath", DEFAULT_CONTEXT_PATH));
            this.setStartServer(Boolean.parseBoolean(config.getProperty("startServer", DEFAULT_START_SERVER_AS_STRING)));
            this.setDeployWebapp(Boolean.parseBoolean(config.getProperty("deployWebapp", DEFAULT_DEPLOY_WEBAPP_AS_STRING)));
            this.setSkip(Boolean.parseBoolean(config.getProperty("skip", DEFAULT_SKIP_AS_STRING)));
            this.setServerLifeCycleListenerClass(Class.forName(config.getProperty("lifeCycleListenerClass", DEFAULT_CYCLE_LISTENER_CLASS_AS_STRING)));
        }
        catch (ClassNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public DefaultConfig(RawConfig config) {
        this.setWarLocation(config.getWarLocation());
        this.setContextPath(config.getContextPath());
        this.setServerPort(config.getServerPort());
        this.setStartServer(config.isStartServer());
        this.setDeployWebapp(config.isDeployWebapp());
        this.setSkip(config.isSkip());
        this.setServerLifeCycleListenerClass(config.getServerLifeCycleListenerClass());
    }

    @Override
    public URL getWarLocationUrl() {
        try {
            StrategyFileLocator fileLocator = new StrategyFileLocator();
            File file = fileLocator.locate(this.warLocation);
            URL url = file.toURI().toURL();
            return url;
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String getWarLocation() {
        return this.warLocation;
    }

    void setWarLocation(String warLocation) {
        this.warLocation = warLocation;
    }

    boolean isDefaultWarLocation() {
        return DEFAULT_WAR_LOCATION.equals(this.warLocation);
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    boolean isDefaultServerPort() {
        return 9090 == this.serverPort;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    boolean isDefaultContextPath() {
        return DEFAULT_CONTEXT_PATH.equals(this.contextPath);
    }

    @Override
    public boolean isStartServer() {
        return this.startServer;
    }

    void setStartServer(boolean startServer) {
        this.startServer = startServer;
    }

    boolean isDefaultStartServer() {
        return true == this.startServer;
    }

    @Override
    public boolean isDeployWebapp() {
        return this.deployWebapp;
    }

    void setDeployWebapp(boolean deployWebapp) {
        this.deployWebapp = deployWebapp;
    }

    boolean isDefaultDeployWebapp() {
        return true == this.deployWebapp;
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    boolean isDefaultSkip() {
        return false == this.skip;
    }

    @Override
    public ServerLifeCycleListener getServerLifeCycleListener() {
        try {
            return this.serverLifeCycleListenerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Class<? extends ServerLifeCycleListener> getServerLifeCycleListenerClass() {
        return this.serverLifeCycleListenerClass;
    }

    void setServerLifeCycleListenerClass(Class<? extends ServerLifeCycleListener> serverLifeCycleListenerClass) {
        this.serverLifeCycleListenerClass = serverLifeCycleListenerClass;
    }

    boolean isDefaultServerLifeCycleListenerClass() {
        return DEFAULT_CYCLE_LISTENER_CLASS.equals(this.serverLifeCycleListenerClass);
    }

    @Override
    public JettyRunWar getSourceConfig() {
        return this.sourceConfig;
    }

    void setSourceConfig(JettyRunWar sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    @Override
    public Method getSourceMethod() {
        return this.sourceMethod;
    }

    void setSourceMethod(Method sourceMethod) {
        this.sourceMethod = sourceMethod;
    }

    @Override
    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    void setSourceClass(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public String toString() {
        Objects.ToStringHelper toString = Objects.toStringHelper((Object)this);
        toString.add("warLocation", (Object)this.getWarLocation());
        toString.add("serverPort", (Object)Integer.toString(this.getServerPort()));
        toString.add("contextPath", (Object)this.getContextPath());
        toString.add("doStartServer", (Object)Boolean.toString(this.isStartServer()));
        toString.add("doDeployWebapp", (Object)Boolean.toString(this.isDeployWebapp()));
        toString.add("skip", (Object)Boolean.toString(this.isSkip()));
        toString.add("serverLifeCycleListenerClass", this.getServerLifeCycleListenerClass());
        return toString.toString();
    }

    public static boolean hasJettyPlugin(Method method) {
        boolean hasMethodAnno = method.isAnnotationPresent(JettyRunWar.class);
        boolean hasClassAnno = DefaultConfig.hasJettyPlugin(method.getDeclaringClass());
        boolean hasPlugin = hasMethodAnno && hasClassAnno || hasClassAnno;
        return hasPlugin;
    }

    public static boolean hasJettyPlugin(Class<?> klass) {
        boolean hasClassAnno = klass.isAnnotationPresent(JettyRunWar.class);
        return hasClassAnno;
    }

    public static Config configFrom(Method method) {
        if (!DefaultConfig.hasJettyPlugin(method)) {
            throw new IllegalArgumentException("at least " + method.getDeclaringClass() + " should be annotated with " + JettyRunWar.class);
        }
        JettyRunWar methodAnno = method.getAnnotation(JettyRunWar.class);
        boolean isMethodDefaultConfig = DEFAULT_CONFIG_CLASS.equals(methodAnno == null ? null : methodAnno.value());
        JettyRunWar classAnno = method.getDeclaringClass().getAnnotation(JettyRunWar.class);
        boolean isClassDefaultConfig = DEFAULT_CONFIG_CLASS.equals(classAnno == null ? null : classAnno.value());
        if (isClassDefaultConfig && isMethodDefaultConfig) {
            throw new IllegalArgumentException(method + " should not be annotated with " + JettyRunWar.class + " because it has the same configuration has its class " + method.getDeclaringClass());
        }
        if (!isClassDefaultConfig && isMethodDefaultConfig) {
            throw new IllegalArgumentException(method + " must be annotated with " + JettyRunWar.class + " and has a custom configuration because its class " + method.getDeclaringClass() + " has a custom configuration");
        }
        JettyRunWar sourceConfig = (JettyRunWar)Objects.firstNonNull((Object)methodAnno, (Object)classAnno);
        return DefaultConfig.configFrom(sourceConfig, method, method.getDeclaringClass());
    }

    public static Config configFrom(Class<?> klass) {
        if (!DefaultConfig.hasJettyPlugin(klass)) {
            throw new IllegalArgumentException("at least " + klass + " should be annotated with " + JettyRunWar.class);
        }
        JettyRunWar classAnno = klass.getAnnotation(JettyRunWar.class);
        return DefaultConfig.configFrom(classAnno, null, klass);
    }

    private static DefaultConfig configFrom(JettyRunWar sourceConfig, Method method, Class<?> klass) {
        try {
            RawConfig rawConfig = sourceConfig.value().newInstance();
            DefaultConfig config = new DefaultConfig(rawConfig);
            config.setSourceConfig(sourceConfig);
            config.setSourceMethod(method);
            config.setSourceClass(klass);
            return config;
        }
        catch (InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

