/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.identitygovernance.models.UserProcessingResult;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserProcessingResultReferenceRequest
extends BaseReferenceRequest<UserProcessingResult> {
    public UserProcessingResultReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserProcessingResult.class);
    }

    @Nonnull
    public UserProcessingResultReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public UserProcessingResultReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<UserProcessingResult> putAsync(@Nonnull UserProcessingResult srcUserProcessingResult) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/identityGovernance/lifecycleWorkflows/{id}/deletedItems/{id}/workflows/{id}/executionScope/" + srcUserProcessingResult.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public UserProcessingResult put(@Nonnull UserProcessingResult srcUserProcessingResult) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/identityGovernance/lifecycleWorkflows/{id}/deletedItems/{id}/workflows/{id}/executionScope/" + srcUserProcessingResult.id));
        return (UserProcessingResult)this.send(HttpMethod.PUT, payload);
    }
}

