/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.c3p0.stmt.StatementCacheKey;
import com.mchange.v2.io.IndentedWriter;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.util.ResourceClosedException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GooGooStatementCache {
    private static final MLogger logger = MLog.getLogger(GooGooStatementCache.class);
    private static final int DESTROY_NEVER = 0;
    private static final int DESTROY_IF_CHECKED_IN = 1;
    private static final int DESTROY_IF_CHECKED_OUT = 2;
    private static final int DESTROY_ALWAYS = 3;
    final ReentrantLock mainLock = new ReentrantLock();
    final Condition conditionStatementPerhapsAcquired = this.mainLock.newCondition();
    final boolean cancelAutomaticallyClosedStatements;
    private static final boolean CULL_ONLY_FROM_UNUSED_CONNECTIONS = false;
    ConnectionStatementManager cxnStmtMgr;
    HashMap stmtToKey = new HashMap();
    HashMap keyToKeyRec = new HashMap();
    HashSet checkedOut = new HashSet();
    AsynchronousRunner blockingTaskAsyncRunner;
    StatementDestructionManager destructo;
    final HashSet removalPending = new HashSet();
    final Lock removalPendingLock = new ReentrantLock();

    public GooGooStatementCache(AsynchronousRunner asynchronousRunner, AsynchronousRunner asynchronousRunner2, boolean bl) {
        this.blockingTaskAsyncRunner = asynchronousRunner;
        this.cxnStmtMgr = this.createConnectionStatementManager();
        this.destructo = asynchronousRunner2 != null ? new CautiousStatementDestructionManager(asynchronousRunner2) : new IncautiousStatementDestructionManager(asynchronousRunner);
        this.cancelAutomaticallyClosedStatements = bl;
    }

    public int getNumStatements() {
        this.mainLock.lock();
        try {
            int n = this.isClosed() ? -1 : this.countCachedStatements();
            return n;
        }
        finally {
            this.mainLock.unlock();
        }
    }

    public int getNumStatementsCheckedOut() {
        this.mainLock.lock();
        try {
            int n = this.isClosed() ? -1 : this.checkedOut.size();
            return n;
        }
        finally {
            this.mainLock.unlock();
        }
    }

    public int getNumConnectionsWithCachedStatements() {
        this.mainLock.lock();
        try {
            int n = this.isClosed() ? -1 : this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
            return n;
        }
        finally {
            this.mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpStatementCacheStatus() {
        this.mainLock.lock();
        try {
            if (this.isClosed()) {
                String string = this + "status: Closed.";
                return string;
            }
            StringWriter stringWriter = new StringWriter(2048);
            IndentedWriter indentedWriter = new IndentedWriter((Writer)stringWriter);
            try {
                indentedWriter.print((Object)this);
                indentedWriter.println(" status:");
                indentedWriter.upIndent();
                indentedWriter.println("core stats:");
                indentedWriter.upIndent();
                indentedWriter.print("num cached statements: ");
                indentedWriter.println(this.countCachedStatements());
                indentedWriter.print("num cached statements in use: ");
                indentedWriter.println(this.checkedOut.size());
                indentedWriter.print("num connections with cached statements: ");
                indentedWriter.println(this.cxnStmtMgr.getNumConnectionsWithCachedStatements());
                indentedWriter.downIndent();
                indentedWriter.println("cached statement dump:");
                indentedWriter.upIndent();
                for (Connection connection : this.cxnStmtMgr.connectionSet()) {
                    indentedWriter.print((Object)connection);
                    indentedWriter.println(':');
                    indentedWriter.upIndent();
                    Iterator iterator = this.cxnStmtMgr.statementSet(connection).iterator();
                    while (iterator.hasNext()) {
                        indentedWriter.println(iterator.next());
                    }
                    indentedWriter.downIndent();
                }
                indentedWriter.downIndent();
                indentedWriter.downIndent();
                String string = stringWriter.toString();
                return string;
            }
            catch (IOException iOException) {
                if (logger.isLoggable(MLevel.SEVERE)) {
                    logger.log(MLevel.SEVERE, "Huh? We've seen an IOException writing to s StringWriter?!", (Throwable)iOException);
                }
                String string = iOException.toString();
                this.mainLock.unlock();
                return string;
            }
        }
        finally {
            this.mainLock.unlock();
        }
    }

    public void waitMarkConnectionInUse(Connection connection) throws InterruptedException {
        this.destructo.waitMarkConnectionInUse(connection);
    }

    public boolean tryMarkConnectionInUse(Connection connection) {
        return this.destructo.tryMarkConnectionInUse(connection);
    }

    public void unmarkConnectionInUse(Connection connection) {
        this.destructo.unmarkConnectionInUse(connection);
    }

    public Boolean inUse(Connection connection) {
        return this.destructo.tvlInUse(connection);
    }

    public int getStatementDestroyerNumConnectionsInUse() {
        return this.destructo.getNumConnectionsInUse();
    }

    public int getStatementDestroyerNumConnectionsWithDeferredDestroyStatements() {
        return this.destructo.getNumConnectionsWithDeferredDestroyStatements();
    }

    public int getStatementDestroyerNumDeferredDestroyStatements() {
        return this.destructo.getNumDeferredDestroyStatements();
    }

    abstract ConnectionStatementManager createConnectionStatementManager();

    public Object checkoutStatement(Connection connection, Method method, Object[] objectArray) throws SQLException, ResourceClosedException {
        this.mainLock.lock();
        try {
            Object object = null;
            StatementCacheKey statementCacheKey = StatementCacheKey.find(connection, method, objectArray);
            LinkedList linkedList = this.checkoutQueue(statementCacheKey);
            if (linkedList == null || linkedList.isEmpty()) {
                object = this.acquireStatement(connection, method, objectArray);
                if (this.prepareAssimilateNewStatement(connection)) {
                    this.assimilateNewCheckedOutStatement(statementCacheKey, connection, object);
                }
            } else {
                logger.finest(this.getClass().getName() + " ----> CACHE HIT");
                object = linkedList.get(0);
                linkedList.remove(0);
                if (!this.checkedOut.add(object)) {
                    throw new RuntimeException("Internal inconsistency: Checking out a statement marked as already checked out!");
                }
                this.removeStatementFromDeathmarches(object, connection);
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("checkoutStatement: " + this.statsString());
            }
            Object object2 = object;
            return object2;
        }
        catch (NullPointerException nullPointerException) {
            if (this.checkedOut == null) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "A client attempted to work with a closed Statement cache, provoking a NullPointerException. c3p0 recovers, but this should be rare.", (Throwable)nullPointerException);
                }
                throw new ResourceClosedException((Throwable)nullPointerException);
            }
            throw nullPointerException;
        }
        finally {
            this.mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkinStatement(Object object) throws SQLException {
        this.mainLock.lock();
        try {
            if (this.checkedOut == null) {
                this.destructo.synchronousDestroyStatement(object);
                return;
            }
            if (!this.checkedOut.remove(object)) {
                if (!this.ourResource(object)) {
                    this.destructo.uncheckedDestroyStatement(object);
                }
                return;
            }
            try {
                this.refreshStatement((PreparedStatement)object);
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "Problem with checked-in Statement, discarding.", (Throwable)exception);
                }
                this.checkedOut.add(object);
                this.removeStatement(object, 3);
                this.mainLock.unlock();
                return;
            }
            StatementCacheKey statementCacheKey = (StatementCacheKey)this.stmtToKey.get(object);
            if (statementCacheKey == null) {
                throw new RuntimeException("Internal inconsistency: A checked-out statement has no key associated with it!");
            }
            LinkedList linkedList = this.checkoutQueue(statementCacheKey);
            linkedList.add(object);
            this.addStatementToDeathmarches(object, statementCacheKey.physicalConnection);
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("checkinStatement(): " + this.statsString());
            }
        }
        finally {
            this.mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkinAll(Connection connection) throws SQLException {
        this.mainLock.lock();
        try {
            HashSet hashSet = this.cxnStmtMgr.statementSet(connection);
            if (hashSet != null) {
                Set set = (Set)hashSet.clone();
                for (Object e : set) {
                    if (!this.checkedOut.contains(e)) continue;
                    this.checkinStatement(e);
                }
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.log(MLevel.FINEST, "checkinAll(): " + this.statsString());
            }
        }
        finally {
            this.mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(Connection connection) throws SQLException {
        if (!this.isClosed()) {
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.log(MLevel.FINEST, "ENTER METHOD: closeAll( " + connection + " )! -- num_connections: " + this.cxnStmtMgr.getNumConnectionsWithCachedStatements());
            }
            HashSet hashSet = null;
            this.mainLock.lock();
            try {
                HashSet hashSet2 = this.cxnStmtMgr.statementSet(connection);
                if (hashSet2 != null) {
                    hashSet = (HashSet)hashSet2.clone();
                    for (Object e : hashSet) {
                        this.removeStatement(e, 0);
                    }
                }
            }
            finally {
                this.mainLock.unlock();
            }
            if (hashSet != null) {
                for (Iterator iterator : hashSet) {
                    this.destructo.synchronousDestroyStatement(iterator);
                }
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("closeAll(): " + this.statsString());
            }
        }
    }

    public void close() throws SQLException {
        this.mainLock.lock();
        try {
            if (!this.isClosed()) {
                Iterator iterator = this.stmtToKey.keySet().iterator();
                while (iterator.hasNext()) {
                    this.destructo.synchronousDestroyStatement(iterator.next());
                }
                this.destructo.close();
                this.cxnStmtMgr = null;
                this.stmtToKey = null;
                this.keyToKeyRec = null;
                this.checkedOut = null;
            } else if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, this + ": duplicate call to close() [not harmful! -- debug only!]", (Throwable)new Exception("DUPLICATE CLOSE DEBUG STACK TRACE."));
            }
        }
        finally {
            this.mainLock.unlock();
        }
    }

    public boolean isClosed() {
        this.mainLock.lock();
        try {
            boolean bl = this.cxnStmtMgr == null;
            return bl;
        }
        finally {
            this.mainLock.unlock();
        }
    }

    abstract boolean prepareAssimilateNewStatement(Connection var1);

    abstract void addStatementToDeathmarches(Object var1, Connection var2);

    abstract void removeStatementFromDeathmarches(Object var1, Connection var2);

    final int countCachedStatements() {
        return this.stmtToKey.size();
    }

    private void assimilateNewCheckedOutStatement(StatementCacheKey statementCacheKey, Connection connection, Object object) {
        this.stmtToKey.put(object, statementCacheKey);
        HashSet hashSet = this.keySet(statementCacheKey);
        if (hashSet == null) {
            this.keyToKeyRec.put(statementCacheKey, new KeyRec());
        } else {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Multiply-cached PreparedStatement: " + statementCacheKey.stmtText);
            }
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("(The same statement has already been prepared by this Connection, and that other instance has not yet been closed, so the statement pool has to prepare a second PreparedStatement object rather than reusing the previously-cached Statement. The new Statement will be cached, in case you frequently need multiple copies of this Statement.)");
            }
        }
        this.keySet(statementCacheKey).add(object);
        this.cxnStmtMgr.addStatementForConnection(object, connection);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("assimilateNewCheckedOutStatement(...) -- cxnStmtMgr.statementSet( " + connection + " ).size(): " + this.cxnStmtMgr.statementSet(connection).size());
        }
        this.checkedOut.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStatement(Object object, int n) {
        boolean bl;
        boolean bl2;
        this.removalPendingLock.lock();
        try {
            if (this.removalPending.contains(object)) {
                return;
            }
            this.removalPending.add(object);
        }
        finally {
            this.removalPendingLock.unlock();
        }
        StatementCacheKey statementCacheKey = (StatementCacheKey)this.stmtToKey.remove(object);
        this.removeFromKeySet(statementCacheKey, object);
        Connection connection = statementCacheKey.physicalConnection;
        boolean bl3 = bl2 = !this.checkedOut.contains(object);
        if (bl2) {
            this.removeStatementFromDeathmarches(object, connection);
            this.removeFromCheckoutQueue(statementCacheKey, object);
            if ((n & 1) != 0) {
                this.destructo.deferredDestroyStatement(connection, object);
            }
        } else {
            this.checkedOut.remove(object);
            if ((n & 2) != 0) {
                this.destructo.deferredDestroyStatement(connection, object);
            }
        }
        if (!(bl = this.cxnStmtMgr.removeStatementForConnection(object, connection)) && logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, this + " removed a statement that apparently wasn't in a statement set!!!", (Throwable)new Exception("LOG STACK TRACE"));
        }
        this.removalPendingLock.lock();
        try {
            this.removalPending.remove(object);
        }
        finally {
            this.removalPendingLock.unlock();
        }
    }

    private Object acquireStatement(final Connection connection, final Method method, final Object[] objectArray) throws SQLException {
        try {
            final Object[] objectArray2 = new Object[1];
            final Throwable[] throwableArray = new Throwable[1];
            class StmtAcquireTask
            implements Runnable {
                StmtAcquireTask() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        objectArray2[0] = method.invoke((Object)connection, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable;
                        throwableArray[0] = throwable = invocationTargetException.getTargetException();
                    }
                    catch (Exception exception) {
                        throwableArray[0] = exception;
                    }
                    catch (Throwable throwable) {
                        if (logger.isLoggable(MLevel.SEVERE)) {
                            logger.log(MLevel.SEVERE, "An unexpected Error (or other non-Exception Throwable) occurred while trying to produce a cacheable PreparedStatement.", throwable);
                        }
                        throwableArray[0] = throwable;
                    }
                    finally {
                        GooGooStatementCache.this.mainLock.lock();
                        try {
                            GooGooStatementCache.this.conditionStatementPerhapsAcquired.signalAll();
                        }
                        finally {
                            GooGooStatementCache.this.mainLock.unlock();
                        }
                    }
                }
            }
            StmtAcquireTask stmtAcquireTask = new StmtAcquireTask();
            this.blockingTaskAsyncRunner.postRunnable((Runnable)stmtAcquireTask);
            while (objectArray2[0] == null && throwableArray[0] == null) {
                this.conditionStatementPerhapsAcquired.await();
            }
            Throwable throwable = throwableArray[0];
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw new SQLException("A problem occurred while trying to acquire a cached PreparedStatement in a background thread.", throwableArray[0]);
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new Error("Unexpected non-Error, non-Exception Throwable while trying to acquire a cached PreparedStatement in a background thread: " + throwable, throwable);
            }
            Object object = objectArray2[0];
            return object;
        }
        catch (InterruptedException interruptedException) {
            throw SqlUtils.toSQLException((Throwable)interruptedException);
        }
    }

    private KeyRec keyRec(StatementCacheKey statementCacheKey) {
        return (KeyRec)this.keyToKeyRec.get(statementCacheKey);
    }

    private HashSet keySet(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.allStmts;
    }

    private boolean removeFromKeySet(StatementCacheKey statementCacheKey, Object object) {
        HashSet hashSet = this.keySet(statementCacheKey);
        boolean bl = hashSet.remove(object);
        if (hashSet.isEmpty() && this.checkoutQueue(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private LinkedList checkoutQueue(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.checkoutQueue;
    }

    private boolean removeFromCheckoutQueue(StatementCacheKey statementCacheKey, Object object) {
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        boolean bl = linkedList.remove(object);
        if (!bl && !object.equals(object)) {
            String string = "Apparent JDBC Driver Bug! PreparedStatement.equals(...) is improperly implemented (perhaps as a naive dynamic proxy?) A PreparedStatement fails to equal itself! PreparedStatement caching will be pathological under these circumstances. Please turn it off, set configuration parameters maxStatements and maxStatementsPerConnection both to 0.";
            throw new RuntimeException(string);
        }
        if (linkedList.isEmpty() && this.keySet(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private boolean ourResource(Object object) {
        return this.stmtToKey.keySet().contains(object);
    }

    private void refreshStatement(PreparedStatement preparedStatement) throws Exception {
        preparedStatement.clearParameters();
        preparedStatement.clearBatch();
    }

    private void printStats() {
        int n = this.countCachedStatements();
        int n2 = this.checkedOut.size();
        int n3 = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int n4 = this.keyToKeyRec.size();
        System.err.print(this.getClass().getName() + " stats -- ");
        System.err.print("total size: " + n);
        System.err.print("; checked out: " + n2);
        System.err.print("; num connections: " + n3);
        System.err.println("; num keys: " + n4);
    }

    private String statsString() {
        int n = this.countCachedStatements();
        int n2 = this.checkedOut.size();
        int n3 = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int n4 = this.keyToKeyRec.size();
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" stats -- ");
        stringBuffer.append("total size: ");
        stringBuffer.append(n);
        stringBuffer.append("; checked out: ");
        stringBuffer.append(n2);
        stringBuffer.append("; num connections: ");
        stringBuffer.append(n3);
        int n5 = this.destructo.countConnectionsInUse();
        if (n5 >= 0) {
            stringBuffer.append("; num connections in use: ");
            stringBuffer.append(n5);
        }
        stringBuffer.append("; num keys: ");
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    private final class CautiousStatementDestructionManager
    extends StatementDestructionManager {
        HashSet inUseConnections;
        HashMap connectionsToZombieStatementSets;
        AsynchronousRunner deferredStatementDestroyer;
        boolean closed;
        final ReentrantLock csdmLock;
        final Condition statementsMaybeDestroyed;

        @Override
        void close() {
            this.csdmLock.lock();
            try {
                this.closed = true;
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        CautiousStatementDestructionManager(AsynchronousRunner asynchronousRunner) {
            super(asynchronousRunner);
            this.inUseConnections = new HashSet();
            this.connectionsToZombieStatementSets = new HashMap();
            this.closed = false;
            this.csdmLock = new ReentrantLock();
            this.statementsMaybeDestroyed = this.csdmLock.newCondition();
            this.deferredStatementDestroyer = asynchronousRunner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String trace() {
            Set set = this.connectionsToZombieStatementSets.keySet();
            int n = 0;
            for (Object k : set) {
                Set set2;
                Set set3 = set2 = (Set)this.connectionsToZombieStatementSets.get(k);
                synchronized (set3) {
                    n += set2 == null ? 0 : set2.size();
                }
            }
            return this.getClass().getName() + " [connections in use: " + this.inUseConnections.size() + "; connections with deferred statements: " + set.size() + "; statements to destroy: " + n + "]";
        }

        private void printAllStats() {
            GooGooStatementCache.this.printStats();
            System.err.println(this.trace());
        }

        @Override
        void waitMarkConnectionInUse(Connection connection) throws InterruptedException {
            this.csdmLock.lock();
            try {
                if (!this.closed) {
                    Set set = this.statementsUnderDestruction(connection);
                    if (set != null) {
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "A connection is waiting to be accepted by the Statement cache because " + set.size() + " cached Statements are still being destroyed.");
                        }
                        while (!set.isEmpty()) {
                            this.statementsMaybeDestroyed.await();
                        }
                    }
                    this.inUseConnections.add(connection);
                }
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean tryMarkConnectionInUse(Connection connection) {
            this.csdmLock.lock();
            try {
                if (!this.closed) {
                    Set set = this.statementsUnderDestruction(connection);
                    if (set != null) {
                        int n = set.size();
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "A connection could not be accepted by the Statement cache because " + n + " cached Statements are still being destroyed.");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    this.inUseConnections.add(connection);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void unmarkConnectionInUse(Connection connection) {
            this.csdmLock.lock();
            try {
                boolean bl = this.inUseConnections.remove(connection);
                Set set = (Set)this.connectionsToZombieStatementSets.get(connection);
                if (set != null) {
                    this.destroyAllTrackedStatements(connection);
                }
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void deferredDestroyStatement(Object object, Object object2) {
            this.csdmLock.lock();
            try {
                if (!this.closed) {
                    if (this.inUseConnections.contains(object)) {
                        Set<Object> set = (Set<Object>)this.connectionsToZombieStatementSets.get(object);
                        if (set == null) {
                            set = Collections.synchronizedSet(new HashSet());
                            this.connectionsToZombieStatementSets.put(object, set);
                        }
                        set.add(object2);
                    } else {
                        this.uncheckedDestroyStatement(object2);
                    }
                } else {
                    this.uncheckedDestroyStatement(object2);
                }
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        @Override
        int countConnectionsInUse() {
            this.csdmLock.lock();
            try {
                int n = this.inUseConnections.size();
                return n;
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        @Override
        boolean knownInUse(Connection connection) {
            this.csdmLock.lock();
            try {
                boolean bl = this.inUseConnections.contains(connection);
                return bl;
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        @Override
        Boolean tvlInUse(Connection connection) {
            return this.knownInUse(connection);
        }

        @Override
        int getNumConnectionsInUse() {
            this.csdmLock.lock();
            try {
                int n = this.inUseConnections.size();
                return n;
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        @Override
        int getNumConnectionsWithDeferredDestroyStatements() {
            this.csdmLock.lock();
            try {
                int n = this.connectionsToZombieStatementSets.keySet().size();
                return n;
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int getNumDeferredDestroyStatements() {
            this.csdmLock.lock();
            try {
                Set set = this.connectionsToZombieStatementSets.keySet();
                int n = 0;
                for (Object k : set) {
                    Set set2;
                    Set set3 = set2 = (Set)this.connectionsToZombieStatementSets.get(k);
                    synchronized (set3) {
                        n += set2 == null ? 0 : set2.size();
                    }
                }
                int n2 = n;
                return n2;
            }
            finally {
                this.csdmLock.unlock();
            }
        }

        private void trackedDestroyStatement(final Object object, final Object object2) {
            final class TrackedStatementCloseTask
            implements Runnable {
                TrackedStatementCloseTask() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CautiousStatementDestructionManager.this.csdmLock.lock();
                    try {
                        Set set = (Set)CautiousStatementDestructionManager.this.connectionsToZombieStatementSets.get(object);
                        if (set != null) {
                            StatementUtils.attemptClose((Statement)((PreparedStatement)object2));
                            boolean bl = set.remove(object2);
                            assert (bl);
                            if (set.isEmpty()) {
                                Object v = CautiousStatementDestructionManager.this.connectionsToZombieStatementSets.remove(object);
                                assert (v == set);
                                CautiousStatementDestructionManager.this.statementsMaybeDestroyed.signalAll();
                            }
                        }
                    }
                    finally {
                        CautiousStatementDestructionManager.this.csdmLock.unlock();
                    }
                }
            }
            TrackedStatementCloseTask trackedStatementCloseTask = new TrackedStatementCloseTask();
            if (!this.closed) {
                this.deferredStatementDestroyer.postRunnable((Runnable)trackedStatementCloseTask);
            } else {
                trackedStatementCloseTask.run();
            }
        }

        private void destroyAllTrackedStatements(final Object object) {
            final class TrackedDestroyAllStatementsTask
            implements Runnable {
                TrackedDestroyAllStatementsTask() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CautiousStatementDestructionManager.this.csdmLock.lock();
                    try {
                        Set set = (Set)CautiousStatementDestructionManager.this.connectionsToZombieStatementSets.remove(object);
                        if (set != null) {
                            Iterator iterator = set.iterator();
                            while (iterator.hasNext()) {
                                PreparedStatement preparedStatement = (PreparedStatement)iterator.next();
                                StatementUtils.attemptClose((Statement)preparedStatement);
                                iterator.remove();
                            }
                            CautiousStatementDestructionManager.this.statementsMaybeDestroyed.signalAll();
                        }
                    }
                    finally {
                        CautiousStatementDestructionManager.this.csdmLock.unlock();
                    }
                }
            }
            TrackedDestroyAllStatementsTask trackedDestroyAllStatementsTask = new TrackedDestroyAllStatementsTask();
            if (!this.closed) {
                this.deferredStatementDestroyer.postRunnable((Runnable)trackedDestroyAllStatementsTask);
            } else {
                trackedDestroyAllStatementsTask.run();
            }
        }

        private Set statementsUnderDestruction(Object object) {
            assert (this.csdmLock.isHeldByCurrentThread());
            return (Set)this.connectionsToZombieStatementSets.get(object);
        }
    }

    private final class IncautiousStatementDestructionManager
    extends StatementDestructionManager {
        IncautiousStatementDestructionManager(AsynchronousRunner asynchronousRunner) {
            super(asynchronousRunner);
        }

        @Override
        void waitMarkConnectionInUse(Connection connection) throws InterruptedException {
        }

        @Override
        boolean tryMarkConnectionInUse(Connection connection) {
            return true;
        }

        @Override
        void unmarkConnectionInUse(Connection connection) {
        }

        @Override
        void deferredDestroyStatement(Object object, Object object2) {
            this.uncheckedDestroyStatement(object2);
        }

        @Override
        void close() {
        }

        @Override
        int countConnectionsInUse() {
            return -1;
        }

        @Override
        boolean knownInUse(Connection connection) {
            return false;
        }

        @Override
        Boolean tvlInUse(Connection connection) {
            return null;
        }

        @Override
        int getNumConnectionsInUse() {
            return -1;
        }

        @Override
        int getNumConnectionsWithDeferredDestroyStatements() {
            return -1;
        }

        @Override
        int getNumDeferredDestroyStatements() {
            return -1;
        }
    }

    private abstract class StatementDestructionManager {
        AsynchronousRunner runner;

        StatementDestructionManager(AsynchronousRunner asynchronousRunner) {
            this.runner = asynchronousRunner;
        }

        abstract void waitMarkConnectionInUse(Connection var1) throws InterruptedException;

        abstract boolean tryMarkConnectionInUse(Connection var1);

        abstract void unmarkConnectionInUse(Connection var1);

        abstract void deferredDestroyStatement(Object var1, Object var2);

        abstract int countConnectionsInUse();

        abstract boolean knownInUse(Connection var1);

        abstract Boolean tvlInUse(Connection var1);

        abstract int getNumConnectionsInUse();

        abstract int getNumConnectionsWithDeferredDestroyStatements();

        abstract int getNumDeferredDestroyStatements();

        abstract void close();

        void cancelClose(PreparedStatement preparedStatement) {
            try {
                if (GooGooStatementCache.this.cancelAutomaticallyClosedStatements) {
                    boolean bl = logger.isLoggable(MLevel.FINEST);
                    if (bl) {
                        logger.log(MLevel.FINEST, "Canceling cached statement prior to autoclose.");
                    }
                    preparedStatement.cancel();
                    if (bl) {
                        logger.log(MLevel.FINEST, "Canceled cached statement prior to autoclose.");
                    }
                }
            }
            catch (SQLException sQLException) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "An Exception occurred while trying to cancel an unclosed Statement we are about to close. (Because cancelAutomaticallyClosedStatements is set to true, we make one best-effort attempt to cancel. No action is necessary.)", (Throwable)sQLException);
                }
            }
            finally {
                StatementUtils.attemptClose((Statement)preparedStatement);
            }
        }

        final void uncheckedDestroyStatement(final Object object) {
            class UncheckedStatementCloseTask
            implements Runnable {
                UncheckedStatementCloseTask() {
                }

                @Override
                public void run() {
                    StatementDestructionManager.this.cancelClose((PreparedStatement)object);
                }
            }
            UncheckedStatementCloseTask uncheckedStatementCloseTask = new UncheckedStatementCloseTask();
            this.runner.postRunnable((Runnable)uncheckedStatementCloseTask);
        }

        final void synchronousDestroyStatement(Object object) {
            this.cancelClose((PreparedStatement)object);
        }
    }

    protected final class DeathmarchConnectionStatementManager
    extends ConnectionStatementManager {
        Map cxnsToDms = new HashMap();

        protected DeathmarchConnectionStatementManager() {
        }

        @Override
        public void addStatementForConnection(Object object, Connection connection) {
            super.addStatementForConnection(object, connection);
            Deathmarch deathmarch = (Deathmarch)this.cxnsToDms.get(connection);
            if (deathmarch == null) {
                deathmarch = new Deathmarch();
                this.cxnsToDms.put(connection, deathmarch);
            }
        }

        @Override
        public boolean removeStatementForConnection(Object object, Connection connection) {
            boolean bl = super.removeStatementForConnection(object, connection);
            if (bl && this.statementSet(connection) == null) {
                this.cxnsToDms.remove(connection);
            }
            return bl;
        }

        public Deathmarch getDeathmarch(Connection connection) {
            return (Deathmarch)this.cxnsToDms.get(connection);
        }
    }

    protected static final class SimpleConnectionStatementManager
    extends ConnectionStatementManager {
        protected SimpleConnectionStatementManager() {
        }
    }

    protected static abstract class ConnectionStatementManager {
        Map cxnToStmtSets = new HashMap();

        protected ConnectionStatementManager() {
        }

        public int getNumConnectionsWithCachedStatements() {
            return this.cxnToStmtSets.size();
        }

        public Set connectionSet() {
            return this.cxnToStmtSets.keySet();
        }

        public HashSet statementSet(Connection connection) {
            return (HashSet)this.cxnToStmtSets.get(connection);
        }

        public int getNumStatementsForConnection(Connection connection) {
            HashSet hashSet = this.statementSet(connection);
            return hashSet == null ? 0 : hashSet.size();
        }

        public void addStatementForConnection(Object object, Connection connection) {
            HashSet<Object> hashSet = this.statementSet(connection);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                this.cxnToStmtSets.put(connection, hashSet);
            }
            hashSet.add(object);
        }

        public boolean removeStatementForConnection(Object object, Connection connection) {
            boolean bl;
            HashSet hashSet = this.statementSet(connection);
            if (hashSet != null) {
                bl = hashSet.remove(object);
                if (hashSet.isEmpty()) {
                    this.cxnToStmtSets.remove(connection);
                }
            } else {
                bl = false;
            }
            return bl;
        }
    }

    protected class Deathmarch {
        TreeMap longsToStmts = new TreeMap();
        HashMap stmtsToLongs = new HashMap();
        long last_long = -1L;

        protected Deathmarch() {
        }

        public void deathmarchStatement(Object object) {
            assert (GooGooStatementCache.this.mainLock.isHeldByCurrentThread());
            Long l = (Long)this.stmtsToLongs.get(object);
            if (l != null) {
                throw new RuntimeException("Internal inconsistency: A statement is being double-deathmatched. no checked-out statements should be in a deathmarch already; no already checked-in statement should be deathmarched!");
            }
            l = this.getNextLong();
            this.stmtsToLongs.put(object, l);
            this.longsToStmts.put(l, object);
        }

        public void undeathmarchStatement(Object object) {
            assert (GooGooStatementCache.this.mainLock.isHeldByCurrentThread());
            Long l = (Long)this.stmtsToLongs.remove(object);
            if (l == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
            Object v = this.longsToStmts.remove(l);
            if (l == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
        }

        boolean cullNext() {
            assert (GooGooStatementCache.this.mainLock.isHeldByCurrentThread());
            Object var1_1 = null;
            StatementCacheKey statementCacheKey = null;
            for (Object v : this.longsToStmts.values()) {
                if (GooGooStatementCache.this.checkedOut.contains(v)) continue;
                var1_1 = v;
                break;
            }
            if (var1_1 == null) {
                return false;
            }
            if (statementCacheKey == null) {
                statementCacheKey = (StatementCacheKey)GooGooStatementCache.this.stmtToKey.get(var1_1);
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("CULLING: " + statementCacheKey.stmtText);
            }
            GooGooStatementCache.this.removeStatement(var1_1, 3);
            if (this.contains(var1_1)) {
                throw new RuntimeException("Inconsistency!!! Statement culled from deathmarch failed to be removed by removeStatement( ... )!");
            }
            return true;
        }

        public boolean contains(Object object) {
            return this.stmtsToLongs.keySet().contains(object);
        }

        public int size() {
            return this.longsToStmts.size();
        }

        private Long getNextLong() {
            return new Long(++this.last_long);
        }
    }

    private static class KeyRec {
        HashSet allStmts = new HashSet();
        LinkedList checkoutQueue = new LinkedList();

        private KeyRec() {
        }
    }
}

