/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiConfigHelper;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.ChangeLogHandler;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferEditHandler;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.widget.SwingSession;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.WikittyExtension;

@DefaultApplicationContext.AutoLoad
public class VradiMainUIHandler {
    private static Log log = LogFactory.getLog(VradiMainUIHandler.class);
    public static final String XML_FILE_EXTENSION = ".xml";

    public VradiMainUI initUI(JAXXContext rootContext, boolean fullscreen) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        VradiConfig config = VradiContext.get().getVradiConfig();
        SwingSession swingSession = new SwingSession(VradiConfigHelper.getSwingConfigFile(config), false);
        VradiContext.SWING_SESSION_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)swingSession);
        VradiMainUI ui = new VradiMainUI((JAXXContext)context);
        this.initLocalesMenu(ui);
        VradiContext.MAIN_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)ui);
        ErrorDialogUI.init((Frame)ui);
        if (fullscreen) {
            ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(ui);
        }
        OfferListHandler handler = UIHelper.getHandler((JAXXContext)context, OfferListHandler.class);
        OfferListUI content = handler.initUI((JAXXContext)ui);
        ui.setContentPane(content);
        ui.pack();
        ui.setVisible(true);
        swingSession.add((Component)ui);
        swingSession.save();
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), (Object)content);
        content.setDividerLocation(Integer.MAX_VALUE);
        content.setDividerSize(0);
        return ui;
    }

    public void initLocalesMenu(final VradiMainUI ui) {
        JMenu menuFileLanguages = ui.getMenuFileLanguage();
        List<Locale> localesAvailables = VradiContext.get().getLocalesAvailables();
        for (final Locale locale : localesAvailables) {
            String language = locale.getLanguage();
            Icon menuFileLanguageIcon = SwingUtil.getUIManagerActionIcon((String)("i18n-" + language));
            JMenuItem menuFileLanguage = new JMenuItem(I18n._((String)("vradi.action.locale." + language)), menuFileLanguageIcon);
            menuFileLanguage.setToolTipText(I18n._((String)("vradi.action.locale." + language + ".tip")));
            VradiConfig config = VradiContext.get().getVradiConfig();
            menuFileLanguage.setEnabled(!this.acceptLocale(VradiConfigHelper.getLocale(config), "fr_FR"));
            menuFileLanguage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VradiMainUIHandler.this.changeLanguage(ui, locale);
                }
            });
            menuFileLanguages.add(menuFileLanguage);
        }
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    public void changeContent(JAXXContext context, JComponent content) {
        VradiMainUI ui = this.getUI(context);
        ui.setContentPane(content);
        ui.setVisible(true);
    }

    public void edit(JAXXContext context, Form data) {
        OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
        this.changeContent((JAXXContext)VradiContext.get(), handler.initUI(context, data.getWikittyId()));
    }

    public void goToHome(JAXXContext context) {
        OfferListHandler handler = UIHelper.getHandler(context, OfferListHandler.class);
        this.changeContent(context, handler.initUI(context));
    }

    public void changeLanguage(VradiMainUI mainUI, Locale newLocale) {
        VradiConfig config = mainUI.getConfig();
        VradiConfigHelper.setLocale(config, newLocale);
        I18n.init((Locale)newLocale);
        this.reloadUI(VradiContext.get(), VradiConfigHelper.isFullScreen(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(VradiMainUI ui) {
        log.info((Object)"Vradi quitting...");
        UIHelper.getHandler((JAXXContext)ui, OfferListHandler.class).closeAllTabs();
        UIHelper.saveComponentDispositionConfig();
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            System.exit(0);
        }
    }

    public void changeScreen(VradiMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        VradiConfigHelper.setFullscreen(ui.getConfig(), fullscreen);
        this.reloadUI(VradiContext.get(), fullscreen);
    }

    protected void openAdminPopup(VradiMainUI rootContext, int tabIndex) {
        AdminHandler handler = UIHelper.getHandler((JAXXContext)rootContext, AdminHandler.class);
        AdminPopupUI ui = handler.init((JAXXContext)rootContext);
        ui.showTab(tabIndex);
        ui.setLocationRelativeTo(rootContext);
        ui.setVisible(true);
    }

    protected void openEmailPopup(VradiMainUI rootContext) {
        EmailPopupUI ui = UIHelper.getHandler((JAXXContext)rootContext, EmailHandler.class).init((JAXXContext)rootContext);
        ui.setLocationRelativeTo(rootContext);
        ui.setVisible(true);
    }

    public void showAdminClient(VradiMainUI context) {
        this.openAdminPopup(context, 0);
    }

    public void showAdminGroup(VradiMainUI context) {
        this.openAdminPopup(context, 1);
    }

    public void showAdminForm(VradiMainUI context) {
        this.openAdminPopup(context, 2);
    }

    public void showAdminXmlStream(VradiMainUI context) {
        this.openAdminPopup(context, 3);
    }

    public void showAdminThesaurus(VradiMainUI context) {
        this.openAdminPopup(context, 5);
    }

    public void showAdminStatus(VradiMainUI context) {
        this.openAdminPopup(context, 4);
    }

    public void showEmail(VradiMainUI context) {
        this.openEmailPopup(context);
    }

    public void showReindex(JAXXContext rootContext) {
        VradiMainUI mainUI = this.getUI(rootContext);
        mainUI.setCursor(Cursor.getPredefinedCursor(3));
        int answer = JOptionPane.showConfirmDialog(mainUI, I18n._((String)"vradi.reindex.message"), I18n._((String)"vradi.reindex.title"), 0);
        if (answer == 0) {
            VradiTask<Void> task = new VradiTask<Void>((JAXXContext)mainUI){

                @Override
                public Void doAction() throws Exception {
                    VradiService.getVradiStorageService().reindexData();
                    return null;
                }
            };
            task.execute();
        }
    }

    public void showOfferListUI(JAXXContext context) {
        final JFrame offerListFrame = new JFrame(I18n._((String)"vradi.title.welcome")){};
        offerListFrame.setDefaultCloseOperation(0);
        offerListFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UIHelper.saveComponentDispositionConfig();
                offerListFrame.dispose();
            }
        });
        UIHelper.registerComponentToSaveDispositionConfig(offerListFrame);
        OfferListHandler handler = UIHelper.getHandler(context, OfferListHandler.class);
        OfferListUI ui = handler.initUI(context);
        offerListFrame.setContentPane(ui);
        offerListFrame.pack();
        offerListFrame.setVisible(true);
    }

    public void showConfig(JAXXContext context) {
        VradiMainUI ui = this.getUI(context);
        VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
        ConfigUIHelper modelBuilder = new ConfigUIHelper((ApplicationConfig)config);
        modelBuilder.addCategory(I18n.n_((String)"vradi.config.category.directories"), I18n.n_((String)"vradi.config.category.directories.description"));
        modelBuilder.addOption((ApplicationConfig.OptionDef)VradiConfig.VradiSwingOption.CONFIG_FILE);
        modelBuilder.addCategory(I18n.n_((String)"vradi.config.category.other"), I18n.n_((String)"vradi.config.category.other.description"));
        modelBuilder.addOption((ApplicationConfig.OptionDef)VradiConfig.VradiSwingOption.FULL_SCREEN);
        modelBuilder.addOption((ApplicationConfig.OptionDef)VradiConfig.VradiSwingOption.LOCALE);
        modelBuilder.addCategory(I18n.n_((String)"vradi.config.category.remote"), I18n.n_((String)"vradi.config.category.remote.description"));
        modelBuilder.addOption((ApplicationConfig.OptionDef)VradiConfig.VradiSwingOption.REMOTE_ENDPOINT);
        modelBuilder.buildUI(context, "vradi.config.category.directories");
        modelBuilder.displayUI((Frame)ui, false);
    }

    public void showHelp(JAXXContext context, String helpId) {
    }

    public void closeHelp(JAXXContext context) {
    }

    public void gotoSite(JAXXContext rootContext) {
        VradiConfig config = (VradiConfig)((Object)rootContext.getContextValue(VradiConfig.class));
        URL siteURL = config.getOptionAsURL("application.site.url");
        log.debug((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(VradiMainUI ui) {
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;
        };
        about.setTitle(I18n._((String)"vradi.title.about"));
        ChangeLogHandler clh = UIHelper.getHandler((JAXXContext)ui, ChangeLogHandler.class);
        about.setAboutText(clh.getLatestChangeLog());
        String copyright = VradiConfigHelper.getCopyrightText(ui.getConfig());
        about.setBottomText(copyright);
        about.setLicenseFile("META-INF/vradi-swing-LICENSE.txt");
        about.setThirdpartyFile("META-INF/vradi-swing-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    public void showStat(VradiMainUI ui) {
        String msg = "Proxy call statistics\n";
        for (Map.Entry e : WikittyProxy.getCallCount().entrySet()) {
            msg = msg + "\n\t" + (String)e.getKey() + " = " + e.getValue();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)msg);
        }
        JOptionPane.showMessageDialog(ui, msg);
    }

    protected void reloadUI(VradiContext rootContext, boolean fullscreen) {
        ((VradiConfig)((Object)rootContext.getContextValue(VradiConfig.class))).removeJaxxPropertyChangeListener();
        VradiMainUI ui = this.getUI((JAXXContext)rootContext);
        if (ui != null) {
            ErrorDialogUI.init(null);
            VradiContext.MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            VradiContext.ADMIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            ui.dispose();
            ui.setVisible(false);
        }
        ui = this.initUI((JAXXContext)rootContext, fullscreen);
        ui.setVisible(true);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        VradiMainUI ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        return true;
    }

    VradiMainUI getUI(JAXXContext context) {
        if (context instanceof VradiMainUI) {
            return (VradiMainUI)context;
        }
        VradiMainUI ui = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public void createForm(WikittyExtension extension) {
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (ui != null) {
            log.debug((Object)("FormType selected : " + extension));
            if (extension == null) {
                return;
            }
            FormImpl formImpl = new FormImpl();
            formImpl.getWikitty().addExtension(extension);
            Form form = VradiHelper.initForm((Form)formImpl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating form with id : " + form.getWikittyId()));
            }
            ui.getHandler().addEditPane(ui.getDelegateContext(), form);
        }
    }
}

