/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: MultipleSelectionHandler.java 1884 2011-01-11 00:27:48Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/widgets/MultipleSelectionHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.widgets;

import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionPane;
import jaxx.runtime.SwingUtil;

import javax.swing.*;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * @author sletellier
 */
public abstract class MultipleSelectionHandler<D, B extends BusinessEntity, H> {

    protected MultipleSelectionPane<D, B> ui;
    protected Map<String, D> addedDatas;
    protected Class<H> handlerClass;

    public MultipleSelectionHandler(MultipleSelectionPane<D, B> ui, Class<H> handlerClass) {
        this.ui = ui;
        this.handlerClass = handlerClass;
        addedDatas = new HashMap<String, D>();
    }

    public H getHandler() {
        return UIHelper.getHandler(ui, handlerClass);
    }

    protected JList getList() {
        return ui.getList();
    }

    protected DefaultListModel getListModel() {
        return ui.getListModel();
    }

    protected B getBean() {
        return ui.getBean();
    }

    protected void setBean(B bean) {
        ui.setBean(bean);
    }

    public Collection<D> getAddedDatas() {
        return addedDatas.values();
    }

    public D getAddedData(String id) {
        return addedDatas.get(id);
    }

    public abstract void init();

    public abstract void add();

    public abstract void remove();

    public abstract void openSelected(String selected);

    protected void addToList(D addedData, String data) {
        if (data != null) {
            getListModel().addElement(data);
        }
        if (addedData != null) {
            addedDatas.put(data, addedData);
        }
    }

    protected void removeFromList(List<String> datas) {
        for (String data : datas) {
            getListModel().removeElement(data);
        }
    }

    protected void removeFromList(String data) {
        getListModel().removeElement(data);
    }

    protected void fillList(Collection<String> datas) {
        getList().removeAll();
        SwingUtil.fillList(getList(), datas, null);
    }

    protected java.util.List<String> getSelectedInList() {
        Object[] objects = getList().getSelectedValues();
        String[] selected = new String[objects.length];
        int cnt = 0;
        for (Object o : objects) {
            selected[cnt] = (String)o;
            cnt++;
        }
        java.util.List<String> selectedList = Arrays.asList(selected);
        return selectedList;
    }
}
