/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: SearchMultipleSelectionHandler.java 1870 2010-12-27 12:35:52Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/search/SearchMultipleSelectionHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * @author sletellier
 */
public class SearchMultipleSelectionHandler<B extends BusinessEntity> {

    public static final Log log = LogFactory.getLog(SearchMultipleSelectionHandler.class);

    public static final String VRADI_LIST_EMPTY = n_("vradi.criteria.empty");
    public static final String WIKITTY_ID = "wikittyId";

    protected Map<String, B> valuesAsMap;
    protected MultipleSelectionEditor<B> editor;
    protected Decorator<B> decorator;

    public SearchMultipleSelectionHandler(MultipleSelectionEditor<B> editor) {
        this.editor = editor;
        this.valuesAsMap = new HashMap<String, B>();
        decorator = VradiContext.get().getDecoratorProvider().getDecorator(editor.getBeanClass());
    }

    public String getValueAsString(B value) {
        return _(decorator.toString(value));
    }

    public String getValuesAsString(List<B> values) {
        StringBuilder builder = new StringBuilder();
        if (values !=  null) {
            for (B value : values) {
                builder.append(getValueAsString(value));
                builder.append(", ");
            }
        }
        String result = builder.toString();
        if (!StringUtils.isEmpty(result)) {
            result = result.substring(0, result.length() - 2);
        } else {
            result = _(VRADI_LIST_EMPTY);
        }

        // Abreviate long tool tips
        // TODO sletellier 13/12/10 : make it configurable
        result = StringUtils.abbreviate(result, 70);

        return getBold(result);
    }

    protected String getBold(String toBold) {
        StringBuilder result = new StringBuilder();
        result.append("<html><strong>").append(toBold).append("</strong></html>");
        return result.toString();
    }

    public Component getPopupUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        List<B> values = editor.getAllValues();
        List<B> selectedValues = editor.getSelectedValues();
        for (B value : values) {
            String valueAsString = getValueAsString(value);
            String id = value.getWikittyId();
            valuesAsMap.put(id, value);

            final JCheckBox checkBox = new JCheckBox(valueAsString);
            checkBox.putClientProperty(WIKITTY_ID, id);
            checkBox.setSelected(selectedValues.contains(value));
            checkBox.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent e) {
                    String id = (String)checkBox.getClientProperty(WIKITTY_ID);
                    B bean = valuesAsMap.get(id);
                    if (checkBox.isSelected()) {
                        editor.addSelectedValue(bean);
                    } else {
                        editor.removeSelectedValue(bean);
                    }
                }
            });

            panel.add(checkBox);
        }
        return new JScrollPane(panel);
    }

}
