/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class UrlEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<String, UrlEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_TEXT = "editor.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdm9iJE8JHLKxEBCmAJRBIaxASTRAEAhZEDiAcogg3rH2beKO9u2V3z7lQIH4CPwF6GiQ6KkRBTUGD+AsIUdAiZu9sXwwXYhQXe9bMvDdv3868/gY5reDkJg1DogLPcJeRpetra/eam6xlbjLdUlwaX0H8y2Qh24AJpx/XBk43ahZe6cIri74rfY95O9DzNRjXZlsw3WbMGDgxiGhpXan30/OhDFSPtS8qjfXlj+/ZF87zV1mAUKK6PF5lbi9UcpORGmS5Y2AKO3VoRVBvA2Uo7m2g3kkbWxRU67vUZU/gGYzWIC+pQjIDp4a/csQR4UNpYLK8qqjDbzkcay4YuNjyXbIZKK5dqlptpknH5knAib++zhRhUaUmD5WIQVJGbHkDOdd3mDBw+b85li0wISp0qOAOxYSB8wP+9RNEb6EvpG7P1V4wYZiMWyz6non8mbLuhV3Q0n3q7WyXj4sNlAaqVlhoqpwJx5ZNJeLKSzcCY3wP3SoOAOJwt1rB8QHlOFMkmank0TMNyKkAwwamG3+P4QNMxQM4/ccAWsIo+6tU/Pzu69tqb+rGsPex1NIdS4PTIJUvmTLctj4cj1xguKgsUznfgIJmAjcu2qjZFGH1bhrFYb+jFk4snNymuo0UudEv7z+UHn86ANkqjAufOlVq6+9AwbQVuuALJ5TXFiJFB7fG8DxiteFzCLrto5Vw6Aq+Kp1rcs9Bf6+GaMJsigl9Jc3Cx5/F+puFnhEZFDaza3liRu4R5LknuMeiBezuVurCTUjNAsdPdihtqzL2W5TdAZuLznLaTSdcGnI3cOv8adTgTBjYz9lIu/13bmiqUebRpmDOP2hKe9LYMNkXg70T94a40zBUIwY3cL8cvBWv5C4cM0OZcmkPht9qsfA5twYAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.UrlEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextField editor;
    protected com.jurismarches.vradi.ui.offer.editors.UrlEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.UrlEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private UrlEditor $VradiEditor0 = this;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
        validator.setBean(model);
        getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                .registerValidator(validator);
    }
    
    protected void browseURI() {
        try {
            UIHelper.browseURI(editor.getText().trim());
        } catch (IOException eee){
            log.error("Cannot display URL : " + editor.getText().trim());
            JOptionPane.showMessageDialog(null,
                    _("vradi.message.cannot.display.url"));
    
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UrlEditor() {
        super();
        $initialize();
    }

    public UrlEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.UrlEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        browseURI();
    }

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextField getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.offer.editors.UrlEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("value", editor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
        editorContent.add($JButton0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.offer.editors.UrlEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.UrlEditorModel >(com.jurismarches.vradi.ui.offer.editors.UrlEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        ((javax.swing.JPanel) editorContent).setMaximumSize(new Dimension(0, 28));
        editor.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        editor.setMinimumSize(new Dimension(0,28));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
    }

}