/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailEntityModel.java 1853 2010-12-22 17:40:16Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/models/EmailEntityModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author letellier
 */
public abstract class EmailEntityModel<E extends BusinessEntity> extends DefaultListModel implements VradiEntitiesListener<Sending> {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(EmailEntityModel.class);

    protected EmailFormsListCellRenderer renderer;
    protected Map<String, E> datas;
    protected Session session;
    protected Form form;

    public EmailEntityModel(EmailFormsListCellRenderer renderer, Session session, Form form){
        this.renderer = renderer;
        datas = new HashMap<String, E>();
        this.session = session;
        this.form = form;

        updateModel(session, form);

        VradiContext.get().getVradiNotifier().addVradiListener(Sending.class, this);
    }

    @Override
    public int getSize() {
        return datas.size();
    }

    public abstract void updateModel(Session session, Form form);

    @Override
    public Object getElementAt(int index) {
        List<String> keys = new ArrayList<String>(datas.keySet());
        return datas.get(keys.get(index));
    }

    protected void updateDatas(List<E> datas){
        if (datas == null) {
            return;
        }
//        datas.clear();
        for (E data : datas) {
            if (data != null) {
                this.datas.put(data.getWikittyId(), data);
            }
        }
        fireContentsChanged(this, 0, getSize());
    }

    protected void refresh() {
        if (log.isDebugEnabled()) {
            log.debug("Refresh datas");
        }

        session = VradiService.getWikittyProxy().restore(Session.class, session.getWikittyId());
        renderer.updateDatas(session, form.getWikittyId());
        updateModel(session, form);
    }

    @Override
    public void entitiesAdded(Set<Sending> added) {
        refreshIfNeeded(VradiHelper.extractIds(added));
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        refreshIfNeeded(removed);
    }

    protected void refreshIfNeeded(Collection<String> sendingsIds) {

        boolean mustBeRefresh = false;
        for (String sendingId : sendingsIds) {
            Session restoredSession = VradiService.getVradiDataService().getSessionBySending(sendingId);
            if (session.equals(restoredSession)) {
                mustBeRefresh = true;
                break;
            }
        }
        if (mustBeRefresh) {
            refresh();
        }
    }
}
