/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusEditUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_MOVED = "moved";
    public static final String PROPERTY_SAVE = "save";
    public static final String PROPERTY_TITLE_THESAURUS = "titleThesaurus";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PATH_FIELD_TEXT = "pathField.text";
    public static final String BINDING_TAGS_FIELD_TEXT = "tagsField.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8TRxieuHESJ3xHRER8KEAEVFXXEBCqGlq+LYLMh3CQEJaqjr1DPNHuzjDzbrK5VP0J7T9o71yQeuup6oFzD70g/kJVceCKeGe83vUmG2fF+rC2532fZ573nXce+9V/pKoVOb1Oo8hRYQDcZ879m8+ePeqssy7cYbqruAShSP81ViGVNplxk3UN5Gy7aeD1GF6/LXwpAhYMoZebZFrDlsd0jzEAcjKL6GpdbyXh5UiGasCaiMpj/e39/5Vf3J9/rxASSVQ3h6Us7IVKKxlvkgp3gRzBnTZo3aPBGspQPFhDvfvN2m2Pav2Q+uwl+YlMNsmEpArJgJwpXrLlsPhIAjkIPaZpqEJ91+XwdAXI1a7wnfVQce1T1cWos6Goy52QO9T1eeBIIUOpndUsUEpLOgFkvMNoAOTLXXhQFQfOhgiGoJpuMCCHTa2Oqd+5JYSHdGnKAUR7LMECOZQm95uV5k75wuUvOHPN98PpetUXGzsWJxdXacdjF4EcyxyZ3kROx8ZMZi1lX7zfpB3mIeKI0RDFqf1VkzQPpGblNtkL2A67ZL6fsmkJ5YxQLlOmoUIBOZejg9mY8zD0O4PELEUtwPFocObhIM1lZK2yCGwgC4jrtnKO51e4lEi9kO4jKfQSum3BaRNsMQ+vLJDZjIpbIYAIsumDfS7n7QN0TSf7nM8HXskB7sP583HY4l4c3dGLm4rRLCRuxVJOK2qLsfKLZsE+vt0ZvDQcVOR45gDRVZzUVdJrP9YmVRXiMk5ee6cRPcFQ34KObbMgQ2ijH+dm//3z3R+Nge/M495Hc1OHbBP9QCohmTKXEY2gbzohcK/+gMrlNqlpe4DWU0/kCGvFYRSH+/XvrIE796juIUV18u1ff8/9+M8XpNIg056gboOa/BU8057CLgjPjeT1G1bRvs0pfB4y2oBMeHRLYEPJgWsuBbrQ4YGLx/Z9hE04kdOEREmn9ubDbOv1jUEjxlDY/K7paTOqz8kEDzweMGvBsbvmWu6M1Cx0Reqieb46Zt6nZWwud+1zJa9SdCKXemgg1/rbL1BAD+uEwLBYg3pgqzCfHhUntZ5jws3PJxkHvCIjOE7uyWGWfzCP1XyG0wVU1GgI4rH5wRkh5WwBoql41rdGCCrCcxDHdtMKSo2shKyaoXvCNBvV6kL1hZo18I6V5ZlEnhZfK1dXcvK7MJwrPTtfldbwdZE7wLsjT7heuo7yDEulO3GltIarpTV8U4jh1xEM35WuohjDKA3Xi1wwFpj/GG4pmr1KMQyfAEokE1NLDQAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.ThesaurusEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Thesaurus bean;
    protected javax.swing.JTextArea commentField;
    protected java.lang.Boolean modified;
    protected java.lang.Boolean moved;
    protected javax.swing.JTextField nameField;
    protected jaxx.runtime.swing.editor.NumberEditor orderEditor;
    protected javax.swing.JLabel pathField;
    protected javax.swing.JButton pathSelect;
    protected java.lang.Boolean save;
    protected javax.swing.JTextField tagsField;
    protected ThesaurusEditUI thesaurusEditUI = this;
    protected java.lang.String titleThesaurus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(Thesaurus thesaurus, String title, final boolean isCreating) {
        setBean(thesaurus);
        setTitleThesaurus(title);
        orderEditor.setBean(getBean());
        orderEditor.init();
        orderEditor.setModel(getBean().getOrder());
        thesaurus.addPropertyChangeListener(new PropertyChangeListener(){
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setModified(true);
            }
        });
        orderEditor.getTextField().setColumns(4);
        this.pack();
        setVisible(true);
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected AdminThesaurusHandler getHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    protected void valid(){
        setSave(true);
        close();
    }
    
    protected void close(){
        setVisible(false);
        UIHelper.saveComponentDispositionConfig();
        dispose();
    }
    
    protected void move(){
        getHandler().moveThesaurus(this, getBean());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusEditUI() {
        $initialize();
    }

    public ThesaurusEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        valid();
    }

    public void doActionPerformed__on__pathSelect(java.awt.event.ActionEvent event) {
        move();
    }

    public void doKeyReleased__on__commentField(java.awt.event.KeyEvent event) {
        bean.setComment(commentField.getText());
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        bean.setName(nameField.getText());
    }

    public void doKeyReleased__on__tagsField(java.awt.event.KeyEvent event) {
        ThesaurusDataHelper.setTagsAsString(getBean(), tagsField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Thesaurus getBean() {
        return bean;
    }

    public javax.swing.JTextArea getCommentField() {
        return commentField;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public java.lang.Boolean getMoved() {
        return moved;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public jaxx.runtime.swing.editor.NumberEditor getOrderEditor() {
        return orderEditor;
    }

    public javax.swing.JLabel getPathField() {
        return pathField;
    }

    public javax.swing.JButton getPathSelect() {
        return pathSelect;
    }

    public java.lang.Boolean getSave() {
        return save;
    }

    public javax.swing.JTextField getTagsField() {
        return tagsField;
    }

    public java.lang.String getTitleThesaurus() {
        return titleThesaurus;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isMoved() {
        return moved !=null && moved;
    }

    public java.lang.Boolean isSave() {
        return save !=null && save;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Thesaurus newValue) {
        com.jurismarches.vradi.entities.Thesaurus oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setMoved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.moved;
        this.moved = newValue;
        firePropertyChange(PROPERTY_MOVED, oldValue, newValue);
    }

    public void setSave(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.save;
        this.save = newValue;
        firePropertyChange(PROPERTY_SAVE, oldValue, newValue);
    }

    public void setTitleThesaurus(java.lang.String newValue) {
        java.lang.String oldValue = this.titleThesaurus;
        this.titleThesaurus = newValue;
        firePropertyChange(PROPERTY_TITLE_THESAURUS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.NORTH);
        add($Table1, BorderLayout.CENTER);
        add($Table2, BorderLayout.SOUTH);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new javax.swing.JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createMoved() {
        $objectMap.put("moved", moved = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createOrderEditor() {
        $objectMap.put("orderEditor", orderEditor = new jaxx.runtime.swing.editor.NumberEditor(this));
        
        orderEditor.setName("orderEditor");
        orderEditor.setProperty("order");
    }

    protected void createPathField() {
        $objectMap.put("pathField", pathField = new javax.swing.JLabel());
        
        pathField.setName("pathField");
    }

    protected void createPathSelect() {
        $objectMap.put("pathSelect", pathSelect = new javax.swing.JButton());
        
        pathSelect.setName("pathSelect");
        pathSelect.setText(_("vradi.adminThesaurus.move"));
        pathSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pathSelect"));
    }

    protected void createSave() {
        $objectMap.put("save", save = false);
    }

    protected void createTagsField() {
        $objectMap.put("tagsField", tagsField = new javax.swing.JTextField());
        
        tagsField.setName("tagsField");
        tagsField.setColumns(15);
        tagsField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__tagsField"));
    }

    protected void createTitleThesaurus() {
        $objectMap.put("titleThesaurus", titleThesaurus = "");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusEditUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(orderEditor, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(nameField, new GridBagConstraints(2, 1, 2, 1, 0.9, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(pathField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(pathSelect, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(tagsField, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(commentField, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        setTitle(_(titleThesaurus));
        orderEditor.setAutoPopup(false);
        orderEditor.setShowPopupButton(false);
        orderEditor.setShowReset(true);
        orderEditor.setUseFloat(false);
        orderEditor.setUseSign(false);
        pathSelect.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("move"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        // late initializer
        thesaurusEditUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusEditUI", this);
        createBean();
        createSave();
        createTitleThesaurus();
        createModified();
        createMoved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminThesaurus.orderName"));
        createOrderEditor();
        createNameField();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminThesaurus.path"));
        createPathField();
        createPathSelect();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminThesaurus.tags"));
        createTagsField();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminThesaurus.comment"));
        createCommentField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.save"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of thesaurusEditUI
        setName("thesaurusEditUI");
        thesaurusEditUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"titleThesaurus") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getTitleThesaurus()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, getBean().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                pathField.setText(_(ThesaurusDataHelper.getParentPath(getBean(), "/")));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TAGS_FIELD_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(tagsField, ThesaurusDataHelper.getTagsAsString(getBean()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(commentField, getBean().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isModified());
            }
        });
    }

}