/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI;
import com.jurismarches.vradi.ui.admin.widget.FieldSelectUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyI18nImpl;
import org.nuiton.wikitty.addons.WikittyI18nUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyI18n;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminFormTypeUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.nuiton.wikitty.entities.WikittyExtension bean;
    protected jaxx.runtime.swing.CardLayout2 cardLayout;
    protected javax.swing.JPanel cardPanel;
    protected jaxx.runtime.swing.VBox content;
    protected javax.swing.JButton createField;
    protected javax.swing.JButton createForm;
    protected javax.swing.JButton downloadTemplate;
    protected jaxx.runtime.swing.Table fieldListUI;
    protected com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel fieldsModel;
    protected jaxx.runtime.swing.HidorButton hidorInfogene;
    protected javax.swing.JPanel infogene;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JButton newTemplate;
    protected javax.swing.JButton templateBindingButton;
    protected javax.swing.JComboBox templateChoice;
    protected javax.swing.JButton templateExampleButton;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected WikittyI18n wikittyI18n;
    
    
    public WikittyI18n getWikittyI18n() {
        return wikittyI18n;
    }
    
    public void setWikittyI18n(WikittyI18n wikittyI18n) {
        this.wikittyI18n = wikittyI18n;
    }
    
    @Override
    protected void postLoadBean() {
    
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        if (bean == null) {
            return;
        }
    
        // Update template choice
        templateChoice.setModel(getHandler().getTemplateComboBoxModel(bean));
    
        // Select template
        templateChoice.setSelectedItem(getHandler().getFormTypeTemplateName(bean));
    
        // Fill other fields that infogene
        int i = 0;
        Collection<String> fieldNames = bean.getFieldNames();
    
        // Get traduction for extension
        wikittyI18n = WikittyI18nUtil.getI18n(VradiService.getWikittyProxy(), bean);
    
        for (String fieldName : fieldNames) {
            FieldType fieldType = bean.getFieldType(fieldName);
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldType, wikittyI18n, i);
            create(fieldSelectModel, false);
            i = i + 1;
        }
        fillInfogenePanel();
        setModified(false);
        validate();
    }
    
    @Override
    public void save() {
        getHandler().saveFormType(this, getHelper());
        setModified(false);
    }
    
    @Override
    protected void clearUI() {
        content.removeAll();
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()), false);
    }
    
    protected FieldSelectUI create(FieldSelectModel fieldSelectModel, boolean isInfogene){
        FieldSelectUI result = new FieldSelectUI(this);
    
        result.updateBean(fieldSelectModel);
        result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                FieldSelectUI field = (FieldSelectUI) evt.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                }
                setModified(true);
                if(evt.getNewValue() == null) {
    
                    if(field != null) {
                        field.setVisible(false);
                        content.remove(field);
                    }
                    if(field.getBean().isUpOrDown() != null) {
                        if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                            content.add(field, 0);
                        } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                            content.add(field);
                        } else {
                            int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition();
                            int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                            FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                            if (log.isDebugEnabled()) {
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
                            }
    
                            content.add(field, fieldToAddPosition);
                            for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                fieldSelectUI.getBean().setPosition(i);
                                if (log.isDebugEnabled()) {
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                        }
                        field.getBean().setUpOrDown(null);
                        field.setVisible(true);
                    }
                    content.validate();
                }
            }
        });
        result.setModified(false);
        result.setInfogene(isInfogene);
    
        content.add(result);
        validate();
    
        return result;
    }
    
    private void fillInfogenePanel() {
        infogene.removeAll();
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        int i = 0;
        java.util.List<String> fqFieldNames = new ArrayList<String>();
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_ID);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_OBJET);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_DESCRIPTION);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_CREATIONDATE);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_ENTITY);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCETEXT);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCEURL);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_COUNTRY);
        fqFieldNames.add(Infogene.FQ_FIELD_INFOGENE_DEPARTMENT);
        fillInfogenePanel(fqFieldNames, extension, i);
    
        extension = FormImpl.extensionForm;
        fqFieldNames.clear();
        fqFieldNames.add(Form.FQ_FIELD_FORM_DATEPUB);
        fqFieldNames.add(Form.FQ_FIELD_FORM_DATEPEREMPTION);
        fillInfogenePanel(fqFieldNames, extension, i);
    }
    
    private void fillInfogenePanel(java.util.List<String> fqFieldNames,
                                   WikittyExtension extension, int i) {
    
        for (String fqFieldName : fqFieldNames) {
            FieldType fieldType = extension.getFieldType(WikittyUtil.getFieldNameFromFQFieldName(fqFieldName));
    
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fqFieldName, fieldType, null, i);
    
            FieldSelectUI fieldDisplayUI = create(fieldSelectModel, true);
    
            infogene.add(fieldDisplayUI);
            i = i + 1;
        }
    
    }
    
    private void onHidorInfogene() {
        if (hidorInfogene.isSelected()) {
            cardLayout.show(cardPanel, "infogene");
        } else {
            cardLayout.show(cardPanel, "content");
        }
    }
    
    private void openTemplateFieldBindingUI() {
        TemplateFieldBindingUI templateFieldBindingUI =
                new TemplateFieldBindingUI(this);
        getHandler().updateTemplateFieldTableModel(templateFieldBindingUI,
                getBean(), (String) templateChoice.getSelectedItem());
        templateFieldBindingUI.setVisible(true);
        setFieldsModel(templateFieldBindingUI.getFieldsModel());
        if (getFieldsModel() != null) {
            setModified(true);
        }
    }
    
    protected void addNewTemplate() {
        if (getHandler().uploadNewTemplate(this)) {
            openTemplateFieldBindingUI();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI() {
        super();
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createField(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__createForm(java.awt.event.ActionEvent event) {
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    public void doActionPerformed__on__downloadTemplate(java.awt.event.ActionEvent event) {
        getHandler().downloadTemplate(this);
    }

    public void doActionPerformed__on__hidorInfogene(java.awt.event.ActionEvent event) {
        onHidorInfogene();
    }

    public void doActionPerformed__on__newTemplate(java.awt.event.ActionEvent event) {
        addNewTemplate();
    }

    public void doActionPerformed__on__templateBindingButton(java.awt.event.ActionEvent event) {
        openTemplateFieldBindingUI();
    }

    public void doActionPerformed__on__templateChoice(java.awt.event.ActionEvent event) {
        setModified(true);
    }

    public void doActionPerformed__on__templateExampleButton(java.awt.event.ActionEvent event) {
        getHandler().showTemplateExample(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.nuiton.wikitty.entities.WikittyExtension getBean() {
        return bean;
    }

    public jaxx.runtime.swing.CardLayout2 getCardLayout() {
        return cardLayout;
    }

    public javax.swing.JPanel getCardPanel() {
        return cardPanel;
    }

    public jaxx.runtime.swing.VBox getContent() {
        return content;
    }

    public javax.swing.JButton getCreateField() {
        return createField;
    }

    public javax.swing.JButton getCreateForm() {
        return createForm;
    }

    public javax.swing.JButton getDownloadTemplate() {
        return downloadTemplate;
    }

    public jaxx.runtime.swing.Table getFieldListUI() {
        return fieldListUI;
    }

    public com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public jaxx.runtime.swing.HidorButton getHidorInfogene() {
        return hidorInfogene;
    }

    public javax.swing.JPanel getInfogene() {
        return infogene;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JButton getNewTemplate() {
        return newTemplate;
    }

    public javax.swing.JButton getTemplateBindingButton() {
        return templateBindingButton;
    }

    public javax.swing.JComboBox getTemplateChoice() {
        return templateChoice;
    }

    public javax.swing.JButton getTemplateExampleButton() {
        return templateExampleButton;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(org.nuiton.wikitty.entities.WikittyExtension newValue) {
        org.nuiton.wikitty.entities.WikittyExtension oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setFieldsModel(com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel newValue) {
        com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = newValue;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToCardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        cardPanel.add(content, "content");
        cardPanel.add(infogene, "infogene");
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCardLayout() {
        $objectMap.put("cardLayout", cardLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createCardPanel() {
        $objectMap.put("cardPanel", cardPanel = new javax.swing.JPanel());
        
        cardPanel.setName("cardPanel");
        cardPanel.setLayout(cardLayout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.VBox());
        
        content.setName("content");
    }

    protected void createCreateField() {
        $objectMap.put("createField", createField = new javax.swing.JButton());
        
        createField.setName("createField");
        createField.setText(_("vradi.adminField.new"));
        createField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createField"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new javax.swing.JButton());
        
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createDownloadTemplate() {
        $objectMap.put("downloadTemplate", downloadTemplate = new javax.swing.JButton());
        
        downloadTemplate.setName("downloadTemplate");
        downloadTemplate.setText(_("vradi.adminFormType.template.download"));
        downloadTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downloadTemplate"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new jaxx.runtime.swing.Table());
        
        fieldListUI.setName("fieldListUI");
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = null);
    }

    protected void createHidorInfogene() {
        $objectMap.put("hidorInfogene", hidorInfogene = new jaxx.runtime.swing.HidorButton());
        
        hidorInfogene.setName("hidorInfogene");
        hidorInfogene.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidorInfogene"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = new javax.swing.JPanel());
        
        infogene.setName("infogene");
        infogene.setLayout(new GridLayout(0,1));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createNewTemplate() {
        $objectMap.put("newTemplate", newTemplate = new javax.swing.JButton());
        
        newTemplate.setName("newTemplate");
        newTemplate.setText(_("vradi.adminFormType.template.new"));
        newTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newTemplate"));
    }

    protected void createTemplateBindingButton() {
        $objectMap.put("templateBindingButton", templateBindingButton = new javax.swing.JButton());
        
        templateBindingButton.setName("templateBindingButton");
        templateBindingButton.setText(_("vradi.adminFormType.template.fieldBinding"));
        templateBindingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateBindingButton"));
    }

    protected void createTemplateChoice() {
        $objectMap.put("templateChoice", templateChoice = new javax.swing.JComboBox());
        
        templateChoice.setName("templateChoice");
        templateChoice.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateChoice"));
    }

    protected void createTemplateExampleButton() {
        $objectMap.put("templateExampleButton", templateExampleButton = new javax.swing.JButton());
        
        templateExampleButton.setName("templateExampleButton");
        templateExampleButton.setText(_("vradi.adminFormType.template.showExample"));
        templateExampleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateExampleButton"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JPanel0
        $JPanel0.add(createField);
        $JPanel0.add(hidorInfogene, BorderLayout.WEST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cardPanel);
        addChildrenToCardPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(templateChoice);
        $JPanel1.add(newTemplate);
        $JPanel1.add(downloadTemplate);
        $JPanel1.add(templateBindingButton);
        $JPanel1.add(templateExampleButton);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        cardLayout.setUseOnlyVisibleComponentDimension(true);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        createField.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        hidorInfogene.setHideText(_("vradi.adminFormType.hideInfogene"));
        hidorInfogene.setShowText(_("vradi.adminFormType.showInfogene"));
        hidorInfogene.setTarget(new jaxx.runtime.swing.Spacer());
        hidorInfogene.setTargetVisible(false);
        templateChoice.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createCardLayout();
        createFieldsModel();
        createTitle();
        createCreateForm();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminForm.deleteFormType"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateField();
        createHidorInfogene();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCardPanel();
        createContent();
        createInfogene();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminFormType.template.label"));
        createTemplateChoice();
        createNewTemplate();
        createDownloadTemplate();
        createTemplateBindingButton();
        createTemplateExampleButton();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
    }

}