/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FormLinkCellRenderer.java 1800 2010-11-17 20:58:35Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/widgets/FormLinkCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormLink;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.widget.tooltip.FocusableTip;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;

/**
 * @author sletellier
 */
public class FormLinkCellRenderer extends DefaultListCellRenderer {

    protected FocusableTip focusableTip = null;
    protected MultipleSelectionPane ui;

    protected Map<String, String> cachedRendered = new HashMap<String, String>();
    protected Map<String, String> cachedToolTip = new HashMap<String, String>();

    public FormLinkCellRenderer(MultipleSelectionPane ui) {
        super();
        this.ui = ui;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String rendered = " ";
        String formToolTip = null;
        String formLinkId = (String)value;
        if (formLinkId != null) {
            rendered = cachedRendered.get(formLinkId);
            formToolTip = cachedToolTip.get(formLinkId);
            if (rendered == null) {
                FormLink formLink = VradiService.getWikittyProxy().restore(FormLink.class, formLinkId);
                if (formLink != null) {
                    rendered = formLink.getName();
                    cachedRendered.put(formLinkId, rendered);

                    // ToolTip
                    formToolTip = loadFormToolTip(formLink);
                }
            }
        }

        JLabel renderedComponant = (JLabel)super.getListCellRendererComponent(list, rendered, index, isSelected, cellHasFocus);

        if (formToolTip != null) {
            renderedComponant.setToolTipText(formToolTip);
        }

        return renderedComponant;
    }

    public void addAdded(FormLink formLink) {
        cachedRendered.put(formLink.getWikittyId(), formLink.getName());

        // ToolTip
        loadFormToolTip(formLink);
    }

    protected String loadFormToolTip(FormLink formLink) {

        Form form = VradiService.getWikittyProxy().restore(Form.class, formLink.getToForm());
        String formToolTip = ToolTipHelper.getToolTip(form);
        cachedToolTip.put(formLink.getWikittyId(), formToolTip);

        return formToolTip;
    }

    /*
     * @see javax.swing.JComponent#getToolTipText()
     */
    @Override
    public String getToolTipText(MouseEvent e) {

        // get original text
        String text = super.getToolTipText(e);

        // display it into persistant tooltip
        if (focusableTip == null) {
            focusableTip = new FocusableTip(ui, true);
            focusableTip.setSize(600, 400);
        }
        focusableTip.toolTipRequested(e, text);

        return null;
    }
}
