/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiConfigHelper.java 1837 2010-12-21 12:39:24Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/VradiConfigHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Version;

import java.io.File;
import java.util.Locale;

/**
 * TODO poussin 20101207 il ne devrait y avoir aucune reference a VradiConfig
 * dans les signatures des methodes sinon ca sert a rien de faire ce Helper :(.
 * Remplacer VradiConfig par ApplicationConfig. Le mieux serait de sortir
 * VradiSwingOption de VradiConfig en meme temps
 *
 * @author sletellier
 */
public class VradiConfigHelper extends VradiServiceConfigurationHelper {

    public static boolean isSwingDebug(ApplicationConfig config) {
        boolean result = config.getOptionAsBoolean(
                VradiConfig.VradiSwingOption.VRADI_SWING_DEBUG.getKey());
        return result;
    }

    public static String getCopyrightText(ApplicationConfig config) {
        return "Version " + getVersion(config) + " JurisMarches @ 2009 - 2010";
    }

    /**
     * La version du logiciel.
     *
     * @param config vradi swing configuration
     * @return la version de l'application.
     */
    public static Version getVersion(ApplicationConfig config) {
        Version option = config.getOption(Version.class, VradiConfig.VradiSwingOption.VRADI_VERSION.key);
        return option;
    }

    /**
     * @param config vradi swing configuration
     * @return la version de la base
     */
    public static Version getDatabaseVersion(ApplicationConfig config) {
        Version option = config.getOption(Version.class, VradiConfig.VradiSwingOption.VRADI_DATABASE_VERSION.key);
        return option;
    }

    /**
     * La derniere version de lancement du logiciel.
     *
     * @param config vradi swing configuration
     * @return la derniere version de lancement
     */
    public static String getLastVersion(ApplicationConfig config) {
        String lastVersion = config.getOption(VradiConfig.VradiSwingOption.VRADI_LAST_VERSION.key);
        return lastVersion;
    }

    /**
     * Change last version.
     *
     * @param config vradi swing configuration
     * @param lastVersion new last version
     */
    public static void setLastVersion(ApplicationConfig config, String lastVersion) {
        config.setOption(VradiConfig.VradiSwingOption.VRADI_LAST_VERSION.key, lastVersion);
    }

    public static boolean isFullScreen(ApplicationConfig config) {
        Boolean result = config.getOptionAsBoolean(VradiConfig.VradiSwingOption.FULL_SCREEN.key);
        return result != null && result;
    }

    public static Locale getLocale(ApplicationConfig config) {
        Locale result = config.getOption(Locale.class, VradiConfig.VradiSwingOption.LOCALE.key);
        return result;
    }

    public static void setFullscreen(VradiConfig config, boolean fullscreen) {
        boolean oldValue = isFullScreen(config);
        config.setOption(VradiConfig.VradiSwingOption.FULL_SCREEN.key, fullscreen + "");
        config.saveForUser();
        config.firePropertyChange("fullscreen", oldValue, fullscreen);
    }

    public static void setLocale(VradiConfig config, Locale newLocale) {
        config.setOption(VradiConfig.VradiSwingOption.LOCALE.key, newLocale.toString());
        config.saveForUser();
        config.firePropertyChange("locale", null, newLocale);
    }

    /**
     * Get user login.
     *
     * @param config vradi swing configuration
     * @return user login
     */
    public static String getLogin(ApplicationConfig config) {
        return config.getOption(VradiConfig.VradiSwingOption.USERNAME.key);
    }

    /**
     * Set user login.
     *
     * @param config vradi swing configuration
     * @param login user login
     */
    public static void setLogin(ApplicationConfig config, String login) {
        config.setOption(VradiConfig.VradiSwingOption.USERNAME.key, login);
    }

    /**
     * Get user password.
     *
     * @param config vradi swing configuration
     * @return user password
     */
    public static String getPassword(ApplicationConfig config) {
        return config.getOption(VradiConfig.VradiSwingOption.PASSWORD.key);
    }

    /**
     * Set user password.
     *
     * @param config vradi swing configuration
     * @param password user password
     */
    public static void setPassword(VradiConfig config, String password) {
        config.setOption(VradiConfig.VradiSwingOption.PASSWORD.key, password);
    }

    /**
     * Get remote endpoint base url.
     *
     * If not valid url, embedded mode is used.
     *
     * @param config vradi swing configuration
     * @return remote endpoint base url
     */
    public static String getRemoteEndpoint(ApplicationConfig config) {
        String endpoint = config.getOption(VradiConfig.VradiSwingOption.REMOTE_ENDPOINT.key);
        return endpoint;
    }

    /**
     * Get user queries (comma separated).
     *
     * Warning to inner comma in queries, use {@link org.nuiton.util.StringUtil#split(String, String)}
     *
     * @param config vradi swing configuration
     * @return user queries.
     */
    public static String getQueries(ApplicationConfig config) {
        String queries = config.getOption(VradiConfig.VradiSwingOption.QUERIES.key);
        return queries;
    }

    /**
     * Set user queries and save user configuration.
     *
     * @param config vradi swing configuration
     * @param queries user queries (comma separated)
     */
    public static void setQueries(ApplicationConfig config, String queries) {
        config.setOption(VradiConfig.VradiSwingOption.QUERIES.key, queries);
        config.saveForUser();
    }

    /**
     * Get user criteria (comma separated).
     *
     * @param config vradi swing configuration
     * @return user criteria.
     */
    public static String getCriterias(ApplicationConfig config) {
        String criterias = config.getOption(VradiConfig.VradiSwingOption.CRITERIAS.key);
        return criterias;
    }

    /**
     * Set user criterias and save user configuration.
     *
     * @param config vradi swing configuration
     * @param criterias user criterias (comma separated)
     */
    public static void setCriterias(ApplicationConfig config, String criterias) {
        config.setOption(VradiConfig.VradiSwingOption.CRITERIAS.key, criterias);
        config.saveForUser();
    }

    /**
     * Get user root criteria (comma separated).
     *
     * @param config vradi swing configuration
     * @return user root criteria.
     */
    public static String getRootCriterias(ApplicationConfig config) {
        String criterias = config.getOption(VradiConfig.VradiSwingOption.CRITERIAS.key);
        return criterias;
    }

    /**
     * Set user root criterias and save user configuration.
     *
     * @param config vradi swing configuration
     * @param criterias user root criterias (comma separated)
     */
    public static void setRootCriterias(ApplicationConfig config, String criterias) {
        config.setOption(VradiConfig.VradiSwingOption.CRITERIAS.key, criterias);
        config.saveForUser();
    }

    /**
     * Get user rootThesaurus (comma separated).
     *
     * @param config vradi swing configuration
     * @return user thesaurus.
     */
    public static String getRootThesaurus(ApplicationConfig config) {
        String rootThesaurus = config.getOption(VradiConfig.VradiSwingOption.ROOT_THESAURUS.key);
        return rootThesaurus;
    }

    /**
     * Set user rootThesaurus and save user configuration.
     *
     * @param config vradi swing configuration
     * @param rootThesaurus user rootThesaurus (comma separated)
     */
    public static void setRootThesaurus(ApplicationConfig config, String rootThesaurus) {
        config.setOption(VradiConfig.VradiSwingOption.ROOT_THESAURUS.key, rootThesaurus);
        config.saveForUser();
    }

    /**
     * Get user thesaurus (comma separated).
     *
     * @param config vradi swing configuration
     * @return user thesaurus.
     */
    public static String getThesaurus(ApplicationConfig config) {
        String thesaurus = config.getOption(VradiConfig.VradiSwingOption.THESAURUS.key);
        return thesaurus;
    }

    /**
     * Set user thesaurus and save user configuration.
     *
     * @param config vradi swing configuration
     * @param thesaurus user thesaurus (comma separated)
     */
    public static void setThesaurus(ApplicationConfig config, String thesaurus) {
        config.setOption(VradiConfig.VradiSwingOption.THESAURUS.key, thesaurus);
        config.saveForUser();
    }

    /**
     * Get user columns list : offer (comma separated).
     *
     * @param config vradi swing configuration
     * @return user columns.
     */
    public static String getOfferColumns(ApplicationConfig config) {
        String columns = config.getOption(VradiConfig.VradiSwingOption.COLUMNS.key);
        return columns;
    }

    /**
     * Set user columns and save user configuration.
     *
     * @param config vradi swing configuration
     * @param columns user columns (comma separated)
     */
    public static void setOfferColumns(ApplicationConfig config, String columns) {
        config.setOption(VradiConfig.VradiSwingOption.COLUMNS.key, columns);
        config.saveForUser();
    }

    /**
     * Get thesaurus color and level.
     *
     * Storage is : 0=255,323,232;1=232,112,234;...
     *
     * @param config vradi swing configuration
     * @return thesaurus level and color
     */
    public static String getThesaurusColors(ApplicationConfig config) {
        String columns = config.getOption(VradiConfig.VradiSwingOption.THESAURUS_COLORS.key);
        return columns;
    }

    /**
     * Set user thesaurus color and level.
     *
     * Storage is : 0=255,323,232;1=232,112,234;...
     *
     * @param config vradi swing configuration
     * @param levelAndColors user columns (; separated)
     */
    public static void setThesaurusColors(ApplicationConfig config, String levelAndColors) {
        config.setOption(VradiConfig.VradiSwingOption.THESAURUS_COLORS.key, levelAndColors);
        config.saveForUser();
    }

    /**
     * Get the swing vradi config file (used by {@link org.nuiton.widget.SwingSession})
     *
     * @param config vradi swing configuration
     * @return file concerned
     */
    public static File getSwingConfigFile(ApplicationConfig config) {
        return config.getOptionAsFile(VradiConfig.VradiSwingOption.SWING_CONFIG_FILE.key);
    }

    public static void setSwingConfigFile(ApplicationConfig config, String path) {
        config.setOption(VradiConfig.VradiSwingOption.SWING_CONFIG_FILE.key, path);
    }

    /**
     * Get thesaurus expanded state.
     *
     * @param config vradi swing configuration
     * @return thesaurus expanded state
     */
    public static boolean isOnClickThesaurusExpanded(ApplicationConfig config) {
        boolean result = config.getOptionAsBoolean(VradiConfig.VradiSwingOption.THESAURUS_EXPANDED.key);
        return result;
    }

    /**
     * Set thesaurus expanded state.
     *
     * @param config vradi swing configuration
     * @param state thesaurus expanded state
     */
    public static void setOnClickThesaurusExpanded(ApplicationConfig config, boolean state) {
        config.setOption(VradiConfig.VradiSwingOption.THESAURUS_EXPANDED.key, String.valueOf(state));
        config.saveForUser();
    }

    /**
     * Change remote endpoint url.
     *
     * @param config vradi swing configuration
     * @param newEndpoint new base url
     */
    public static void setRemoteEndPoint(ApplicationConfig config, String newEndpoint) {
        config.setOption(VradiConfig.VradiSwingOption.REMOTE_ENDPOINT.key, newEndpoint);
    }

}
