/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;

public class RemoteCacheFactory
implements AuxiliaryCacheFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheFactory == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheFactory = RemoteCacheFactory.class$("org.apache.jcs.auxiliary.remote.RemoteCacheFactory")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheFactory));
    private String name;
    private static final HashMap facades = new HashMap();
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheFactory;

    public AuxiliaryCache createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)iaca;
        ArrayList<AuxiliaryCache> noWaits = new ArrayList<AuxiliaryCache>();
        if (rca.getRemoteType() == 0) {
            String failoverList;
            ArrayList<String> failovers = new ArrayList<String>();
            boolean primayDefined = false;
            if (rca.getRemoteHost() != null) {
                primayDefined = true;
                failovers.add(rca.getRemoteHost() + ":" + rca.getRemotePort());
                RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, cacheMgr);
                AuxiliaryCache ic = rcm.getCache(rca);
                if (ic != null) {
                    noWaits.add(ic);
                } else {
                    log.info((Object)"noWait is null");
                }
            }
            if ((failoverList = rca.getFailoverServers()) != null) {
                StringTokenizer fit = new StringTokenizer(failoverList, ",");
                int fCnt = 0;
                while (fit.hasMoreElements()) {
                    ++fCnt;
                    String server = (String)fit.nextElement();
                    failovers.add(server);
                    rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                    rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                    RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, cacheMgr);
                    if ((primayDefined || fCnt != 1) && noWaits.size() > 0) continue;
                    AuxiliaryCache ic = rcm.getCache(rca);
                    if (ic != null) {
                        noWaits.add(ic);
                        continue;
                    }
                    log.info((Object)"noWait is null");
                }
            }
            rca.setFailovers(failovers.toArray(new String[0]));
        } else if (rca.getRemoteType() == 1) {
            StringTokenizer it = new StringTokenizer(rca.getClusterServers(), ",");
            while (it.hasMoreElements()) {
                String server = (String)it.nextElement();
                rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, cacheMgr);
                rca.setRemoteType(1);
                AuxiliaryCache ic = rcm.getCache(rca);
                if (ic != null) {
                    noWaits.add(ic);
                    continue;
                }
                log.info((Object)"noWait is null");
            }
        }
        RemoteCacheNoWaitFacade rcnwf = new RemoteCacheNoWaitFacade(noWaits.toArray(new RemoteCacheNoWait[0]), rca, cacheMgr);
        RemoteCacheFactory.getFacades().put(rca.getCacheName(), rcnwf);
        return rcnwf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static HashMap getFacades() {
        return facades;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

