/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public class IfExpression
extends ComputedExpression
implements TailCallReturner {
    private Expression condition;
    private Expression thenExp;
    private Expression elseExp;

    public IfExpression(Expression expression, Expression expression2, Expression expression3) {
        this.condition = expression;
        this.thenExp = expression2;
        this.elseExp = expression3;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
        this.adoptChildExpression(expression3);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getThenExpression() {
        return this.thenExp;
    }

    public Expression getElseExpression() {
        return this.elseExp;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
        this.adoptChildExpression(expression);
    }

    public void setThenExpression(Expression expression) {
        this.thenExp = expression;
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.condition = this.condition.simplify(staticContext);
        if (this.condition instanceof Value) {
            boolean bl;
            try {
                bl = this.condition.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext());
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            return bl ? this.thenExp.simplify(staticContext) : this.elseExp.simplify(staticContext);
        }
        this.thenExp = this.thenExp.simplify(staticContext);
        this.elseExp = this.elseExp.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.condition = this.condition.typeCheck(staticContext, itemType);
        if (this.condition instanceof BooleanValue) {
            if (((BooleanValue)this.condition).getBooleanValue()) {
                return this.thenExp.typeCheck(staticContext, itemType);
            }
            return this.elseExp.typeCheck(staticContext, itemType);
        }
        XPathException xPathException = TypeChecker.ebvError(this.condition, staticContext.getNamePool().getTypeHierarchy());
        if (xPathException != null) {
            xPathException.setLocator(this);
            throw xPathException;
        }
        this.thenExp = this.thenExp.typeCheck(staticContext, itemType);
        this.elseExp = this.elseExp.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.condition);
        this.adoptChildExpression(this.thenExp);
        this.adoptChildExpression(this.elseExp);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.condition = this.condition.optimize(optimizer, staticContext, itemType);
        this.thenExp = this.thenExp.optimize(optimizer, staticContext, itemType);
        this.elseExp = this.elseExp.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.condition = this.doPromotion(this.condition, promotionOffer);
        if (promotionOffer.action == 13 || promotionOffer.action == 12 || promotionOffer.action == 14) {
            this.thenExp = this.doPromotion(this.thenExp, promotionOffer);
            this.elseExp = this.doPromotion(this.elseExp, promotionOffer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(3);
        arrayList.add(this.condition);
        arrayList.add(this.thenExp);
        arrayList.add(this.elseExp);
        return arrayList.iterator();
    }

    public void suppressValidation(int n) {
        if (this.thenExp instanceof ComputedExpression) {
            ((ComputedExpression)this.thenExp).suppressValidation(n);
        }
        if (this.elseExp instanceof ComputedExpression) {
            ((ComputedExpression)this.elseExp).suppressValidation(n);
        }
    }

    public boolean markTailFunctionCalls() {
        boolean bl = ExpressionTool.markTailFunctionCalls(this.thenExp);
        boolean bl2 = ExpressionTool.markTailFunctionCalls(this.elseExp);
        return bl || bl2;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.thenExp.checkPermittedContents(schemaType, staticContext, bl);
        this.elseExp.checkPermittedContents(schemaType, staticContext, bl);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            return this.thenExp.evaluateItem(xPathContext);
        }
        return this.elseExp.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            return this.thenExp.iterate(xPathContext);
        }
        return this.elseExp.iterate(xPathContext);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            this.thenExp.process(xPathContext);
        } else {
            this.elseExp.process(xPathContext);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            if (this.thenExp instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.thenExp)).processLeavingTail(xPathContext);
            }
            this.thenExp.process(xPathContext);
            return null;
        }
        if (this.elseExp instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)this.elseExp)).processLeavingTail(xPathContext);
        }
        this.elseExp.process(xPathContext);
        return null;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.getCommonSuperType(this.thenExp.getItemType(typeHierarchy), this.elseExp.getItemType(typeHierarchy), typeHierarchy);
    }

    public int computeCardinality() {
        return Cardinality.union(this.thenExp.getCardinality(), this.elseExp.getCardinality());
    }

    public int computeSpecialProperties() {
        if (this.thenExp instanceof EmptySequence) {
            return this.elseExp.getSpecialProperties();
        }
        if (this.elseExp instanceof EmptySequence) {
            return this.thenExp.getSpecialProperties();
        }
        return this.thenExp.getSpecialProperties() & this.elseExp.getSpecialProperties();
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "if (");
        this.condition.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "then");
        this.thenExp.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "else");
        this.elseExp.display(n + 1, namePool, printStream);
    }
}

