/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmbeddedFileHandler.java 1800 2010-11-17 20:58:35Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/widgets/EmbeddedFileHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.services.VradiService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Desktop;
import java.io.File;
import java.util.List;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/**
 * @author sletellier
 */
public class EmbeddedFileHandler extends MultipleSelectionHandler {

    /** log. */
    private static final Log log = LogFactory.getLog(AttachmentFileHandler.class);

    public EmbeddedFileHandler(MultipleSelectionPane ui) {
        super(ui);
        ui.setLbl(_("vradi.offerEdit.embeddedfile"));
    }

    @Override
    public void init() {
        Set<String> files = getBean().getFiles();
        fillList(files);
    }

    @Override
    public void add() {
        File file = getHandler().addEmbeddedFile(ui, getBean());
        addToList(file, file.getName());
    }

    @Override
    public void remove() {
        List<String> filesNames = getHandler().removeEmbeddedFile(getBean(), getSelectedInList());
        removeFromList(filesNames);
    }

    @Override
    public void openSelected(String selected) {
        try {
            File file = VradiService.getFileService().downloadFormEmbeddedFile(selected, getBean().getWikittyId());
            Desktop.getDesktop().open(file);
        } catch (Exception eee) {
            log.error("Error on download file : " + selected, eee);
            getHandler().fileNotFound(selected);
        }
    }
}
