/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.editor.Editor;
import org.nuiton.widget.editor.EditorHelper;
import org.nuiton.widget.editor.EditorInterface;

public class DefaultEditor
extends JPanel
implements EditorInterface,
DocumentListener {
    private static final long serialVersionUID = 5049495816540748017L;
    private static Log log = LogFactory.getLog(DefaultEditor.class);
    protected JEditorPane editor = new JEditorPane();
    protected JScrollPane scrollPane = new JScrollPane(this.editor);
    protected boolean isModified = false;

    public DefaultEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.editor.getDocument().addDocumentListener(listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.editor.getDocument().removeDocumentListener(listener);
    }

    @Override
    public void addCaretListener(CaretListener listener) {
        this.editor.addCaretListener(listener);
    }

    @Override
    public void removeCaretListener(CaretListener listener) {
        this.editor.removeCaretListener(listener);
    }

    @Override
    public boolean accept(File file) {
        return true;
    }

    @Override
    public boolean accept(Editor.EditorSyntaxConstant editorSyntaxConstant) {
        return true;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void setSyntax(Editor.EditorSyntaxConstant editorSyntax) {
    }

    @Override
    public boolean open(File file) {
        block4: {
            try {
                Document doc = this.editor.getDocument();
                EditorHelper.removeUndoRedoSupport(this.editor);
                doc.removeDocumentListener(this);
                BufferedReader in = new BufferedReader(new FileReader(file));
                this.editor.read(in, (Object)file);
                doc = this.editor.getDocument();
                doc.addDocumentListener(this);
                EditorHelper.addUndoRedoSupport(this.editor);
                this.isModified = false;
                return true;
            }
            catch (FileNotFoundException eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Can't find file: " + file), (Throwable)eee);
                }
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)("Can't open file: " + file), (Throwable)eee);
            }
        }
        return false;
    }

    @Override
    public boolean saveAs(File file) {
        try {
            FileOutputStream outf = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outf, "utf-8");
            this.editor.write(out);
            this.isModified = false;
            return true;
        }
        catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't save file", (Throwable)eee);
            }
            return false;
        }
    }

    @Override
    public String getText() {
        String result = this.editor.getText();
        return result;
    }

    @Override
    public void setText(String text) {
        this.editor.setText(text);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void copy() {
        this.editor.copy();
    }

    @Override
    public void cut() {
        this.editor.cut();
    }

    @Override
    public void paste() {
        this.editor.paste();
    }
}

