/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.email.renderers.EmailCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static com.jurismarches.vradi.VradiConstants.SessionStatus;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class EmailPopupUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHFSJzENNnFbNSCXRIVDWbcBCaEU+sNN1FguieoUAr4w3p3Yk453lpnZZNMD8A8g8SfAnQsSNyQkxIEzBy6IfwEhDlwRb3btXW9ir1esD2t73nvfe997z9/42z9RXgp0/Qh7niFcW9E+MRr3Dw52O0fEVA+JNAV1FBcoeM3kUK6NFq3wXCq01m7q8NogvFbnfYfbxB6J3myiBalOGZE9QpRCL8cjTClrrdC86TmuGKKGRY1D/frvv3JfWV98k0PIc6C6ClCpTouKmMw2UY5aCpUg0zGuMWx3oQxB7S7UW9RndYalfB/3yafoMzTfRHMOFgCm0KvpKfsYfrznKLRE+piyPe64ztMdhW6avG8cuYLKPhZmj0jjWGCLGi41fEdja8TdcXycOYWKJrcVpGviU+5COa/ESMsToGDUsbAC+0YUuLTeaDmMqj1sk1sKVTRJbxAQWbRzIYy5uN7Qhwz8SzF//1Q7XTrne1t/f0k/SqFtfn0fd5hOe2VMub5Ne66MgjVxZ0xi/1Q7XQ59X5RESsrth1iRPWo+I0KhKhdd4wh29ZniThDrGY2DyCUOMUzn174atxUPKVNE1HucSw29EqsHxt/hD7gXjymsNx7AcLgN9Zdj/sFxnGwRJmMKzthgNJfjowlN8Z5esPExkI/57gvie70edX6wLuFQzg9sI7QZoW3W5kE+vxm3zg7S79PV+K6EnH3ja/rxVrR8kuglj9ifsS9KYlutYI5jzEWLMKLIZIcw+caoUaBrsXUDsTEisYnUYKaN8sKFY9jP9nl9egKmQJmunFEmDehb/62Uf/vhj++3h3K0BrlXxrqOqCnIhCO4A0tFdepLgRa5irLaY+xstlFBAm0zkNrVMYW1BmYoDvL5q2DocOMRlj2AyM///tPPlU9+vYBy22iBcWxtY+2/gwqqJ6ALnFmec/eeX9HSyUV4LuvaYMktcohdpuoMln4XSsQKGq/QC3csrHC1Q20LFu49D3qyOqYnYWGdwi//lFvf3Rv2ZQbqvDrRPepN/mM0R21GbeIL9UCDxwrzoiOJa/FIa8ep74x+X3AGarjlP3fGEZ/rEdrtga6W7gT5q1jBvdBxFQG2OuyxT0N/2k2Pynw11vbm/0fJK6oCodzPAHIC914vI0jVha2w2ekHVFKQg+gOhInaw5/oBPxiCvwSoO1z1+xteQ62reH9MAFxOQXiEqw7fU4+9KebMIfpWPr4owSEcmaESgo+s4p4KqEn11JV8XkCwvU0y9TnVnAdT6CyloYKNYOFmYBxIwVG4RDU6Q094QRGN1MALQrO1WCtM0Itg76eyCeA9wh2GG6XTHjTlqaWGeF2Ck7lHhf0OfQas/uMdu3+4K/FBFpvZt7CdAhfJtB6O3MN6RCSangnRWvnia11zsoEM41KOoQkKpupEH7MjJDEIh1CEot3M7NIh5DEYjoCLMXxVClKV0hSM+5mpqIR/gNm80JCUBAAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.EmailPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected javax.swing.JButton deleteSession;
    protected EmailPopupUI emailPopupUI = this;
    protected javax.swing.JComboBox filterChooser;
    protected javax.swing.JTree nav;
    protected javax.swing.JLabel none;
    protected javax.swing.JButton searchButton;
    protected javax.swing.JButton sendSession;
    protected org.jdesktop.swingx.JXDatePicker sessionDatePicker;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSplitPane $JSplitPane0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel2;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String NONE = "none";
    protected EmailNavigationTreeHelper helper;
    
    
    protected EmailNavigationTreeHelper getHelper() {
        return helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    
        final VradiDataProvider dataProvider = new VradiDataProvider();
    
        jaxx.runtime.JAXXUtil.assignment(helper = new EmailNavigationTreeHelper(dataProvider), "helper", com.jurismarches.vradi.ui.email.EmailPopupUI.this);
        setContextValue(helper);
    
        // Creation of selection listener to open ui when tree selection change
        TreeSelectionListener selectionListener = new TreeSelectionListener() {
            @Override
            public void valueChanged(TreeSelectionEvent event) {
    
                // If nothing is selected
                if (nav.getSelectionModel().isSelectionEmpty()) {
                    getContentLayout().show(getContent(), NONE);
                    return;
                }
    
                TreePath path = event.getPath();
                VradiTreeNode node = (VradiTreeNode) path.getLastPathComponent();
    
                if (log.isDebugEnabled()) {
                    log.debug("Select node " + node);
                }
    
                getHandler().openUI(EmailPopupUI.this, contentLayout, content, node);
                updateButtons();
            }
        };
                      
        // Register tree
        helper.setUI(nav, true, selectionListener);
    
        sessionDatePicker.setDate(new Date());
    
        updateTree();
        SwingUtil.addExpandOnClickListener(nav);
    
        // Attach renderer
        nav.setCellRenderer(new EmailCellRenderer(dataProvider));
    
        // Single selection mode
        nav.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    
        // Tooltip is not active without this code...
        javax.swing.ToolTipManager.sharedInstance().registerComponent(nav);
    }
    
    public void updateTree() {
        if (log.isDebugEnabled()) {
            log.debug("updateTree");
        }
        Date searchDate = sessionDatePicker.getDate();
        java.util.List<Session> sessions = getHandler().getSessions(searchDate);
        helper.updateTree(sessions, (EmailNavigationTreeHelper.EmailFilterEnum)filterChooser.getSelectedItem(), searchDate);
        updateButtons();
    }
    
    protected void sendSession() {
        // disable buttons to avoid duplicate send
        boolean started = getHandler().send(this);
        updateButtons();
    }
    
    protected void updateButtons() {
        sendSession.setEnabled(canBeSend());
        deleteSession.setEnabled(isActiveSession());
        searchButton.setEnabled(isActiveSession());
    }
    
    protected boolean isActiveSession() {
        if (helper == null) {
            return false;
        }
        Session session = helper.getSelectedActiveSession();
    
        if (session == null) {
            return false;
        }
    
        return true;
    }
    
    protected boolean canBeSend() {
        if (helper == null) {
            return false;
        }
        Session session = helper.getSessionSelected();
    
        if (session == null) {
            return false;
        }
    
        if (SessionStatus.isToSend(session)) {
            return true;
        }
        return false;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EmailPopupUI() {
        $initialize();
    }

    public EmailPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        updateTree();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().createNewSession(this);
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getHandler().close(this);
    }

    public void doActionPerformed__on__deleteSession(java.awt.event.ActionEvent event) {
        getHandler().deleteSession(this);
    }

    public void doActionPerformed__on__searchButton(java.awt.event.ActionEvent event) {
        getHandler().bindEmailsWithForms(this);
    }

    public void doActionPerformed__on__sendSession(java.awt.event.ActionEvent event) {
        sendSession();
    }

    public void doWindowClosing__on__emailPopupUI(java.awt.event.WindowEvent event) {
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JButton getDeleteSession() {
        return deleteSession;
    }

    public javax.swing.JComboBox getFilterChooser() {
        return filterChooser;
    }

    public javax.swing.JTree getNav() {
        return nav;
    }

    public javax.swing.JLabel getNone() {
        return none;
    }

    public javax.swing.JButton getSearchButton() {
        return searchButton;
    }

    public javax.swing.JButton getSendSession() {
        return sendSession;
    }

    public org.jdesktop.swingx.JXDatePicker getSessionDatePicker() {
        return sessionDatePicker;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($JPanel2, NONE);
    }

    protected void addChildrenToEmailPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
        add($Table1, BorderLayout.SOUTH);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createDeleteSession() {
        $objectMap.put("deleteSession", deleteSession = new javax.swing.JButton());
        
        deleteSession.setName("deleteSession");
        deleteSession.setText(_("vradi.email.deleteSession"));
        deleteSession.setVisible(true);
        deleteSession.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__deleteSession"));
    }

    protected void createFilterChooser() {
        $objectMap.put("filterChooser", filterChooser = new javax.swing.JComboBox());
        
        filterChooser.setName("filterChooser");
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new javax.swing.JTree());
        
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(true);
    }

    protected void createNone() {
        $objectMap.put("none", none = new javax.swing.JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(_("vradi.email.noSelection"));
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new javax.swing.JButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(_("vradi.email.bindSession"));
        searchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__searchButton"));
    }

    protected void createSendSession() {
        $objectMap.put("sendSession", sendSession = new javax.swing.JButton());
        
        sendSession.setName("sendSession");
        sendSession.setText(_("vradi.email.sendSession"));
        sendSession.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sendSession"));
    }

    protected void createSessionDatePicker() {
        $objectMap.put("sessionDatePicker", sessionDatePicker = new org.jdesktop.swingx.JXDatePicker());
        
        sessionDatePicker.setName("sessionDatePicker");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEmailPopupUI();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(content, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($JPanel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JPanel1
        $JPanel1.add($Table0, BorderLayout.CENTER);
        $JPanel1.add($JButton0, BorderLayout.EAST);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sessionDatePicker, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(filterChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        addChildrenToContent();
        // inline complete setup of $JPanel2
        $JPanel2.add(none, BorderLayout.CENTER);
        // inline complete setup of $Table1
        $Table1.add($JButton1, new GridBagConstraints(0, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(searchButton, new GridBagConstraints(1, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sendSession, new GridBagConstraints(2, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(deleteSession, new GridBagConstraints(3, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton2, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 17 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JSplitPane0.setResizeWeight(0.1);
        filterChooser.setModel(new DefaultComboBoxModel(EmailNavigationTreeHelper.EmailFilterEnum.values()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("search"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("new"));
        searchButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("search"));
        searchButton.setEnabled(isActiveSession());
        sendSession.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        sendSession.setEnabled(canBeSend());
        deleteSession.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        deleteSession.setEnabled(isActiveSession());
        $JButton2.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("emailPopupUI", this);
        createContentLayout();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.session"));
        createSessionDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.filter"));
        createFilterChooser();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNav();
        createContent();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createNone();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.email.newSession"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSearchButton();
        createSendSession();
        createDeleteSession();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("vradi.action.close"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of emailPopupUI
        setName("emailPopupUI");
        SwingUtil.setComponentHeight(emailPopupUI,600);
        emailPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.email.title"));
        SwingUtil.setComponentWidth(emailPopupUI,1024);
        emailPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__emailPopupUI"));
        
        $completeSetup();
    }

}