/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: XmlStreamFieldTableModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/models/XmlStreamFieldTableModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.jurismarches.vradi.entities.XmlFieldBinding;

/**
 * Le modèle du tableau pour afficher et éditer les bindings d'un flux XML.
 * 
 * User: chemit
 * Date: 15 nov. 2009
 * Time: 16:56:08
 */
public class XmlStreamFieldTableModel extends AbstractTableModel {
    private static final long serialVersionUID = 1L;

    /**
     * Liste des bindings à afficher
     */
    protected final List<XmlFieldBinding> data;
    
    /**
     * Un drapeau pour bloquer le déclanchement des fireXXX)
     */
    protected boolean valueIsAdjusting;

    public XmlStreamFieldTableModel() {
        data = new ArrayList<XmlFieldBinding>();
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    /**
     * Pour vider le modèle.
     */
    public void clear() {
        data.clear();
        if (!isValueIsAdjusting()) {
            fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    /**
     * @return une copie de la liste des bindings
     */
    public List<XmlFieldBinding> getBindings() {
        return new ArrayList<XmlFieldBinding>(data);
    }

    public void setBindings(Collection<XmlFieldBinding> bindings) {
        data.clear();
        data.addAll(bindings);
        if (isValueIsAdjusting()) {
            int firstRow = data.size() - bindings.size();
            int lastRow = data.size() - 1;
            fireTableRowsInserted(firstRow, lastRow);
        }
    }
    
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;

        if (ensureColumnIndex(columnIndex) && ensureRowIndex(rowIndex)) {
            XmlFieldBinding value = data.get(rowIndex);
            switch (columnIndex) {
                case 0:
                    result = value.getFormField();
                    break;
                case 1:
                    result = value.getXmlField();
                    break;
                case 2:
                    result = value.getDefaultValue();
                    break;
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (ensureColumnIndex(columnIndex) && ensureRowIndex(rowIndex)) {
            XmlFieldBinding binding = data.get(rowIndex);

            if (columnIndex == 1) {
                Object[] values = (Object[]) value;
                binding.clearXmlField();
                for (Object v : values) {
                    binding.addXmlField(String.valueOf(v));
                }
                
            } else if (columnIndex == 2) {
                binding.setDefaultValue(String.valueOf(value));
            }
            
            fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    protected boolean ensureRowIndex(int rowIndex) {
        if (rowIndex >= getRowCount()) {
            return false;
        }
        return true;
    }

    protected boolean ensureColumnIndex(int columnIndex) {
        if (columnIndex >= getColumnCount()) {
            return false;
        }
        return true;
    }

}
