/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiHelper.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/VradiHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi;

import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import jaxx.runtime.swing.ErrorDialogUI;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.*;

import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

/**
 * @author letellier
 */
public class VradiHelper {

    private static final Log log = LogFactory.getLog(VradiHelper.class);

    //public final static String QUERIES = "vradi.queries";
    //public final static String XML_STREAMS = "vradi.xmlStreams";
    //public final static String CRITERIAS = "vradi.criterias";
    //public final static String THESAURUS = "vradi.thesaurus";
    //public final static String COLUMNS = "vradi.columns";
    //public final static String THESAURUS_COLORS = "vradi.thesaurus.color";
    //public final static String STATUS_COLOR = "vradi.status.color";
    //public final static String COLOR_REGEX = "\\.\\d+";
    public final static String TYPE_DESCRIPTION = "description";
    public final static String TYPE_RANK = "rank";
    public final static String TYPE_LAST_MODIFIED_DATE = "lastModifiedDate";
    public final static String TYPE_LAST_MODIFIED_TIME = "lastModifiedTime";
    public final static String TYPE_LAST_MODIFIED_BY = "lastModifiedBy";

    //public final static String EXPEND_SELECTED = "vradi.expend.selected";

    // Singleton sur les proprietes
    //public static Properties userProperties = null;

    public static VradiConfig getVradiConfig() {
        return VradiContext.get().getVradiConfig();
    }

    public static Status getSelectionneStatus(){

        VradiConstants.FormStatus type = VradiConstants.FormStatus.SELECTIONNE;

        if (log.isDebugEnabled()) {
            log.debug("getOrCreateStatus(" + type.getName() + ")");
        }

        try {
            return VradiService.getVradiDataService().getStatus(type);
        } catch (VradiException eee) {
            log.error(eee);
            ErrorDialogUI.showError(eee);
            return null;
        }
    }

    /*protected static Properties getUserProperties() {
        if (userProperties == null) {
            userProperties = getProperties(getVradiConfig().getUserFile());
        }
        return userProperties;
    }*/

    /*protected static Properties getProperties(File propertyFile) {
        Properties properties;
        try {
            properties = new Properties();
            if (getVradiConfig().getVersion().getVersion() != null
                    && !getVradiConfig().getVersion().getVersion().isEmpty()) {
                if (!propertyFile.exists()) {
                    if (!propertyFile.createNewFile()) {
                        log.error("Failled to create new property file : " + propertyFile.getName());
                    }
                }
                InputStream input = new FileInputStream(propertyFile);
                properties.load(input);
            }
        } catch (IOException ioe) {

            throw new IllegalStateException("could not get "
                    + propertyFile.getName() + " caused by : "
                    + ioe.getMessage(), ioe);
        }
        return properties;
    }*/

    /*protected static Properties store(Properties property, File file) {
        try {
            Writer fileOutputStream = new OutputStreamWriter(
                    new FileOutputStream(file), "ISO-8859-1");
            property.store(fileOutputStream, "");
        } catch (IOException e) {
            log.error("Cant save request property caused by : ", e);
            ErrorDialogUI.showError(e);
        }

        return property;
    }*/

    /*protected static void storeUserProperties(Properties properties) {

        File userFile = getVradiConfig().getUserFile();
        if (userFile != null) {
            store(properties, userFile);
        }
    }*/

    /*protected static List<String> getUserListOfStringFromProperties(
            String propertyName) {
        Properties properties = getUserProperties();
        List<String> result = new ArrayList<String>();
        // Recuperation des propriete
        if (properties != null) {
            String resultNames = properties.getProperty(propertyName);
            if (resultNames != null) {
                for (String resultName : resultNames.split(",")) {
                    String utf8ResultName;
                    try {
                        utf8ResultName = new String(
                                resultName.getBytes("ISO-8859-1"), "UTF-8");
                    } catch (UnsupportedEncodingException eee) {
                        utf8ResultName = resultName;
                    }
                    result.add(utf8ResultName);
                }
            } else {
                log.warn("Cant find property : " + propertyName);
            }
        }
        return result;
    }*/

    /*protected static void storeUserListProperties(String propertyName,
                                                  List<String> values) {
        Properties properties = getUserProperties();
        if (properties != null) {
            StringBuffer store = new StringBuffer();
            for (String value : values) {
                store.append(value).append(",");
            }

            // Removing last ","
            int length = store.length() - 1;
            if (length > 0) {
                store.deleteCharAt(length);
            }
            properties.setProperty(propertyName, store.toString());
            storeUserProperties(properties);
        }
    }*/

    /*protected static void addToUserListProperties(String propertyName,
                                                  String value) {
        addToUserListProperties(propertyName, value, false);
    }*/

    /*protected static void addToUserListProperties(String propertyName,
                                                  String value,
                                                  boolean replace) {
        addToUserListProperties(propertyName, value, replace, false, false);
    }*/

    /*protected static void addToUserListProperties(String propertyName,
                                                  String value, boolean replace,
                                                  boolean inverse,
                                                  boolean uniqueValues) {
        List<String> result = replace ? new ArrayList<String>() :
                getUserListOfStringFromProperties(propertyName);
        if (value != null) {
            String isoValue;
            try {
                isoValue = new String(value.getBytes("UTF-8"), "ISO-8859-1");
            } catch (UnsupportedEncodingException eee) {
                isoValue = value;
            }
            if (uniqueValues && result.contains(isoValue)) {
                result.remove(isoValue);
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            } else {
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            }
        }
        storeUserListProperties(propertyName, result);
    }*/

    /**
     * Return a non null list from a comma separated string
     */
    protected static List<String> stringToList(String string) {
        List<String> resultList = new ArrayList<String>();
        if (StringUtils.isNotEmpty(string)) {
            // use StringUtil.split because of inner separator in ""
            String[] items = StringUtil.split(string, ",");
            for (String item : items) {
                resultList.add(item);
            }
        }
        return resultList;
    }

    /*protected static List<String> removeToUserListProperties(
            String propertyName, String value) {
        List<String> result = getUserListOfStringFromProperties(propertyName);
        result.remove(value);
        storeUserListProperties(propertyName, result);

        return result;
    }*/

    /**
     * Save query in configuration.
     * 
     * @param query query to save
     */
    public static void addRequestToProperties(String query) {
        List<String> result = loadRequests();
        if (!result.contains(query)) {
            result.add(0, query);
            String queries = StringUtils.join(result, ",");
            getVradiConfig().setQueries(queries);
        }
    }

    /**
     * Get queries from configuration as set.
     * (used in SearchUI).
     * 
     * @return queries
     */
    public static List<String> loadRequests() {
        String queries = getVradiConfig().getQueries();
        List<String> result = stringToList(queries);
        return result;
    }

    /**
     * Get configuration criterias as list.
     * (used in SearchUI)
     * 
     * @return criterias
     */
    public static List<String> getVradiListCriteria() {
        String criterias = getVradiConfig().getCriterias();
        List<String> result = stringToList(criterias);
        return result;
    }

    /**
     * Add criteria.
     * 
     * @param value criteria to add
     */
    public static void addVradiListCriteria(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = getVradiListCriteria();
        result.add(value.getWikittyId());
        String criterias = StringUtils.join(result, ',');
        getVradiConfig().setCriterias(criterias);
    }

    /**
     * Remove a criteria.
     * 
     * @param value criteria to remove
     */
    public static void removeVradiListCriteria(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = getVradiListCriteria();
        result.remove(value.getWikittyId());
        String criterias = StringUtils.join(result, ',');
        getVradiConfig().setCriterias(criterias);
    }

    /**
     * Get configuration root criterias as list.
     * (used in SearchUI)
     *
     * @return root criterias
     */
    public static List<String> getVradiListRootCriteria() {
        String criterias = getVradiConfig().getRootCriterias();
        List<String> result = stringToList(criterias);
        return result;
    }

    /**
     * Add root criteria.
     *
     * @param value root criteria to add
     */
    public static void addVradiListRootCriteria(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = getVradiListRootCriteria();
        result.add(value.getWikittyId());
        String criterias = StringUtils.join(result, ',');
        getVradiConfig().setRootCriterias(criterias);
    }

    /**
     * Remove a root criteria.
     *
     * @param value root criteria to remove
     */
    public static void removeVradiListRootCriteria(RootThesaurus value) {
        List<String> result = getVradiListRootCriteria();
        result.remove(value.getWikittyId());
        String criterias = StringUtils.join(result, ',');
        getVradiConfig().setRootCriterias(criterias);
    }

    /**
     * Get configuration RootThesaurus as list.
     * 
     * @return thesaurus list
     */
    public static List<String> getVradiListRootThesaurus() {
        String rootThesaurus = getVradiConfig().getRootThesaurus();
        List<String> result = stringToList(rootThesaurus);
        return result;
    }

    /**
     * Remove a RootThesaurus and save list.
     *
     * @param value thesaurus to remove
     */
    public static void removeVradiListRootThesaurus(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = getVradiListRootThesaurus();
        result.remove(value.getWikittyId());
        String rootThesaurus = StringUtils.join(result, ',');
        getVradiConfig().setRootThesaurus(rootThesaurus);
    }

    /**
     * Add thesaurus.
     *
     * @param value RootThesaurus to add
     */
    public static void addVradiListRootThesaurus(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = getVradiListRootThesaurus();
        result.add(value.getWikittyId());
        String rootThesaurus = StringUtils.join(result, ',');
        getVradiConfig().setRootThesaurus(rootThesaurus);
    }

    /**
     * Get configuration thesaurus as list.
     *
     * @return thesaurus list
     */
    public static List<String> getVradiListThesaurus() {
        String rootThesaurus = getVradiConfig().getThesaurus();
        List<String> result = stringToList(rootThesaurus);
        return result;
    }

    /**
     * Remove a thesaurus and save list.
     *
     * @param value thesaurus to remove
     */
    public static void removeVradiListThesaurus(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = getVradiListThesaurus();
        result.remove(value.getWikittyId());
        String thesaurus = StringUtils.join(result, ',');
        getVradiConfig().setThesaurus(thesaurus);
    }

    /**
     * Add thesaurus.
     *
     * @param value thesaurus to add
     */
    public static void addVradiListThesaurus(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = getVradiListThesaurus();
        result.add(value.getWikittyId());
        String thesaurus = StringUtils.join(result, ',');
        getVradiConfig().setThesaurus(thesaurus);
    }

    /**
     * Get configuration offer list columns.
     *
     * @return offer list columns
     */
    public static List<String> getVradiListColumns() {
        String columns = getVradiConfig().getOfferColumns();
        List<String> result = stringToList(columns);
        return result;
    }

    /**
     * Remove offer column.
     *
     * @param columnName column name
     */
    public static void removeVradiListColumns(String columnName) {
        List<String> result = getVradiListColumns();
        result.remove(columnName);
        String columns = StringUtils.join(result, ',');
        getVradiConfig().setOfferColumns(columns);
    }

    /**
     * Add offer column.
     *
     * @param columnName column name
     */
    public static void addVradiListColumns(String columnName) {
        List<String> result = getVradiListColumns();
        result.add(columnName);
        String columns = StringUtils.join(result, ',');
        getVradiConfig().setOfferColumns(columns);
    }

    /**
     * Get configuration color as map.
     *
     * @return map for color at levels
     */
    public static Map<Integer, Color> getColorsThesaurus() {
        Map<Integer, Color> levelsAndColors = new HashMap<Integer, Color>();

        // try to get it from config
        String thesaurusColors = getVradiConfig().getThesaurusColors();
        if (StringUtils.isNotEmpty(thesaurusColors)) {
            String[] thesaurusColorsItems = StringUtil.split(thesaurusColors, ",");
            for (String thesaurusColorsItem : thesaurusColorsItems) {
                if (thesaurusColorsItem.indexOf('=') > 0) {
                    String[] levelAndColor = thesaurusColorsItem.split("=|;");
                    Integer level = Integer.parseInt(levelAndColor[0]);
                    Color color = new Color(Integer.parseInt(levelAndColor[1]),
                                Integer.parseInt(levelAndColor[2]),
                                Integer.parseInt(levelAndColor[3]));
                    levelsAndColors.put(level, color);
                }
            }
        }

        // none found, load default
        if (levelsAndColors.isEmpty()) {
            Color[] colors = new Color[] { Color.BLACK, Color.BLUE,
                    Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN,
                    Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE,
                    Color.PINK, Color.RED, Color.YELLOW};

            for (int level = 0; level < colors.length; level++) {
                levelsAndColors.put(level, colors[level]);
            }
        }

        return levelsAndColors;
    }

    /**
     * Set thesaurus color at specified level.
     *
     * @param level level
     * @param color color to store
     */
    public static void storeThesaurusColor(int level, Color color) {
        Map<Integer, Color> levelsAndColors = getColorsThesaurus();
        levelsAndColors.put(level, color);

        StringBuilder levelAndColorConf = new StringBuilder("");

        for (Entry<Integer, Color> entry : levelsAndColors.entrySet()) {

            String stringLevel = entry.getKey().toString();

            String stringColor = entry.getValue().getRed() + ";"
                + entry.getValue().getGreen() + ";"
                + entry.getValue().getBlue();

            levelAndColorConf.append(stringLevel);
            levelAndColorConf.append("=");
            levelAndColorConf.append(stringColor);
            levelAndColorConf.append(",");
        }

        getVradiConfig().setThesaurusColors(levelAndColorConf.toString());
    }

    public static boolean isOnClickThesaurusExpanded(){
        boolean result = getVradiConfig().isOnClickThesaurusExpanded();
        return result;
    }

    public static void storeOnClickThesaurusExpanded(boolean expendSelected){
        getVradiConfig().setOnClickThesaurusExpanded(expendSelected);
    }
    
    /**
     * Introspect object to look for a getName() method.
     *
     * @param o object to inspect
     * @return getName() result or "" if object can't be inspected or is null
     */
    public static String getEntityName(Object o) {
        if (o == null) {
            return "";
        }
        PropertyDescriptor descriptor;
        try {
            descriptor = PropertyUtils.getPropertyDescriptor(o, "name");

            if (descriptor == null) {
                return "";
            }
            Method getter = descriptor.getReadMethod();

            Object invoke = getter.invoke(o);
            if (invoke == null) {
                return "";
            }
            String result = (String) invoke;
            return result;
        } catch (IllegalAccessException e) {
            log.error(e);
            ErrorDialogUI.showError(e);
        } catch (InvocationTargetException e) {
            log.error(e);
            ErrorDialogUI.showError(e);
        } catch (NoSuchMethodException e) {
            log.error(e);
            ErrorDialogUI.showError(e);
        }
        return "";
    }
    // Models

    public static FieldTypeEnum getFieldTypeEnum(FieldType type) {
        for (FieldTypeEnum typeEnum : FieldTypeEnum.values()) {
            if (typeEnum.isType(type)) {
                return typeEnum;
            }
        }
        return null;
    }


    /**
     * Execute query.
     *
     * @param queryParameters query parameters
     * @param formPagedResult pagination and sort bean
     * @return formPagedResult
     */
    public static FormPagedResult executeQuery(QueryParameters queryParameters,
            FormPagedResult formPagedResult) {
        try {

            formPagedResult.setTotalFoundFormNb(0);

            if (formPagedResult.getNbFormsToShow() == 0) {
                formPagedResult.setNbFormsToShow(10);
            }

            if (formPagedResult.getPageToShow() == 0) {
                formPagedResult.setPageToShow(1);
            }

            formPagedResult = VradiService.getVradiDataService().findForms(queryParameters, formPagedResult);

            if (log.isDebugEnabled()) {
                log.debug(formPagedResult.getTotalFoundFormNb() + " forms found");
                List<String> formsIds = formPagedResult.getFormsIdsToShow();
                List<Form> forms = VradiService.getWikittyProxy().restore(Form.class, formsIds);
                for (Form form : forms) {
                    log.debug(form.getWikittyId() + " : " + form.getObjet());
                }
            }

        } catch (VradiException eee) {
            log.error("Cant execute query : ", eee);
            ErrorDialogUI.showError(eee);
            formPagedResult = new FormPagedResult();

        } catch (UnsupportedQueryException e) {
            log.error(e.getMessage());
            ErrorDialogUI.showError(e);
            formPagedResult = new FormPagedResult();
        }

        return formPagedResult;
    }

    public static String getFieldTypeDescription(FieldType fieldType) {
        return fieldType == null ?
                null : fieldType.getTagValue(TYPE_DESCRIPTION);
    }

    public static int getFieldTypeRank(FieldType fieldType) {
        int result;
        try {
            result = Integer.valueOf(fieldType.getTagValue(TYPE_RANK));
        } catch(NumberFormatException eee) {
            if(log.isDebugEnabled()) {
                log.debug("no tag value for rank");
            }
            result = -1;
        }
        return result;
    }

    /*public static String getLastVersion() {
        Properties userProperties = getUserProperties();
        return userProperties.getProperty(LAST_VERSION);
    }*/

    /*public static void setLastVersion(String lastVersion) {
        Properties userProperties = getUserProperties();
        userProperties.setProperty(LAST_VERSION, lastVersion);
        storeUserProperties(userProperties);
    }*/

    public static boolean isVersionNewer(String version) {
        String lastVersion = getVradiConfig().getLastVersion();
        if (StringUtils.isEmpty(lastVersion)) {
            return true;
        }
        String[] versionToken = version.split("\\.");
        String[] lastVersionToken = lastVersion.split("\\.");
        int i = 0;
        while (i < versionToken.length && i < lastVersionToken.length) {
            if (Integer.valueOf(versionToken[i])
                    > Integer.valueOf(lastVersionToken[i])) {
                return true;
            } else if (Integer.valueOf(versionToken[i])
                    < Integer.valueOf(lastVersionToken[i])) {
                return false;
            }
            i++;
        }
        return false;
    }

    public static List<String> extractIds(List<? extends BusinessEntity> beans) {
        List<String> ids = new ArrayList<String>();
        for (BusinessEntity bean : beans){
            ids.add(bean.getWikittyId());
        }
        return ids;
    }
}
