/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.validators;

import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.URLValidator;

/**
 * UrlValidator of XWork check if value start with "http://"
 * This one check if it's an valid simple url (like : www.codelutin.com)
 *
 */
public class SimpleUrlValidator extends URLValidator {

    public void validate(Object object) throws ValidationException {
        String fieldName = getFieldName();
        Object value = this.getFieldValue(fieldName, object);

        // if there is no value - don't do comparison
        // if a value is required, a required validator should be added to the field
        if (value == null || value.toString().length() == 0) {
            return;
        }

        // To allow www.codelutin.com for exemple
        String urlString = (String) value;
        if (!urlString.matches("[a-z]+://.+")) {
            urlString = "http://" + urlString;
        }

        // TODO SLE 11/08/2010: Write better validator base on regex 
        if (!(value.getClass().equals(String.class)) || !URLUtil.verifyUrl(urlString)) {
            addFieldError(fieldName, object);
        }
    }

}
