/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailGroupNodeLoadors extends AbstractEmailNodeLoador<Group> {

    public EmailGroupNodeLoadors () {
        super(Group.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Get sending of session
        List<Sending> sendings = getSendingList(dataProvider, parentId);

        // Extract group ids
        List<String> groupIds = new ArrayList<String>();
        for (Sending sending : sendings) {
            if (sending != null) {
                List<Group> groupList = VradiService.getVradiDataService().findUserGroups(sending.getUser());
                groupIds.addAll(extractIds(groupList));
            }
        }

        // Sort
        List<Group> groupSorted = VradiService.getWikittyProxy().restore(Group.class, groupIds);
        Collections.sort(groupSorted,  VradiComparators.GROUP_COMPARATOR);

        // Return groups
        return extractIds(groupSorted);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id, NavHelper.getChildLoador(EmailGroupUsersNodeLoadors.class));
    }
}
