/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SessionViewUI extends com.jurismarches.vradi.ui.email.EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SELECTED_SESSION = "selectedSession";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SESSION_PARAGRAPH_TEXT = "sessionParagraph.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Tz08TURCerhQoiNYSECMkRWo4ufVeohCUSFOVWDHEXnztvrSv2R/P92ZhvRj/BP8EvXsx8ebJePDswYvxXzDGg1fjvN1tl0qJ7mG3nZlv5puZb958h7xWsNpnUWSr0Efhcbu+dXBwv93nHbzFdUcJiYGC5MlZYLVg1hnaNcJaq2Hg1RRe3Q48GfjcP4auNWBG4zOX6x7niLAyiuhoXW0O3bVIhmqQdUhqXNZXP39YL50Xry2ASBI700r5X6isk4kGWMJBKFGlQ1Z1md8lGkr4XeI7Z2zbLtP6HvP4U3gOUw2YlExRMoQr/99ynCPGRxKhWLntMeFuBz5S+P7udYRrncCz+6ES2mOq0+PaPlTMEXYobG5i7SbXWgT+I8GP9neljJNNIpzX3KUdcSf1I6yfkokqCRT0N43MckxX6g3W5i7RKJmGI1sfUf92YjVBhWHsXKXe7KjAdfeYzwlwcQSQuUZRRZ3U3GOKdRWTPYSFEeBDHuGW4szElyRt8PLIBkkbdqaNbHm5FuRVSGaEpdZJOT0gVyKkpb+EZBLG3t+L81/ef3u3M1CPRbUXxoYeEz9tVapAcmXmSTtIpBOicKt3may1oJBsJb6M5THEmqmbyFG9CwZuG7h9h+kepchPff3wcfHJ5zNg7cCMGzBnh5n4XShgT9EUAteJ5M3NmNHZo2l6Fw03hAmkSdIeN4TvCp+XGZKW2yHyGxGNYXnMGIZc2oVPv+abbzcHo8gRtUunhmfjyD+GyaRafErplYw9nVmpeegE2TWMu4+c+RZlqs+V+L16sldjXkM4t+EwZOW28B1SEnVp7Fdj+ubXehy3SNn+AO3XSBLmBAAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.SessionViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Session selectedSession;
    protected javax.swing.JTextArea sessionParagraph;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SessionViewUI $EmailContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void openUI(VradiTreeNode node) {
    
        String id = node.getId();
        Session session = VradiService.getWikittyProxy().restore(Session.class, id);
        setSelectedSession(session);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SessionViewUI() {
        super();
        $initialize();
    }

    public SessionViewUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__sessionParagraph(java.awt.event.FocusEvent event) {
        VradiService.getWikittyProxy().store(getSelectedSession());
    }

    public void doKeyReleased__on__sessionParagraph(java.awt.event.KeyEvent event) {
        getSelectedSession().setParagraph(sessionParagraph.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Session getSelectedSession() {
        return selectedSession;
    }

    public javax.swing.JTextArea getSessionParagraph() {
        return sessionParagraph;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSelectedSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.selectedSession;
        this.selectedSession = newValue;
        firePropertyChange(PROPERTY_SELECTED_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createSelectedSession() {
        $objectMap.put("selectedSession", selectedSession = null);
    }

    protected void createSessionParagraph() {
        $objectMap.put("sessionParagraph", sessionParagraph = new javax.swing.JTextArea());
        
        sessionParagraph.setName("sessionParagraph");
        sessionParagraph.setColumns(15);
        sessionParagraph.setLineWrap(true);
        sessionParagraph.setWrapStyleWord(true);
        sessionParagraph.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__sessionParagraph"));
        sessionParagraph.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sessionParagraph"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $EmailContentUI0
        add($JLabel0, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(sessionParagraph);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$EmailContentUI0", this);
        createSelectedSession();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.sessionParagraph"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSessionParagraph();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SESSION_PARAGRAPH_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelectedSession() != null) {
                    jaxx.runtime.SwingUtil.setText(sessionParagraph, getSelectedSession().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().removePropertyChangeListener("paragraph", this);
                }
            }
        });
    }

}