/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TemplateFieldBindingUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXTENSION = "extension";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";
    public static final String PROPERTY_TEMPLATE = "template";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1ZQW8bxxUe0SIlSpYtU5bsWI4jyUJhF/HKzqEI4DSJpJK2VNoxRBoQqoM65A7JsXd31rOzEh3BQX5CfkJyzyVAbjkFOfTcQy9F/0JRFGgvPRR9M8PlcldLcrWsAVPkzHtvvu+beW9mZ7//O8p7HK2/wt2uwX1HUJsY+9uHh180XpGm+B3xmpy6gnGk/03lUO4IzZv9dk+gu0dV6b7Vc9/aZbbLHOIMeD+uojlPvLWI1yFECPR+1KPpeVu1fvfjruvzIGofVFLUb//5j9w35tff5RDquoBuDqisjfMKmUxXUY6aApVgpBO8ZWGnDTA4ddqAd0G27VrY855jm7xBX6GZKiq4mEMwgTbSU1YxlH/XFWhFENu1sCAVSixzhzomDPdyT6DfNpltvPI59WzMmx3iGSccm9TwqYFNmzqGy1zf9Yx6or/rqiEKAhVJVxDHo8wRaFFyMCQvQ/MKzWYDHPL3lbB9viXjes+YSSyBPh0HypZ2MVB13LCIChCGndlUrQ8FuhmZH+8UUBmqT1oWQ3yb+1XcIBZ4lCSLbs9Ut0qj633bhc39WpMzy3qBHTnEjYhD2BX16jFVYwu0ynjbeAXr+rVgrnbtGvuHfWS3QoE393d8IZgDIy1FRtLN0VH61o9kw0avk6PViAyQAEaYAOEKnTpCee5DM+h2dD5nDqBLZ8vNWLbIgKr3vytLf/npbz9WghR5CGMvJ5oOZDgsXZczl3BB5dBXdX74glpbz7D7+AgVPWJBeVDpfzsBWK3XDeBgvGtqGUp34yn2OhAiP/PXn39Z+eOfL6FcBc1ZDJsVLO33UFF0OKjALLPrfva5QnT5dBY+F+H/JdCzBdZCz1m+hS0P/haYi9/4Aw0LDcZNwl9g6ghiBu1d0Ol2gk59sI3in/69VPvh80CrKcD+3lDzUK/8H1CBOhZ1iCoovVqRWEDmXY/4JgtrQlKVQFAnZvfrjFk7mPdy6Nfq00iSZLEJuU4dn/leFb9lsNrQtOBSjxLUpDrzm51y18WOqVXr9c2b9ISCSDX6JfzKPfqo68sRfqN4y28fSxhz+zXXokJmzxgg05ANHcbplwAGW9sWbTu2KpV3zwaTpCY/d5njCewIz9gtP6+XD97JeQW/B54G8xGk1koYrA4l7QXzqFBF7eqZrgGh77zyPSW03ZHcG3LxJJEpaEf4lhdUQFZl4rM+ik+1XKlfiM1CwKbneXEuRcWlSloiG5+NUXwO9p48vRihKwGhwPXijOYUowPpMJJSLphIoKb3JfXLOCUW7FvQumySFvYtsWsxj3wB9QxrjEsmO3aY6ADVY+YcN2X3eUzA2oYKUuGQvu6Y1T8FUI47Cv3i2QZsj9LTAIH9jXdJkadl17igl2Sygriw5jU96WS0qCQ8azvEZg5tCjRVCQdfjg6ujJMRzMr+CnSPQ5Hvo7ilUUClBhUNqDot2vYDTQcB7cIcaqs9WZtQQdvCWhBQ1OrUrat4d4bHg5l0Q1Z3E1hF7ZM5Lgccdwdt0xNeicluWKyJ4+rHyRYFx44nT0NxvkPDBTxvJ/HURskEFwOCVTjj+bidZjJniCM3AtgWH52t42aTuKKqhrjXJkILde++Ad97rfc/XNto8ePKwcb9d3FlelOnIRotHpNihj762Hkgm6NC3Er2jk76B8PFANtkPUpxPSoH4xQpZFOEOMdPdsYq4r+OrpWXiQJJqxQC+a/TC+S/TinQy9+nEKhH8UYEVcu3LHjYIUTyOKEeVaeL0tk69V46JmkyyDZi3pMSDUrwIibB3GCcqAqrQ8aLyrCWJENoPEaHSt8wvQ7vRXA5jNs4QYlrZ6OFeB4TYtEi+IQ8GC7H+0OHjQryq8R1EQueLMv1QJbnA9HT18trEYSkS0WU8mGM8rQ2idJcPhckSu9WEj1plkzpckCpDCYZd1wQI0rk2YgdF4xH7bjQnR5FaQCFFsSLAtkOgdyIAdH2yVDmpcW2DpgezeIgGvn4PxRL+mNIUSGRwdLjuDaAo2lRdYqN7chZRLnah7KrgmYTps2Z70bxPMmG50ofzxMZMz2cpdjarb91h58YL4JooY/oYsv4+gCgrm3VBCfYPlcasiAq9REdBnGzrSN43hF+LLlqk66jmgqaTSfRIR72eRxTfVKd6kHcbMubwHhWFFI5c96XZbD0OFbiOJKqUMbkD5PtgqBuDICitsu4KHflZxTVXhaN1Ol+byBmelR3hqCCjfI8uHI2yebUFP6/gOkfQ1W7MDCtW3pgHwwDxgmFU1w3iuxggn33QAfMdhbRYw5CIcOXlmwdcRZ5Km/oMx7uEnFED3faZNThTlqMPtwpi+E0Lgc0JqHiURHbHr04FW0yioq0SEFFmo2hUgOT9FRKERS4oa5/Y6eyCJd8zybxamIwTJTNahIbZTfiqCDpbEubFM9WxRZr+l70Yj8CfFZd09VxI449+jj2xqfiaX9dXZXvftgJ4eXgEX/0O4KQ8J2QcIOZbzXhAMKQpAq6x9HNCVSwelf1q2cOOV3bYV19d39PUmtg/uHaQ/nAGKBZCtH0DJIhzPR6U9xXDrscvfKJiQVea+hXi5+eG2VKfs6lGKDQ6d35lj7Rb0fWsBCcNnxBJomqhYP+qX9lj5K3mYnla8Sp/0wQRF03TxrklJqiM2EQVQxGxLiZIkZ4xT8i0J2U2qpXtMMmKE2QJc5O9Zs2WJTbkMOnxJwIFzTnlkZEWJ84wiZE+B/nKOaDUCEAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String extension;
    protected com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected java.lang.String template;
    protected TemplateFieldBindingUI templateFieldBindingUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
    
            @Override
            public Component getTableCellRendererComponent(JTable jTable,
                                                           Object o,
                                                           boolean b,
                                                           boolean b1,
                                                           int i,
                                                           int i1) {
    
                String sValue = null;
                if(o != null) {
                    java.util.List<String> sValues = (java.util.List<String>) o;
                    if(!sValues.isEmpty()) {
                        sValue = sValues.get(0);
                        sValue = sValue.substring(sValue.lastIndexOf(".") + 1);
                    }
                }
                return super.getTableCellRendererComponent(jTable,
                        sValue, b, b1, i, i1);
            }
        };
        JListCellRenderer renderer = new JListCellRenderer(tbc);
    
        setContextValue(renderer);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, renderer);
    
        JListCellEditor editor = new JListCellEditor(true);
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TemplateFieldBindingUI() {
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        this.dispose();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().saveTemplateFieldBinding(this);
    }

    public void doWindowClosing__on__templateFieldBindingUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getExtension() {
        return extension;
    }

    public com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public java.lang.String getTemplate() {
        return template;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExtension(java.lang.String newValue) {
        java.lang.String oldValue = this.extension;
        this.extension = newValue;
        firePropertyChange(PROPERTY_EXTENSION, oldValue, newValue);
    }

    public void setFieldsModel(com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel newValue) {
        com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = newValue;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, newValue);
    }

    public void setTemplate(java.lang.String newValue) {
        java.lang.String oldValue = this.template;
        this.template = newValue;
        firePropertyChange(PROPERTY_TEMPLATE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTemplateFieldBindingUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createExtension() {
        $objectMap.put("extension", extension = null);
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new TemplateFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createTemplate() {
        $objectMap.put("template", template = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTemplateFieldBindingUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        fieldsTable.setModel(fieldsModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("templateFieldBindingUI", this);
        createExtension();
        createTemplate();
        createFieldsModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminFormType.template.fieldBinding.label"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of templateFieldBindingUI
        setName("templateFieldBindingUI");
        SwingUtil.setComponentHeight(templateFieldBindingUI,800);
        templateFieldBindingUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminFormType.template.fieldBinding.title"));
        SwingUtil.setComponentWidth(templateFieldBindingUI,500);
        templateFieldBindingUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__templateFieldBindingUI"));
        
        $completeSetup();
    }

}