/*
 * #%L
 * Vradi :: Swing
 * *
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.models;

import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.AdminNavUI;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

/**
 * @author sletellier
 */
public class AdminTreeSelectionModel extends DefaultTreeSelectionModel {

    protected AdminHandler handler;
    protected AdminNavUI ui;

    public AdminTreeSelectionModel(AdminNavUI ui, AdminHandler handler) {
        super();
        this.handler = handler;
        this.ui = ui;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (willContinueSelection()) {
            super.setSelectionPath(path);
            afterSelection(path);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        if (willContinueSelection()) {
            super.setSelectionPaths(pPaths);
        }
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (willContinueSelection()) {
            super.addSelectionPath(path);
            afterSelection(path);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        if (willContinueSelection()) {
            super.addSelectionPaths(paths);
        }
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        if (willContinueSelection()) {
            super.removeSelectionPath(path);
        }
        checkEmptySelection();
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        if (willContinueSelection()) {
            super.removeSelectionPaths(paths);
        }
        checkEmptySelection();
    }

    @Override
    public void clearSelection() {
        if (willContinueSelection()) {
            super.clearSelection();
        }
        checkEmptySelection();
    }

    protected boolean willContinueSelection() {
        if (isSelectionEmpty()) {
             return true;
        }
        AdminContentUI contentUI = ui.getCurrentContent();

        if (contentUI != null && contentUI.isModified()) {

             VradiTreeNode node = (VradiTreeNode) getSelectionPath().getLastPathComponent();

             // Ask to save if modified
             boolean canContinue = handler.answerToSave(contentUI, node);

             // l'utilisateur ne veut pas partir au final
             if (!canContinue) {
                 return false;
             }
         }

        return true;
    }

    protected void afterSelection(TreePath path) {

         VradiTreeNode node = (VradiTreeNode) path.getLastPathComponent();

         // Open ui
         handler.openUI(ui, node);
    }

    protected void checkEmptySelection() {
         // If nothing is selected
         if (isSelectionEmpty()) {
             ui.getContentLayout().show(ui.getContent(), AdminNavUI.NONE);
             return;
         }
    }
}
