/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import com.sun.star.uno.RuntimeException;

import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * @author letellier
 */
public class RootThesaurusTreeTableNodeLoadors extends NavTreeTableNodeChildLoador<String, RootThesaurus, VradiTreeTableNode> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** Logger */
    static private final Log log =
            LogFactory.getLog(RootThesaurusTreeTableNodeLoadors.class);

    public RootThesaurusTreeTableNodeLoadors() {
        super(RootThesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) {

        List<RootThesaurus> rootThesaurusList = null;

        try {
            // ne recupere pas seulement les id pour les mettre en cache
            rootThesaurusList = VradiService.getVradiDataService().getRootThesaurus();

            if (log.isDebugEnabled()) {
                for (RootThesaurus root : rootThesaurusList) {
                    log.debug("Root thesaurus find : " + root.getName());
                }
            }

        } catch (VradiException ex) {
            throw new RuntimeException("Can't get root thesaurus list", ex);
        }

        // Return children
        return extractIds(rootThesaurusList);
    }

    @Override
    public VradiTreeTableNode createNode(String id, NavDataProvider dataProvider) {

        return new VradiTreeTableNode(
                    getBeanType(),
                    id,
                    null,
                    NavHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)
            );
    }

    protected List<String> extractIds(List<RootThesaurus> entities) {
        List<String> ids = new ArrayList<String>();
        for (RootThesaurus e : entities) {
            ids.add(e.getWikittyId());
        }
        return ids;
    }
}