/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FieldSelectUI extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLAZZ_COMBO_SELECTED_ITEM = "clazzCombo.selectedItem";
    public static final String BINDING_DESC_FIELD_TEXT = "descField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.FieldSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.admin.models.FieldSelectModel bean;
    protected javax.swing.JComboBox clazzCombo;
    protected javax.swing.JTextField descField;
    protected javax.swing.JButton down;
    protected java.lang.Boolean modified;
    protected javax.swing.JTextField nameField;
    protected javax.swing.JButton remove;
    protected FieldSelectUI requestSelectUI = this;
    protected javax.swing.JButton up;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    public void updateBean(FieldSelectModel model) {
        bean.update(model);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }
    
    void $afterCompleteSetup() {
        getContextValue(SwingValidatorMessageTableModel.class,"errorTable").registerValidator(validator);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FieldSelectUI() {
        $initialize();
    }

    public FieldSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clazzCombo(java.awt.event.ActionEvent event) {
        bean.setType((FieldTypeEnum) clazzCombo.getSelectedItem()); setModified(true);
    }

    public void doActionPerformed__on__down(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(false); log.debug(bean.getNameValue() + " : " + bean.isUpOrDown()); setModified(null);
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(null); setModified(null);
    }

    public void doActionPerformed__on__up(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(true); log.debug(bean.getNameValue() + " : " + bean.isUpOrDown()); setModified(null);
    }

    public void doKeyReleased__on__descField(java.awt.event.KeyEvent event) {
        bean.setDescValue(descField.getText()); setModified(true);
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        bean.setNameValue(nameField.getText().trim()); setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.models.FieldSelectModel getBean() {
        return bean;
    }

    public javax.swing.JComboBox getClazzCombo() {
        return clazzCombo;
    }

    public javax.swing.JTextField getDescField() {
        return descField;
    }

    public javax.swing.JButton getDown() {
        return down;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getUp() {
        return up;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("descValue", descField);
        validator.setFieldRepresentation("nameValue", nameField);
        validator.setFieldRepresentation("type", clazzCombo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(descField), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(clazzCombo), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(up, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(down, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(bean);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.ui.admin.models.FieldSelectModel());
    }

    protected void createClazzCombo() {
        $objectMap.put("clazzCombo", clazzCombo = new javax.swing.JComboBox());
        
        clazzCombo.setName("clazzCombo");
        clazzCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clazzCombo"));
    }

    protected void createDescField() {
        $objectMap.put("descField", descField = new javax.swing.JTextField());
        
        descField.setName("descField");
        descField.setColumns(15);
        descField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descField"));
    }

    protected void createDown() {
        $objectMap.put("down", down = new javax.swing.JButton());
        
        down.setName("down");
        down.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__down"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new javax.swing.JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createUp() {
        $objectMap.put("up", up = new javax.swing.JButton());
        
        up.setName("up");
        up.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__up"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel >(com.jurismarches.vradi.ui.admin.models.FieldSelectModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        addChildrenToValidator();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        clazzCombo.setModel(getHandler().getTypesModel());
        clazzCombo.setRenderer(UIHelper.getTranslationListCellRenderer());
        up.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowUp"));
        down.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowDown"));
        remove.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("requestSelectUI", this);
        createBean();
        createModified();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.name"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminField.desc"));
        createDescField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminField.type"));
        createClazzCombo();
        createUp();
        createDown();
        createRemove();
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("nameValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, bean.getNameValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("nameValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("descValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(descField, bean.getDescValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("descValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLAZZ_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    clazzCombo.setSelectedItem(bean.getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("type", this);
                }
            }
        });
    }

}