/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiContext.java 1461 2010-09-21 09:02:18Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.2.0/vradi-swing/src/main/java/com/jurismarches/vradi/VradiContext.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi;

import com.jurismarches.vradi.ui.offer.OfferListUI;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.search.SearchUI;

public class VradiContext extends DefaultApplicationContext {

    static private Log log = LogFactory.getLog(VradiContext.class);

    public static final JAXXContextEntryDef<VradiMainUI> MAIN_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("mainui", VradiMainUI.class);

    public static final JAXXContextEntryDef<OfferListUI> OFFERT_LIST_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("offerList", OfferListUI.class);

    public static final JAXXContextEntryDef<SearchUI> SEARCH_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("searchUI", SearchUI.class);

    public static final JAXXContextEntryDef<AdminPopupUI> ADMIN_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("adminPopupUI", AdminPopupUI.class);

    public static final JAXXContextEntryDef<EmailPopupUI> EMAIL_UI_ENTRY_DEF =
            SwingUtil.newContextEntryDef("emailViewUI", EmailPopupUI.class);

    /**
     * l'intance partagée accessible après un appel à la méthode
     * {@link #init()}
     */
    protected static VradiContext instance;

    /**
     * @return <code>true</code> si le context a été initialisé via la méthode
     *         {@link #init()}, <ocde>false</code> autrement.
     */
    public static boolean isInit() {
        return instance != null;
    }

    /**
     * Permet l'initialisation du contexte applicatif et positionne
     * l'instance partagée.
     * <p/>
     * Note : Cette méthode ne peut être appelée qu'une seule fois.
     *
     * @return l'instance partagée
     * @throws IllegalStateException si un contexte applicatif a déja été positionné.
     */
    public static synchronized VradiContext init() throws IllegalStateException {
        if (isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        instance = new VradiContext();
        return instance;
    }

    /**
     * Récupération du contexte applicatif.
     *
     * @return l'instance partagé du contexte.
     * @throws IllegalStateException si le contexte n'a pas été initialisé via
     *                               la méthode {@link #init()}
     */
    public static VradiContext get() throws IllegalStateException {
        if (!isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    /**
     * Un objet pour bloquer le context
     */
    protected final Object lock = new Object();

    protected VradiContext() {
        super();
    }

    public void lock() throws InterruptedException {
        synchronized (lock) {
            lock.wait();
        }
    }

    public void releaseLock() {
        synchronized (lock) {
            lock.notify();
        }
    }

    /**
     * close the application's context.
     *
     * @throws java.lang.Exception if any pb while closing
     */
    public void close() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("closing context " + this);
        }

        // fermeture du context principal
        clear();
    }

    public VradiConfig getVradiConfig() {
        return getContextValue(VradiConfig.class);
    }

    /**
     * TODO EC20100515 : explain this code !
     * 
     * @return
     */
    public DecoratorProvider getDecoratorProvider() {
        return getContextValue(DecoratorProvider.class);
    }

    /**
     * TODO EC20100515 : explain this code !
     * 
     * @return
     */
    public DecoratorProviderListCellRenderer getDecoratorProviderListCellRenderer() {
        return getContextValue(DecoratorProviderListCellRenderer.class);
    }

}
