/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author letellier
 */
public class FormMenu extends JMenu implements WikittyServiceListener {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(FormMenu.class);

    protected VradiMainUIHandler handler;

    public FormMenu(VradiMainUIHandler handler){
        this.handler = handler;
        updateMenus();

        // register each tree on wikitty service
        VradiService.getWikittyService().addWikittyServiceListener(this, WikittyService.ServiceListenerType.ALL);
    }

    protected void updateMenus(){
        removeAll();
        List<WikittyExtension> forms = null;
        try {
            forms = VradiService.getVradiDataService().getAllFormTypes();
        } catch (VradiException eee) {
            log.error("cant get all forms type", eee);
            ErrorDialogUI.showError(eee);
        }
        for (final WikittyExtension form : forms){
            JMenuItem item = new JMenuItem(_("vradi.menu.form.new", form.getName()));
            item.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.createForm(form);
                }
            });

            add(item);
        }
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
        updateMenus();
    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
        updateMenus();
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
        updateMenus();
    }
}
