/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class FormMenu
extends JMenu
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(FormMenu.class);
    protected VradiMainUIHandler handler;

    public FormMenu(VradiMainUIHandler handler) {
        this.handler = handler;
        this.updateMenus();
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    protected void updateMenus() {
        this.removeAll();
        List forms = null;
        try {
            forms = VradiService.getVradiDataService().getAllFormTypes();
        }
        catch (VradiException eee) {
            log.error((Object)"cant get all forms type", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        for (final WikittyExtension form : forms) {
            JMenuItem item = new JMenuItem(I18n._((String)"vradi.menu.form.new", (Object[])new Object[]{form.getName()}));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FormMenu.this.handler.createForm(form);
                }
            });
            this.add(item);
        }
    }

    public void putWikitty(WikittyServiceEvent event) {
    }

    public void removeWikitty(WikittyServiceEvent event) {
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        this.updateMenus();
    }

    public void removeExtension(WikittyServiceEvent event) {
        this.updateMenus();
    }

    public void clearExtension(WikittyServiceEvent event) {
        this.updateMenus();
    }
}

