/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.nav.tree;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavTreeNode<N extends NavTreeNode<N>>
extends DefaultMutableTreeNode
implements NavNode<DefaultTreeModel, N> {
    private static final Log log = LogFactory.getLog(NavNode.class);
    private static final long serialVersionUID = 1L;
    protected final Class<?> internalClass;
    protected final String context;
    protected final String id;
    protected boolean dirty = true;
    protected boolean loaded;
    protected final NavTreeNodeChildLoador<?, ?, N> childLoador;

    protected NavTreeNode(String id) {
        this(String.class, id, null, null);
    }

    public NavTreeNode(Class<?> internalClass, String id, String context, NavTreeNodeChildLoador<?, ?, N> childLoador) {
        this.internalClass = internalClass;
        this.id = id;
        this.context = context;
        this.childLoador = childLoador;
        if (this.isStaticNode()) {
            this.loaded = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new node : " + this));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public Class<?> getInternalClass() {
        return this.internalClass;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isStringNode() {
        return String.class.equals(this.internalClass);
    }

    @Override
    public boolean isStaticNode() {
        return this.childLoador == null;
    }

    @Override
    public N getContainerNode() {
        if (this.isRoot()) {
            return null;
        }
        if (this.isStringNode()) {
            return (N)((NavTreeNode)this.getParent()).getContainerNode();
        }
        return (N)this;
    }

    @Override
    public N findNodeById(String id, NavBridge<DefaultTreeModel, N> model, NavDataProvider provider) {
        if (id == null) {
            return null;
        }
        if (id.equals(this.getId())) {
            return (N)this;
        }
        if (!this.isLoaded()) {
            this.populateChilds(model, provider);
        }
        if (this.isLeaf()) {
            return null;
        }
        Enumeration<N> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            NavTreeNode node = (NavTreeNode)enumeration.nextElement();
            NavNode nodeById = node.findNodeById(id, (NavBridge)model, provider);
            if (nodeById == null) continue;
            return (N)nodeById;
        }
        return null;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isLeaf() {
        return this.isStaticNode() ? super.isLeaf() : this.isLoaded() && this.getChildCount() == 0;
    }

    @Override
    public Object getUserObject() {
        return this.id;
    }

    @Override
    public String toString() {
        return System.identityHashCode(this) + "-" + this.id;
    }

    @Override
    public void populateNode(NavBridge<DefaultTreeModel, N> model, NavDataProvider provider, boolean populateChilds) {
        this.setDirty(true);
        if (populateChilds) {
            this.populateChilds(model, provider);
        }
    }

    @Override
    public void populateChilds(NavBridge<DefaultTreeModel, N> model, NavDataProvider provider) {
        if (this.isStaticNode()) {
            log.debug((Object)("is static node " + this));
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will load childs for " + this));
            }
            this.childLoador.loadChilds((NavTreeBridge)model, this, provider);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.loaded = true;
        }
    }

    @Override
    public N getParent() {
        return (N)((NavTreeNode)super.getParent());
    }

    public N getRoot() {
        return (N)((NavTreeNode)super.getRoot());
    }

    public N getFirstChild() {
        return (N)((NavTreeNode)super.getFirstChild());
    }

    public N getLastChild() {
        return (N)((NavTreeNode)super.getLastChild());
    }

    public N getChildAfter(TreeNode aChild) {
        return (N)((NavTreeNode)super.getChildAfter(aChild));
    }

    public N getChildBefore(TreeNode aChild) {
        return (N)((NavTreeNode)super.getChildBefore(aChild));
    }

    public N getNextSibling() {
        return (N)((NavTreeNode)super.getNextSibling());
    }

    public N getPreviousSibling() {
        return (N)((NavTreeNode)super.getPreviousSibling());
    }

    public N getFirstLeaf() {
        return (N)((NavTreeNode)super.getFirstLeaf());
    }

    public N getLastLeaf() {
        return (N)((NavTreeNode)super.getLastLeaf());
    }

    public N getNextLeaf() {
        return (N)((NavTreeNode)super.getNextLeaf());
    }

    public N getPreviousLeaf() {
        return (N)((NavTreeNode)super.getPreviousLeaf());
    }

    public N getNextNode() {
        return (N)((NavTreeNode)super.getNextNode());
    }

    public N getPreviousNode() {
        return (N)((NavTreeNode)super.getPreviousNode());
    }

    public N getSharedAncestor(N aNode) {
        return (N)((NavTreeNode)this.getSharedAncestor(aNode));
    }

    public N getChildAt(int index) {
        return (N)((NavTreeNode)super.getChildAt(index));
    }

    public Enumeration<N> children() {
        return super.children();
    }

    @Override
    public void add(N node) {
        super.add((MutableTreeNode)node);
    }

    @Override
    public void remove(N node) {
        super.remove((MutableTreeNode)node);
    }

    @Override
    public void insert(N node, int position) {
        super.insert((MutableTreeNode)node, position);
    }
}

