/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LazyRemovalCache<K, V> {
    private final ConcurrentMap<K, Entry<V>> map = new ConcurrentHashMap<K, Entry<V>>();
    private final int max_elements;
    private final long max_age;

    public LazyRemovalCache() {
        this(200, 5000L);
    }

    public LazyRemovalCache(int max_elements, long max_age) {
        this.max_elements = max_elements;
        this.max_age = max_age;
    }

    public void add(K key, V val) {
        if (key != null && val != null) {
            this.map.put(key, new Entry<V>(val));
        }
        this.checkMaxSizeExceeded();
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        Entry entry = (Entry)this.map.get(key);
        return (V)(entry != null ? entry.val : null);
    }

    public K getByValue(V val) {
        if (val == null) {
            return null;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            Entry v = (Entry)entry.getValue();
            if (v.val == null || !v.val.equals(val)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void remove(K key) {
        this.remove(key, false);
    }

    public void remove(K key, boolean force) {
        if (key == null) {
            return;
        }
        if (force) {
            this.map.remove(key);
        } else {
            Entry entry = (Entry)this.map.get(key);
            if (entry != null) {
                entry.removable = true;
            }
        }
        this.checkMaxSizeExceeded();
    }

    public void removeAll(Collection<K> keys) {
        this.removeAll(keys, false);
    }

    public void removeAll(Collection<K> keys, boolean force) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        if (force) {
            this.map.keySet().removeAll(keys);
        } else {
            for (K key : keys) {
                Entry entry = (Entry)this.map.get(key);
                if (entry == null) continue;
                entry.removable = true;
            }
        }
        this.checkMaxSizeExceeded();
    }

    public void clear(boolean force) {
        if (force) {
            this.map.clear();
        } else {
            for (Map.Entry entry : this.map.entrySet()) {
                Entry tmp;
                Entry val = (Entry)entry.getValue();
                if (val == null || (tmp = (Entry)entry.getValue()) == null) continue;
                tmp.removable = true;
            }
        }
    }

    public void retainAll(Collection<K> keys) {
        this.retainAll(keys, false);
    }

    public void retainAll(Collection<K> keys, boolean force) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        if (force) {
            this.map.keySet().retainAll(keys);
        } else {
            for (Map.Entry entry : this.map.entrySet()) {
                Entry val;
                if (keys.contains(entry.getKey()) || (val = (Entry)entry.getValue()) == null) continue;
                val.removable = true;
            }
        }
        this.checkMaxSizeExceeded();
    }

    public Set<V> values() {
        HashSet<Object> retval = new HashSet<Object>();
        for (Entry entry : this.map.values()) {
            retval.add(entry.val);
        }
        return retval;
    }

    public Map<K, V> contents() {
        HashMap retval = new HashMap();
        for (Map.Entry entry : this.map.entrySet()) {
            retval.put(entry.getKey(), ((Entry)entry.getValue()).val);
        }
        return retval;
    }

    public int size() {
        return this.map.size();
    }

    public String printCache() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public String printCache(Printable print_function) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            Object key = entry.getKey();
            Object val = ((Entry)entry.getValue()).val;
            sb.append(print_function.print(key, val));
        }
        return sb.toString();
    }

    public String toString() {
        return this.printCache();
    }

    private void checkMaxSizeExceeded() {
        if (this.map.size() > this.max_elements) {
            this.removeMarkedElements();
        }
    }

    public void removeMarkedElements() {
        long curr_time = System.currentTimeMillis();
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Entry tmp = (Entry)entry.getValue();
            if (!tmp.removable || curr_time - tmp.timestamp < this.max_age) continue;
            it.remove();
        }
    }

    private static class Entry<V> {
        private final V val;
        private final long timestamp = System.currentTimeMillis();
        private boolean removable = false;

        public Entry(V val) {
            this.val = val;
        }

        public String toString() {
            return this.val + " (" + (System.currentTimeMillis() - this.timestamp) + "ms old" + (this.removable ? ", removable" : "") + ")";
        }
    }

    public static interface Printable<K, V> {
        public String print(K var1, V var2);
    }
}

