/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class StopFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet stopWords;
    private boolean ignoreCase;
    private boolean enablePositionIncrements;

    public void inform(ResourceLoader loader) {
        String stopWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        if (stopWordFiles != null) {
            try {
                List files = StrUtils.splitFileNames((String)stopWordFiles);
                if (this.stopWords == null && files.size() > 0) {
                    this.stopWords = new CharArraySet(files.size() * 10, this.ignoreCase);
                }
                for (String file : files) {
                    List wlist = loader.getLines(file.trim());
                    this.stopWords.addAll((Collection)StopFilter.makeStopSet((String[])wlist.toArray(new String[0]), (boolean)this.ignoreCase));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.stopWords = (CharArraySet)StopFilter.makeStopSet((String[])StopAnalyzer.ENGLISH_STOP_WORDS, (boolean)this.ignoreCase);
        }
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Set getStopWords() {
        return this.stopWords;
    }

    public StopFilter create(TokenStream input) {
        StopFilter stopFilter = new StopFilter(input, (Set)this.stopWords, this.ignoreCase);
        stopFilter.setEnablePositionIncrements(this.enablePositionIncrements);
        return stopFilter;
    }
}

