/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.ui.renderer;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;

import javax.swing.*;
import javax.swing.tree.TreeCellRenderer;
import java.awt.*;
import java.util.Map;

/**
 * @author letellier
 */
public class ThesaurusHighlighter extends AbstractHighlighter implements TreeCellRenderer, ListCellRenderer {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(ThesaurusHighlighter.class);

    boolean isProposition = false;
    protected DefaultListCellRenderer delegate = null;

    // Get color store in properties
    protected Map<Integer, Color> colors;

    public ThesaurusHighlighter(){
        this(false);
    }

    public ThesaurusHighlighter(boolean isProposition){
        super();
        this.delegate = new DefaultListCellRenderer();
        this.isProposition = isProposition;
        updateColors();
    }

    @Override
    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        int depth = adapter.getDepth();
        Color color = getDepthColor(depth);
        if (color != null){
            component.setForeground(color);
        }
        return component;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        VradiThesaurusDTO thesaurus;
        if (value instanceof NavigationTreeNode){
            NavigationTreeNode node = (NavigationTreeNode) value;
            thesaurus = (VradiThesaurusDTO) node.getBean();
        } else {
            return new JLabel(value.toString());
        }
        if (thesaurus == null){
            return new JLabel(value.toString());
        }
        int depth = thesaurus.getDepth();
        Color color = getDepthColor(depth);
        String text = thesaurus.getOrderName();
        JLabel jLabel = new JLabel(text);
        if (color != null){
            jLabel.setForeground(color);
        }
        return jLabel;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        VradiThesaurusDTO thesaurus;
        if (value instanceof NavigationTreeNode){
            NavigationTreeNode node = (NavigationTreeNode) value;
            thesaurus = (VradiThesaurusDTO) node.getBean();
        } else if (value instanceof VradiThesaurusDTO){
            thesaurus = (VradiThesaurusDTO)value;
        } else {
            return new JLabel(value.toString());
        }
        if (thesaurus == null){
            return new JLabel(value.toString());
        }
        int depth = thesaurus.getDepth();
        Color color = getDepthColor(depth);
        String text = thesaurus.getOrderName();
        if (isProposition){
            text = thesaurus.getNamePath("/");
        }
        JLabel jLabel = (JLabel)delegate.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        if (color != null){
            jLabel.setForeground(color);
        }
        return jLabel;
    }
    
    public Color getDepthColor(int depth){
        return colors.get(depth);
    }

    public void updateColors() {
        colors = VradiHelper.getColorsThesaurusFromProperties();
    }
}
