/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author letellier
 */
public class FormMenu extends JMenu {

    protected JAXXContextEntryDef<List<WikittyExtension>> entryDef;
    protected VradiMainUIHandler handler;

    public FormMenu(VradiMainUIHandler handler){
        this.handler = handler;
        this.entryDef = VradiContext.getFormsTypeEntryDef();
        updateMenus();
        VradiContext.get().addPropertyChangeListener(entryDef, entryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                updateMenus();
            }
        });
    }

    protected void updateMenus(){
        removeAll();
        List<WikittyExtension> forms = entryDef.getContextValue(VradiContext.get());
        for (final WikittyExtension form : forms){
            JMenuItem item = new JMenuItem(_("vradi.menu.form.new", form.getName()));
            item.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.createForm(form);
                }
            });

            add(item);
        }
    }
}
