package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferTable;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SessionViewUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_FIELD_TEXT = "descriptionField.text";
    public static final String BINDING_RECEPTION_PROOF_FIELD_SELECTED = "receptionProofField.selected";
    public static final String BINDING_STATUS_FIELD_TEXT = "statusField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz28jNRTH3bBJm5Ysy4b+YnehQCQEaKc/WCFBl/3RLqWtUlo2pVqRC86M27g448F+0073gPgT+BPgzgWJGyfEgTMHLoh/ASEOXBHPM+lMpp0kI9KD07Hf+/jr5+dnf/cnKWpFXjmmQWAp3wXeYdb2wydPdlvHzIZHTNuKeyAVif7GCqTQJFNO3K+BvNasG/fFrvviuux40mVuj/dqnUxqOBNMtxkDILfSHrbWi414eDXwfHVOjUVlUb/5+6/C185X3xYICTxUN4tLWRjmlazkSp0UuAPkOs50QhcFdY9QhuLuEeqtmL51QbX+iHbYF+RLMl4nJY8qhAF5Nf+SQ0boH3hAKpppzaV7wNnpJ1tAbtuyYx37iusOVXabaetEUYdbPrdYh3JhNXrtPS8klYDMyMNDpupcw7oUfsfdoDZOegZkqT9wN9MlYVZj5j5tCbYjHSaA3OkP7BgLnXATtwR6pcWoC+TtPhTN1Am38dMBaR2YrgZzHdyCR/u7CaRS227YSgqxR122BGTWbE5g6VM0tHqGjHk59pqobZtOgQ7XUw5hrzGajm3Ha6F4NJ1LJVDkEY4Zy7nYoQgcBLtIrtNWRL5xScWy+X4xPTalcbHdBWP8U6g1H0C6aftKbZM7UkVDqPWlDK09FtlCVmIhyWrGbekC5q/5vGWaNy5GZjkeequXGC54yXwvmOZ2z9KAgq83OBNOxnBVMZt5gJm9p6Q8DM2ATKcisN5m9udrMkh7dvWsDNCzHE/4TnYKhQazaYNr50UNNWXK2WcBPFSMGvv3srkrMTeJX1mcnwwgtSGHM86z+x6Wshup3cUiaSVFMqliY01SVD52Y+o2L9fVxzgUVdS5CxXVAMPRf2eqv/34xw8b52V0HueezjTtuQWwvHlKekwBN1M/F9VQH7hY3KHeapOUNRPMjq6ImxnCGt1hFIfzPW/cLeNubVLdRkRx/Peffp757NdnSGGDTApJnahgbZEytBVGQQon8O4/CBU9ezqB7TWjDUhJ0DOJB4BcvetQoAstHh6wewEG4WZGEGIlrfIv/1Qb3z84D8QYCpvva54Eo/gpKXFXcJeFN0r3ssi8QaY8zXxHJpdC1jUxZn4nvW792wrbncsrNd27ptkLfPPzcSjZ/NcIx+aHErA8A2b1AMbLeRjcjmpNH0YtB2OcuSb3nZEwpruJJflutBkLFPA2b/nA7o0grM0dts+9AcJez4PBfD0dHVMCqo7YoA3LQ6lElAOuebfe/G/YsBx8M9+mmeY4m7CUn9BHw0qOkExE1WpgAt4ZeS2jE94dORrv54jGVeqDfMw0fxo+5wbQ1nLQXrDD9+Y6PjHwohyedXmYFbv3DTsirHrIhdDmie1JBZuMH7UHHbE8yPKR4g6+s6UaETTbloo/xdBREb0zPhhaKPNgi+HbfUTIhClqHyo+TMx/KsB3Y2YOAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.SessionViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.services.dto.VradiSendingDTO bean;
    protected jaxx.runtime.swing.Table content;
    protected javax.swing.JTextArea descriptionField;
    protected com.jurismarches.vradi.ui.OfferTable listTable;
    protected com.jurismarches.vradi.ui.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JCheckBox receptionProofField;
    protected javax.swing.JButton sendSending;
    protected SessionViewUI sessionViewUI = this;
    protected javax.swing.JLabel statusField;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JPanel $JPanel2;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JScrollPane $JScrollPane2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    
    
    public void setHelper(EmailNavigationTreeHelper helper){
        this.helper = helper;
    }
    
    public EmailNavigationTreeHelper getHelper(){
        if (helper != null){
            return helper;
        }
        jaxx.runtime.JAXXUtil.assignment(helper = getContextValue(EmailNavigationTreeHelper.class), "helper", com.jurismarches.vradi.ui.email.SessionViewUI.this);
        if (helper != null){
            return helper;
        }
        return getParentContainer(EmailPopupUI.class).helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        VradiSendingDTO sendingToDisplay = getContextValue(VradiSendingDTO.class);
        setBean(sendingToDisplay);
        title.setText(updateTitle());
        sendSending.setEnabled(isSent());
    }
    
    public void updateDatas(){
        java.util.List<Form> forms = getHandler().extractFormsFromSending(getBean());
        offerListTableModel.setFormPageDTO(new VradiFormPageDTO(forms));
    }
    
    protected String updateTitle() {
        if (getBean() == null){
            return "";
        }
        String msg = "";
        if (getBean().getClient() != null){
             msg = _("vradi.email.titleClient", getBean().getClientDTO().getName());
        }
        if (getBean().getUserDTO() != null){
             msg = _("vradi.email.titleUser", getBean().getUserDTO().getName());
        }
        if (getBean().getGroupDTO() != null){
             msg = _("vradi.email.titleGroup", getBean().getGroupDTO().getName());
        }
        log.info("Title : " + msg);
        return msg;
    }
    
    protected boolean isSent(){
        if (getBean() == null){
            return false;
        }
        return getBean().getStatus() == VradiConstants.SendingStatus.SENT.getValue();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SessionViewUI() {
        $initialize();
    }

    public SessionViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__receptionProofField(java.awt.event.ActionEvent event) {
        getHandler().updateReceptionProof(getBean(),                                                         receptionProofField.isSelected());
    }

    public void doActionPerformed__on__sendSending(java.awt.event.ActionEvent event) {
        getHandler().sendSending(this, getBean());
    }

    public void doFocusLost__on__descriptionField(java.awt.event.FocusEvent event) {
        getHandler().updateParagraph(getBean(),                                                          getBean().getParagraph());
    }

    public void doKeyReleased__on__descriptionField(java.awt.event.KeyEvent event) {
        getBean().setParagraph(descriptionField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.services.dto.VradiSendingDTO getBean() {
        return bean;
    }

    public jaxx.runtime.swing.Table getContent() {
        return content;
    }

    public javax.swing.JTextArea getDescriptionField() {
        return descriptionField;
    }

    public com.jurismarches.vradi.ui.OfferTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JCheckBox getReceptionProofField() {
        return receptionProofField;
    }

    public javax.swing.JButton getSendSending() {
        return sendSending;
    }

    public javax.swing.JLabel getStatusField() {
        return statusField;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.services.dto.VradiSendingDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiSendingDTO oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.models.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($Table1, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        content.add($Table2, new GridBagConstraints(1, 0, 1, 1, 0.8, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSessionViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.Table());
        content.setName("content");
    }

    protected void createDescriptionField() {
        $objectMap.put("descriptionField", descriptionField = new javax.swing.JTextArea());
        descriptionField.setName("descriptionField");
        descriptionField.setColumns(15);
        descriptionField.setLineWrap(true);
        descriptionField.setWrapStyleWord(true);
        descriptionField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__descriptionField"));
        descriptionField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descriptionField"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new com.jurismarches.vradi.ui.OfferTable());
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createReceptionProofField() {
        $objectMap.put("receptionProofField", receptionProofField = new javax.swing.JCheckBox());
        receptionProofField.setName("receptionProofField");
        receptionProofField.setText(_("vradi.email.receptionProof"));
        receptionProofField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receptionProofField"));
    }

    protected void createSendSending() {
        $objectMap.put("sendSending", sendSending = new javax.swing.JButton());
        sendSending.setName("sendSending");
        sendSending.setText(_("vradi.email.sendSending"));
        sendSending.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sendSending"));
    }

    protected void createStatusField() {
        $objectMap.put("statusField", statusField = new javax.swing.JLabel());
        statusField.setName("statusField");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToSessionViewUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($Table0, BorderLayout.NORTH);
        $JPanel0.add($JPanel2, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sendSending, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HidorButton0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel2
        $JPanel2.add(content, BorderLayout.NORTH);
        $JPanel2.add($JScrollPane2, BorderLayout.CENTER);
        addChildrenToContent();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(statusField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(receptionProofField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(descriptionField);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(listTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        title.setText(_(updateTitle()));
        sendSending.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        sendSending.setEnabled(isSent());
        $HidorButton0.setHideTip(_("vradi.email.hideForm"));
        $HidorButton0.setShowTip(_("vradi.email.showForm"));
        $HidorButton0.setTarget(content);
        $HidorButton0.setTargetVisible(true);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setFillsViewportHeight(true);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("sessionViewUI", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createBean();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        createTitle();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        createSendSending();
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createContent();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.status"));
        createStatusField();
        createReceptionProofField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.paragraph"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createDescriptionField();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_NEVER,                                                 JScrollPane.HORIZONTAL_SCROLLBAR_NEVER));
        $JScrollPane2.setName("$JScrollPane2");
        createListTable();
        // inline creation of sessionViewUI
        setName("sessionViewUI");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("status", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    statusField.setText(_(VradiConstants.SendingStatus.getStatus(getBean().getStatus()).getDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("status", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEPTION_PROOF_FIELD_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("receptionProof", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    receptionProofField.setSelected(getBean().getReceptionProof());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("receptionProof", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(descriptionField, getBean().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("paragraph", this);
                }
            }
        });
    }

}