package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.editors.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TextEditor extends com.jurismarches.vradi.ui.editors.VradiEditor<String, TextEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVTQU8TQRR+rbRYsIqQVoiYVCXRqNnquUZBlCgpSiwhxF4cdid0yOzOODMLWw7Gn+BP0LsXE2+ejAfPHrwY/4IxHrwa3+y2XaqrYA+zzbz3fe+9b7736isUtIKz2ySKHBUGhvnUWV7Y2HiwuU1dc5tqVzFphILkl8tDvg3j3uBeGzjfblp4vQevLwpfioAG+9CNJoxp0+VUdyg1Bs4MI1yt661BuBHJUPVZB01lsb74/i3/3Hv2Mg8QSeyuiKPUDkKlk4w0Ic88A5NYaYfUOQm2sA3Fgi3st2zvFjnR+j7x6RN4CqNNKEqikMzAucOPHHPE+EgaKM+tK+KxOx7DnKsGrrjCd7ZDxbRPlNuh2tmxcSdkDo1ztLNGI5PkSxkTFQ0UfOFRbuDa/8BXLCblKO0QzjyCAQOXh1QbBBy9i2o4LXuu9y9ThnJSY1EEJlZl0moW9UDLqyTYX24iSW65SnBuYwZODeWnEYuYHACLCdBAZSjdzrWgKLFZFYkvf3poBvSUk3oqffRcGwoqxGsD0+0/bfgQQ4kBp38zoCWMoz+rU5/efnmz1HfdCNauZKbuWxp0g1RCUmWYLX0isVxoGK+vENloQ0lTjhsXb9RsRmOtXhibw3onLdyxcOcu0R2kKIx+fve++vjjEcgvwRgXxFsiNv8elExHoQqCe5G8OR93dGz3KJ4TtjfUl5OuCPH5jl/H9yW1TRZ4qPCNCEWYzRBh0Mlm6cOPqdbr+b4QOWxs5q/pqRiFR1BkAWcBjRewt1uZCzcuNQ09ke5Q1lbl7HdK9qxWi8+5rElnOkKxPXQr4YnZbhG1KjhzuxZyIQrt52I8if13KSauHoJ43GcB80O/xfboP6hmDkE1YtDXB3D8AlbUqYu2BQAA";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextArea editor;
    protected javax.swing.JScrollPane editorScrollPane;
    protected com.jurismarches.vradi.ui.editors.TextEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.TextEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TextEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }
            void $afterCompleteSetup() {
                // scroll more efficiently
                editorScrollPane.getVerticalScrollBar().setBlockIncrement(100);
                editorScrollPane.getVerticalScrollBar().setUnitIncrement(50);
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TextEditor() {
        super();
        $initialize();
    }

    public TextEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.TextEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());revalidate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextArea getEditor() {
        return editor;
    }

    public javax.swing.JScrollPane getEditorScrollPane() {
        return editorScrollPane;
    }

    public com.jurismarches.vradi.ui.editors.TextEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editorScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToEditorScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        editorScrollPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(editor));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
        validator.setFieldRepresentation("value", editor);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextArea());
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createEditorScrollPane() {
        $objectMap.put("editorScrollPane", editorScrollPane = new javax.swing.JScrollPane());
        editorScrollPane.setName("editorScrollPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.editors.TextEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.TextEditorModel >(com.jurismarches.vradi.ui.editors.TextEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        addChildrenToEditorScrollPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        editorScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        editor.setMinimumSize(new Dimension(0,56));
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditorScrollPane();
        createEditor();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
    }

}