package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiGroupDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.sharengo.wikitty.BusinessEntityWikitty;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GROUP_NAME_TEXT = "groupName.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.services.dto.VradiGroupDTO bean;
    protected jaxx.runtime.swing.ListSelectorUI< Client > groupClients;
    protected javax.swing.JTextField groupName;
    protected jaxx.runtime.swing.ListSelectorUI< VradiUserDTO > groupUsers;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiGroupDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminGroupUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        if (log.isDebugEnabled()) {
            addPCSLogger();
            addBeanPCSLogger(bean);
        }
        addBeanModifiedPCS(bean);
        groupClients.addPropertyChangeListener("modified", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from clients");
                    setModified(true);
                }
            }
        });
    
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.Map<Client, Set<String>> clients = getHandler().getAllClients();
        java.util.List<Client> toClientCombo = new java.util.ArrayList<Client>(clients.keySet());
        java.util.List<Client> toClientList = new java.util.ArrayList<Client>(clients.keySet());
    
        for (java.util.Iterator<Client> it = toClientList.iterator(); it.hasNext();) {
            Client client = it.next();
            if (bean.getClient() == null || !bean.getClient().contains(client.getWikittyId())) {
                it.remove();
            } else {
                toClientCombo.remove(client);
            }
        }
        groupClients.init(toClientCombo, toClientList);
    
        java.util.List<VradiUserDTO> toUserCombo = getHandler().getAllDisplayUsers();
        java.util.List<VradiUserDTO> toUserList = new java.util.ArrayList<VradiUserDTO>(toUserCombo);
    
        for (java.util.Iterator<VradiUserDTO> it = toUserList.iterator(); it.hasNext();) {
            VradiUserDTO user = it.next();
            if (bean.getUser() == null || !bean.getUser().contains(user.getWikittyId())) {
                it.remove();
            } else {
                toUserCombo.remove(user);
            }
        }
        groupUsers.init(toUserCombo, toUserList);
        
        lastModified.removeAll();
        if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
            String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
            lastModified.add(new JLabel(labelText));
        }
        lastModified.validate();
    }
    
    @Override
    public void save() {
        bean.clearClient();
        for (Client client : groupClients.getListDatas()) {
            bean.addClient(client.getWikittyId());
        }
        bean.clearUser();
        for (VradiUserDTO user : groupUsers.getListDatas()) {
            bean.addUser(user.getWikittyId());
        }
    
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        Group group = (Group) getHelper().getSelectedBean(this);
        
        if(!group.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty) group;
            entityWikitty.getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
        }
        
        this.bean.toWikitty(group);
        group = getHandler().saveGroup(this, getHelper(), group);
        
        groupClients.setModified(false);
        groupUsers.setModified(false);
    }
    
    @Override
    protected void updateBeanFromEntity(Group bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminGroup.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiGroupDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this, getHelper());setModified(true);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        bean.setName(groupName.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.services.dto.VradiGroupDTO getBean() {
        return bean;
    }

    public jaxx.runtime.swing.ListSelectorUI< Client > getGroupClients() {
        return groupClients;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public jaxx.runtime.swing.ListSelectorUI< VradiUserDTO > getGroupUsers() {
        return groupUsers;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(SwingUtil.boxComponentWithJxLayer(groupName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupClients, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(requestListUI, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setFieldRepresentation("name", groupName);
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiGroupDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createGroupClients() {
        $objectMap.put("groupClients", groupClients = new jaxx.runtime.swing.ListSelectorUI< Client >());
        groupClients.setName("groupClients");
        groupClients.setShowHidor(true);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< VradiUserDTO >());
        groupUsers.setName("groupUsers");
        groupUsers.setShowHidor(true);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.setName("requestListUI");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiGroupDTO >(com.jurismarches.vradi.services.dto.VradiGroupDTO.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.add"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.delete"));
        $HidorButton0.setHideTip(_("vradi.adminGroup.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminGroup.showForm"));
        $HidorButton0.setTarget(adminGroupForm);
        $HidorButton0.setTargetVisible(true);
        groupClients.setAddToComboTip(_("vradi.adminGroup.removeClient"));
        groupClients.setAddToListTip(_("vradi.adminGroup.addClient"));
        groupClients.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeGroup"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel0.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 6 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createValidator();
        createBean();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont((float) 20));
        }
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.BOLD));
        }
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminGroup.createGroup"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminGroupForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminGroup.listClients"));
        createGroupClients();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    $JLabel0.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GROUP_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}