package com.jurismarches.vradi.ui.admin;

import java.util.List;
import java.util.Map;

import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;

import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.TreeTableModel;

import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.ui.admin.content.ThesaurusQueryChangesUI;
import com.jurismarches.vradi.ui.query.QueryCellEditor;
import com.jurismarches.vradi.ui.query.QueryCheckCellRenderer;
import com.jurismarches.vradi.ui.query.ThesaurusChangesTreeTableModel;

/**
 * ThesaurusQueryChangesHandler.
 *
 * @author schorlet
 * @version $Revision: 687 $ $Date: 2010-04-08 16:25:32 +0200 (jeu., 08 avril 2010) $
 * @since 25 mars 2010 15:05:55
 */
public class ThesaurusQueryChangesHandler {

    public ThesaurusQueryChangesUI initUI(JAXXContext rootContext, Map<QueryMaker, List<VradiQueryBean>> queries,
            String before, String after) {
        JAXXInitialContext context = new JAXXInitialContext().add(rootContext).add(this);
        context.add("queries", queries);
        context.add("before", before);
        context.add("after", after);
        
        ThesaurusQueryChangesUI thesaurusChangesUI = new ThesaurusQueryChangesUI(context);
        final JXTreeTable resultTreeTable = thesaurusChangesUI.getResultTreeTable();
        resultTreeTable.expandAll();
        
        // editor column
        TableColumn column = resultTreeTable.getColumnModel().getColumn(3);
        column.setCellEditor(new QueryCellEditor(rootContext));
        
        // checkbox column
        column = resultTreeTable.getColumnModel().getColumn(4);
        QueryCheckCellRenderer checkBox = new QueryCheckCellRenderer();
        column.setCellRenderer(checkBox);
        column.setCellEditor(new DefaultCellEditor(checkBox));
        column.setMaxWidth((int)checkBox.getPreferredSize().getWidth());
        
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
        HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        resultTreeTable.addHighlighter(highlighter);
        
        return thesaurusChangesUI;
    }

    void close(ThesaurusQueryChangesUI context) {
        context.setVisible(false);
        context.dispose();
    }
     
    public TreeTableModel getResultTreeTableModel(ThesaurusQueryChangesUI context) {
        ThesaurusChangesTreeTableModel treeTableModel = context.getContextValue(ThesaurusChangesTreeTableModel.class);
        if (treeTableModel == null) {
            Map<QueryMaker, List<VradiQueryBean>> queries = context.getContextValue(Map.class, "queries");
            String before = context.getContextValue(String.class, "before");
            String after = context.getContextValue(String.class, "after");
            
            treeTableModel = new ThesaurusChangesTreeTableModel(queries, before, after);
            context.setContextValue(treeTableModel);
        }
        return treeTableModel;
    }
}
