/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.aspectwerkz.joinpoint.EnclosingStaticJoinPoint;
import org.codehaus.aspectwerkz.joinpoint.impl.CatchClauseSignatureImpl;
import org.codehaus.aspectwerkz.joinpoint.impl.ConstructorSignatureImpl;
import org.codehaus.aspectwerkz.joinpoint.impl.EnclosingStaticJoinPointImpl;
import org.codehaus.aspectwerkz.joinpoint.impl.FieldSignatureImpl;
import org.codehaus.aspectwerkz.joinpoint.impl.MethodSignatureImpl;
import org.codehaus.aspectwerkz.joinpoint.impl.StaticInitializerSignatureImpl;
import org.codehaus.aspectwerkz.joinpoint.management.JoinPointType;
import org.codehaus.aspectwerkz.reflect.ReflectHelper;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;

public final class SignatureFactory {
    public static final MethodSignatureImpl newMethodSignature(Class declaringClass, int joinPointHash) {
        Method[] methods = declaringClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (ReflectHelper.calculateHash(method) != joinPointHash) continue;
            return new MethodSignatureImpl(declaringClass, method);
        }
        MethodSignatureImpl signature = null;
        for (int i = 0; i < declaringClass.getInterfaces().length; ++i) {
            signature = SignatureFactory.newMethodSignature(declaringClass.getInterfaces()[i], joinPointHash);
            if (signature == null) continue;
            return signature;
        }
        if (declaringClass.getSuperclass() == null) {
            return null;
        }
        signature = SignatureFactory.newMethodSignature(declaringClass.getSuperclass(), joinPointHash);
        return signature;
    }

    public static final FieldSignatureImpl newFieldSignature(Class declaringClass, int joinPointHash) {
        Field[] fields = declaringClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (ReflectHelper.calculateHash(field) != joinPointHash) continue;
            return new FieldSignatureImpl(declaringClass, field);
        }
        if (declaringClass.getSuperclass() != null) {
            return SignatureFactory.newFieldSignature(declaringClass.getSuperclass(), joinPointHash);
        }
        return null;
    }

    public static final ConstructorSignatureImpl newConstructorSignature(Class declaringClass, int joinPointHash) {
        Object constructor = null;
        for (int i = 0; i < declaringClass.getDeclaredConstructors().length; ++i) {
            Constructor<?> c = declaringClass.getDeclaredConstructors()[i];
            if (ReflectHelper.calculateHash(c) != joinPointHash) continue;
            return new ConstructorSignatureImpl(declaringClass, c);
        }
        if (declaringClass.getSuperclass() != null) {
            return SignatureFactory.newConstructorSignature(declaringClass.getSuperclass(), joinPointHash);
        }
        return null;
    }

    public static final CatchClauseSignatureImpl newCatchClauseSignature(Class exceptionClass) {
        return new CatchClauseSignatureImpl(exceptionClass);
    }

    public static EnclosingStaticJoinPoint newEnclosingStaticJoinPoint(Class declaringClass, String name, String description) {
        if ("<clinit>".equals(name)) {
            return new EnclosingStaticJoinPointImpl(new StaticInitializerSignatureImpl(declaringClass), JoinPointType.STATIC_INITIALIZATION);
        }
        if ("<init>".equals(name)) {
            return new EnclosingStaticJoinPointImpl(SignatureFactory.newConstructorSignature(declaringClass, AsmHelper.calculateConstructorHash(description)), JoinPointType.CONSTRUCTOR_EXECUTION);
        }
        return new EnclosingStaticJoinPointImpl(SignatureFactory.newMethodSignature(declaringClass, AsmHelper.calculateMethodHash(name, description)), JoinPointType.METHOD_EXECUTION);
    }

    public static StaticInitializerSignatureImpl newStaticInitializationSignature(Class declaringClass) {
        return new StaticInitializerSignatureImpl(declaringClass);
    }
}

