/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression;

import gnu.trove.TObjectIntHashMap;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.ReflectionInfo;
import org.codehaus.aspectwerkz.reflect.StaticInitializationInfo;

public class ExpressionContext {
    public static final int INFO_NOT_AVAILABLE = -1;
    public static final int METHOD_INFO = 0;
    public static final int CONSTRUCTOR_INFO = 1;
    public static final int FIELD_INFO = 2;
    public static final int CLASS_INFO = 3;
    private static final int STATIC_INFO = 4;
    private final int m_reflectionInfoType;
    private final PointcutType m_pointcutType;
    private final ReflectionInfo m_matchingReflectionInfo;
    private final ReflectionInfo m_withinReflectionInfo;
    private boolean m_inCflowSubAST = false;
    private boolean m_cflowEvaluation = false;
    private boolean m_hasBeenVisitingCflow = false;
    private int m_currentTargetArgsIndex = 0;
    public TObjectIntHashMap m_exprIndexToTargetIndex = new TObjectIntHashMap();
    public String m_thisBoundedName = null;
    public String m_targetBoundedName = null;
    public boolean m_targetWithRuntimeCheck = false;

    public ExpressionContext(PointcutType pointcutType, ReflectionInfo reflectionInfo, ReflectionInfo withinReflectionInfo) {
        if (pointcutType == null) {
            throw new IllegalArgumentException("pointcut type can not be null");
        }
        this.m_pointcutType = pointcutType;
        this.m_matchingReflectionInfo = reflectionInfo;
        this.m_withinReflectionInfo = withinReflectionInfo != null ? withinReflectionInfo : (PointcutType.EXECUTION.equals(pointcutType) || PointcutType.STATIC_INITIALIZATION.equals(pointcutType) || PointcutType.WITHIN.equals(pointcutType) ? this.m_matchingReflectionInfo : null);
        this.m_reflectionInfoType = reflectionInfo instanceof MethodInfo ? 0 : (reflectionInfo instanceof ConstructorInfo ? 1 : (reflectionInfo instanceof FieldInfo ? 2 : (reflectionInfo instanceof ClassInfo ? 3 : (reflectionInfo instanceof StaticInitializationInfo ? 4 : -1))));
    }

    public ReflectionInfo getReflectionInfo() {
        return this.m_matchingReflectionInfo;
    }

    public ReflectionInfo getWithinReflectionInfo() {
        return this.m_withinReflectionInfo;
    }

    public boolean hasExecutionPointcut() {
        return this.m_pointcutType.equals(PointcutType.EXECUTION);
    }

    public boolean hasCallPointcut() {
        return this.m_pointcutType.equals(PointcutType.CALL);
    }

    public boolean hasSetPointcut() {
        return this.m_pointcutType.equals(PointcutType.SET);
    }

    public boolean hasGetPointcut() {
        return this.m_pointcutType.equals(PointcutType.GET);
    }

    public boolean hasHandlerPointcut() {
        return this.m_pointcutType.equals(PointcutType.HANDLER);
    }

    public boolean hasStaticInitializationPointcut() {
        return this.m_pointcutType.equals(PointcutType.STATIC_INITIALIZATION);
    }

    public boolean hasWithinPointcut() {
        return this.m_pointcutType.equals(PointcutType.WITHIN);
    }

    public boolean hasWithinReflectionInfo() {
        return this.m_withinReflectionInfo != null;
    }

    public boolean hasMethodInfo() {
        return this.m_reflectionInfoType == 0;
    }

    public boolean hasConstructorInfo() {
        return this.m_reflectionInfoType == 1;
    }

    public boolean hasFieldInfo() {
        return this.m_reflectionInfoType == 2;
    }

    public boolean hasClassInfo() {
        return this.m_reflectionInfoType == 3;
    }

    public boolean hasReflectionInfo() {
        return this.m_reflectionInfoType != -1;
    }

    public void setInCflowSubAST(boolean inCflowAST) {
        this.m_inCflowSubAST = inCflowAST;
    }

    public boolean inCflowSubAST() {
        return this.m_inCflowSubAST;
    }

    public void setHasBeenVisitingCflow(boolean hasBeenVisitingCflow) {
        this.m_hasBeenVisitingCflow = hasBeenVisitingCflow;
    }

    public boolean hasBeenVisitingCflow() {
        return this.m_hasBeenVisitingCflow;
    }

    public boolean getCflowEvaluation() {
        return this.m_cflowEvaluation;
    }

    public void setCflowEvaluation(boolean cflowEvaluation) {
        this.m_cflowEvaluation = cflowEvaluation;
    }

    public int getCurrentTargetArgsIndex() {
        return this.m_currentTargetArgsIndex;
    }

    public void setCurrentTargetArgsIndex(int argsIndex) {
        this.m_currentTargetArgsIndex = argsIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionContext)) {
            return false;
        }
        ExpressionContext expressionContext = (ExpressionContext)o;
        if (this.m_reflectionInfoType != expressionContext.m_reflectionInfoType) {
            return false;
        }
        if (!this.m_matchingReflectionInfo.equals(expressionContext.m_matchingReflectionInfo)) {
            return false;
        }
        if (!this.m_pointcutType.equals(expressionContext.m_pointcutType)) {
            return false;
        }
        return !(this.m_withinReflectionInfo != null ? !this.m_withinReflectionInfo.equals(expressionContext.m_withinReflectionInfo) : expressionContext.m_withinReflectionInfo != null);
    }

    public int hashCode() {
        int result = this.m_pointcutType.hashCode();
        result = 29 * result + this.m_matchingReflectionInfo.hashCode();
        result = 29 * result + (this.m_withinReflectionInfo != null ? this.m_withinReflectionInfo.hashCode() : 0);
        result = 29 * result + this.m_reflectionInfoType;
        return result;
    }

    public PointcutType getPointcutType() {
        return this.m_pointcutType;
    }

    public void resetRuntimeState() {
        this.m_targetBoundedName = null;
        this.m_thisBoundedName = null;
        this.m_exprIndexToTargetIndex = new TObjectIntHashMap();
        this.m_targetWithRuntimeCheck = false;
    }
}

