/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class AnnotationElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    String name;
    private Object valueHolder;
    protected boolean isLazyClass = false;
    protected boolean isLazyClassArray = false;

    public AnnotationElement(String name, Object valueHolder) {
        this.name = name;
        this.valueHolder = valueHolder;
        if (valueHolder instanceof LazyClass) {
            this.isLazyClass = true;
        } else if (valueHolder instanceof LazyClass[]) {
            this.isLazyClassArray = true;
        }
    }

    public Object resolveValueHolderFrom(ClassLoader loader) {
        if (this.isLazyClass) {
            return ((LazyClass)this.valueHolder).resolveFrom(loader);
        }
        if (this.isLazyClassArray) {
            Object[] annotationValueHolderArray = (Object[])this.valueHolder;
            Class[] resolved = new Class[annotationValueHolderArray.length];
            for (int i = 0; i < annotationValueHolderArray.length; ++i) {
                resolved[i] = ((LazyClass)annotationValueHolderArray[i]).resolveFrom(loader);
            }
            return resolved;
        }
        return this.valueHolder;
    }

    public String toString() {
        if (this.isLazyClass) {
            StringBuffer sb = new StringBuffer("class ");
            sb.append(((LazyClass)this.valueHolder).className);
            return sb.toString();
        }
        if (this.valueHolder == null) {
            return "null";
        }
        return this.valueHolder.toString();
    }

    public static class LazyClass
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String className;
        private String componentClassName = null;
        private int dimemsion = 0;

        public LazyClass(String className) {
            this.className = className;
            this.componentClassName = className;
            while (this.componentClassName.endsWith("[]")) {
                ++this.dimemsion;
                this.componentClassName = this.componentClassName.substring(0, this.componentClassName.length() - 2);
            }
        }

        public String toString() {
            return this.className;
        }

        public Class resolveFrom(ClassLoader loader) {
            try {
                if (this.dimemsion <= 0) {
                    return Class.forName(this.className, false, loader);
                }
                Class<?> componentClass = Class.forName(this.componentClassName, false, loader);
                return Array.newInstance(componentClass, this.dimemsion).getClass();
            }
            catch (ClassNotFoundException e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }
}

