/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;
import com.jurismarches.vradi.ui.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ClientNavigationTreeHelper
extends AdminNavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);
    protected NavigationModel<NavigationTreeNode> cachedModel;
    protected boolean datasChanged = false;

    public ClientNavigationTreeHelper(JAXXContext context) {
        super(VradiContext.getClientsEntryDef().getName(), context);
        JAXXContextEntryDef<List<Client>> clientsEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(clientsEntryDef, clientsEntryDef.getName(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ClientNavigationTreeHelper.this.datasChanged = true;
            }
        });
        JAXXContextEntryDef<List<Client>> usersEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(usersEntryDef, usersEntryDef.getName(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ClientNavigationTreeHelper.this.datasChanged = true;
            }
        });
    }

    @Override
    public NavigationModel<NavigationTreeNode> createTreeModel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createTreeModel()");
        }
        if (this.cachedModel != null && !this.datasChanged) {
            return this.cachedModel;
        }
        JAXXContext context = this.getContext();
        AdminHandler adminHandler = UIHelper.getHandler(context, AdminHandler.class);
        Map<Client, Set<String>> clients = adminHandler.getAllClients();
        NavigationTreeNode rootNode = (NavigationTreeNode)this.builder.buildEmptyRoot(null, "$root");
        JAXXContextEntryDef<List<Client>> clientEntryDef = VradiContext.getClientsEntryDef();
        NavigationTreeNode clientsNode = (NavigationTreeNode)this.builder.build((NavigationNode)rootNode, I18n._((String)clientEntryDef.getName()), clientEntryDef, "clients", AdminClientUI.class, null);
        List<User> userList = adminHandler.getAllUsers();
        ArrayList<String> userIdList = new ArrayList<String>(userList.size());
        for (User user : userList) {
            userIdList.add(user.getWikittyId());
        }
        for (Client client : clients.keySet()) {
            NavigationTreeNode clientNode = this.builder.addClient(clientsNode, client.getWikittyId());
            Set<String> clientUserIds = clients.get(client);
            if (clientUserIds == null || clientUserIds.isEmpty()) continue;
            for (String clientUserId : clientUserIds) {
                if (!userIdList.contains(clientUserId)) continue;
                this.builder.addUser(clientNode.getChildAt(0), clientUserId);
            }
        }
        this.cachedModel = this.builder.getModel();
        this.setModel(context, this.cachedModel);
        this.setSelectedNode(context, (NavigationNode)clientsNode);
        this.datasChanged = false;
        return this.cachedModel;
    }

    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeChildNode(node)");
        }
        JAXXContext context = this.getContext();
        Object bean = node.getBean();
        List<User> users = VradiContext.getUsersInEntryDef();
        AdminHandler adminHandler = UIHelper.getHandler(context, AdminHandler.class);
        Map<Client, Set<String>> clients = adminHandler.getAllClients();
        List<Group> groups = VradiContext.getGroupsInEntryDef();
        if (bean instanceof Client) {
            Client client = (Client)bean;
            if (groups != null && !groups.isEmpty()) {
                for (Group group : groups) {
                    Set<String> clientUsers;
                    Set<String> groupClients = group.getClient();
                    if (groupClients != null && !groupClients.isEmpty() && groupClients.contains(client.getWikittyId())) {
                        throw new IllegalStateException(I18n._((String)"vradi.exception.client.belongs.groups"));
                    }
                    if (group.getUser() == null || group.getUser().isEmpty() || (clientUsers = clients.get(client)) == null || clientUsers.isEmpty()) continue;
                    HashSet<String> groupUsers = new HashSet<String>(group.getUser());
                    groupUsers.retainAll(clientUsers);
                    if (groupUsers.isEmpty()) continue;
                    throw new IllegalStateException(I18n._((String)"vradi.exception.client.users.belongs.groups"));
                }
            }
            clients.remove(bean);
            Set<String> userIds = clients.get(client);
            if (userIds != null && !userIds.isEmpty()) {
                HashMap<String, User> userMap = new HashMap<String, User>();
                for (User user : users) {
                    userMap.put(user.getWikittyId(), user);
                }
                for (String userId : userIds) {
                    if (!userMap.containsKey(userId)) continue;
                    users.remove(userMap.get(userId));
                }
            }
        } else if (bean instanceof User) {
            User user = (User)bean;
            if (groups != null && !groups.isEmpty()) {
                for (Group group : groups) {
                    Set<String> groupUsers = group.getUser();
                    if (groupUsers == null || groupUsers.isEmpty() || !groupUsers.contains(user.getWikittyId())) continue;
                    throw new IllegalStateException(I18n._((String)"vradi.exception.user.belongs.groups"));
                }
            }
            users.remove(bean);
        }
        return super.removeChildNode(node);
    }
}

