/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiDTO;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public class VradiHelper {
    private static final Log log = LogFactory.getLog(VradiHelper.class);
    public static final String QUERIES = "vradi.queries";
    public static final String XML_STREAMS = "vradi.xmlStreams";
    public static final String CRITERIAS = "vradi.criterias";
    public static final String THESAURUS = "vradi.thesaurus";
    public static final String COLUMNS = "vradi.columns";
    public static final String LAST_VERSION = "vradi.lastVersion";
    public static final String THESAURUS_COLORS = "vradi.thesaurus.color";
    public static final String STATUS_COLOR = "vradi.status.color";
    public static final String COLOR_REGEX = "\\.\\d+";
    public static final String TYPE_DESCRIPTION = "description";
    public static final String TYPE_RANK = "rank";
    public static final String TYPE_LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String TYPE_LAST_MODIFIED_TIME = "lastModifiedTime";
    public static final String TYPE_LAST_MODIFIED_BY = "lastModifiedBy";
    public static final String TYPE_TEMPLATE = "template";
    public static final String EXPEND_SELECTED = "vradi.expend.selected";
    public static Properties userProperties = null;
    private static Map<String, Status> statusCache = new HashMap<String, Status>();

    public static VradiConfig getVradiConfig() {
        return VradiContext.get().getVradiConfig();
    }

    protected static Properties getUserProperties() {
        if (userProperties == null) {
            userProperties = VradiHelper.getProperties(VradiHelper.getVradiConfig().getUserFile());
        }
        return userProperties;
    }

    protected static Properties getProperties(File propertyFile) {
        Properties properties;
        try {
            properties = new Properties();
            if (VradiHelper.getVradiConfig().getVersion().getVersion() != null && !VradiHelper.getVradiConfig().getVersion().getVersion().isEmpty()) {
                if (!propertyFile.exists() && !propertyFile.createNewFile()) {
                    log.error((Object)("Failled to create new property file : " + propertyFile.getName()));
                }
                FileInputStream input = new FileInputStream(propertyFile);
                properties.load(input);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("could not get " + propertyFile.getName() + " caused by : " + ioe.getMessage(), ioe);
        }
        return properties;
    }

    protected static Properties store(Properties property, File file) {
        try {
            OutputStreamWriter fileOutputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1");
            property.store(fileOutputStream, "");
        }
        catch (IOException e) {
            log.error((Object)"Cant save request property caused by : ", (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        return property;
    }

    protected static void storeUserProperties(Properties properties) {
        File userFile = VradiHelper.getVradiConfig().getUserFile();
        if (userFile != null) {
            VradiHelper.store(properties, userFile);
        }
    }

    protected static List<String> getUserListOfStringFromProperties(String propertyName) {
        Properties properties = VradiHelper.getUserProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (properties != null) {
            String resultNames = properties.getProperty(propertyName);
            if (resultNames != null) {
                for (String resultName : resultNames.split(",")) {
                    String utf8ResultName;
                    try {
                        utf8ResultName = new String(resultName.getBytes("ISO-8859-1"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException eee) {
                        utf8ResultName = resultName;
                    }
                    result.add(utf8ResultName);
                }
            } else {
                log.warn((Object)("Cant find property : " + propertyName));
            }
        }
        return result;
    }

    protected static void storeUserListProperties(String propertyName, List<String> values) {
        Properties properties = VradiHelper.getUserProperties();
        if (properties != null) {
            StringBuffer store = new StringBuffer();
            for (String value : values) {
                store.append(value).append(",");
            }
            int length = store.length() - 1;
            if (length > 0) {
                store.deleteCharAt(length);
            }
            properties.setProperty(propertyName, store.toString());
            VradiHelper.storeUserProperties(properties);
        }
    }

    protected static void addToUserListProperties(String propertyName, String value) {
        VradiHelper.addToUserListProperties(propertyName, value, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace) {
        VradiHelper.addToUserListProperties(propertyName, value, replace, false, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace, boolean inverse, boolean uniqueValues) {
        ArrayList<String> result;
        List<Object> list = result = replace ? new ArrayList() : VradiHelper.getUserListOfStringFromProperties(propertyName);
        if (value != null) {
            String isoValue;
            try {
                isoValue = new String(value.getBytes("UTF-8"), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException eee) {
                isoValue = value;
            }
            if (uniqueValues && result.contains(isoValue)) {
                result.remove(isoValue);
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            } else if (inverse) {
                result.add(0, isoValue);
            } else {
                result.add(isoValue);
            }
        }
        VradiHelper.storeUserListProperties(propertyName, result);
    }

    protected static List<String> removeToUserListProperties(String propertyName, String value) {
        List<String> result = VradiHelper.getUserListOfStringFromProperties(propertyName);
        result.remove(value);
        VradiHelper.storeUserListProperties(propertyName, result);
        return result;
    }

    public static void addRequestToProperties(String request) {
        VradiHelper.addToUserListProperties(QUERIES, request, false, true, true);
    }

    public static List<String> loadRequests() {
        return VradiHelper.getUserListOfStringFromProperties(QUERIES);
    }

    public static void setLastItemOfXmlStream(String xmlStreamName, String value) {
        VradiHelper.addToUserListProperties("vradi.xmlStreams." + xmlStreamName, value, true);
    }

    public static String getLastItemOfXmlStream(String xmlStreamName) {
        List<String> prop = VradiHelper.getUserListOfStringFromProperties("vradi.xmlStreams." + xmlStreamName);
        if (!prop.isEmpty()) {
            return prop.get(0);
        }
        return null;
    }

    public static List<String> getVradiListCriteria() {
        return VradiHelper.getUserListOfStringFromProperties(CRITERIAS);
    }

    public static void removeVradiListCriteria(TreeNodeImpl value) {
        VradiHelper.removeToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static void addVradiListCriteria(TreeNodeImpl value) {
        VradiHelper.addToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static List<String> getVradiListThesaurus() {
        return VradiHelper.getUserListOfStringFromProperties(THESAURUS);
    }

    public static void removeVradiListThesaurus(TreeNodeImpl value) {
        VradiHelper.removeToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static void addVradiListThesaurus(TreeNodeImpl value) {
        VradiHelper.addToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static List<String> getVradiListColumns() {
        return VradiHelper.getUserListOfStringFromProperties(COLUMNS);
    }

    public static void removeVradiListColumns(String value) {
        VradiHelper.removeToUserListProperties(COLUMNS, value);
    }

    public static void addVradiListColumns(String value) {
        VradiHelper.addToUserListProperties(COLUMNS, value);
    }

    public static Map<Integer, Color> getColorsStatusFromProperties() {
        return VradiHelper.getColorsFromProperties(STATUS_COLOR);
    }

    public static void storeStatusColorToProperties(int i, Color toStore) {
        VradiHelper.storeColorToProperties(STATUS_COLOR, i, toStore);
    }

    public static Map<Integer, Color> getColorsThesaurusFromProperties() {
        return VradiHelper.getColorsFromProperties(THESAURUS_COLORS);
    }

    public static void storeThesaurusColorToProperties(int i, Color toStore) {
        VradiHelper.storeColorToProperties(THESAURUS_COLORS, i, toStore);
    }

    protected static String getColorRegex(String key) {
        return key + COLOR_REGEX;
    }

    public static Map<Integer, Color> getColorsFromProperties(String key) {
        Properties properties = VradiHelper.getUserProperties();
        if (properties == null) {
            return null;
        }
        Map<Integer, Color> result = new HashMap<Integer, Color>();
        for (Object property : properties.keySet()) {
            String propertyString = (String)property;
            if (!propertyString.matches(VradiHelper.getColorRegex(key))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Color match in propertie " + propertyString));
            }
            String colorValue = properties.getProperty(propertyString);
            Integer depth = Integer.parseInt(propertyString.split("\\.")[3]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found for depth " + depth + " colorValue " + colorValue));
            }
            String[] rgb = colorValue.split(",");
            result.put(depth, new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2])));
        }
        if (result.isEmpty()) {
            result = VradiHelper.loadDefaultColors(key);
        }
        return result;
    }

    protected static Map<Integer, Color> loadDefaultColors(String key) {
        Color[] colors = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
        for (int i = 0; i < 100; ++i) {
            VradiHelper.storeColorToProperties(key, i, colors[i % colors.length]);
        }
        return VradiHelper.getColorsThesaurusFromProperties();
    }

    protected static void storeColorToProperties(String key, int i, Color toStore) {
        Properties properties = VradiHelper.getUserProperties();
        properties.setProperty(key + "." + i, toStore.getRed() + "," + toStore.getGreen() + "," + toStore.getBlue());
        VradiHelper.storeUserProperties(properties);
    }

    public static boolean isExpandSelected() {
        Properties properties = VradiHelper.getUserProperties();
        String expendSelected = properties.getProperty(EXPEND_SELECTED);
        return Boolean.valueOf(expendSelected);
    }

    public static void storeExpandSelected(boolean expendSelected) {
        Properties properties = VradiHelper.getUserProperties();
        properties.setProperty(EXPEND_SELECTED, String.valueOf(expendSelected));
        VradiHelper.storeUserProperties(properties);
    }

    public static String getEntityName(Object o) {
        if (o == null) {
            return "";
        }
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)o, (String)"name");
            if (descriptor == null) {
                return "";
            }
            Method getter = descriptor.getReadMethod();
            Object invoke = getter.invoke(o, new Object[0]);
            if (invoke == null) {
                return "";
            }
            String result = (String)invoke;
            return result;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        return "";
    }

    public static FieldTypeEnum getFieldTypeEnum(FieldType type) {
        for (FieldTypeEnum typeEnum : FieldTypeEnum.values()) {
            if (!typeEnum.isType(type)) continue;
            return typeEnum;
        }
        return null;
    }

    public static String getFormTypeTemplate(WikittyExtension extension) {
        String result = extension == null ? null : extension.getTagValue(TYPE_TEMPLATE);
        return result;
    }

    public static Status getStatus(String statusId) {
        if (statusId == null) {
            return null;
        }
        Status status = statusCache.get(statusId);
        if (status == null) {
            VradiStorageService vradiStorageService = VradiService.getVradiStorageService();
            try {
                status = vradiStorageService.getStatus(statusId);
                statusCache.put(statusId, status);
            }
            catch (VradiException eee) {
                log.error((Object)("Cant get status : " + (Object)((Object)eee)));
            }
        }
        return status;
    }

    public static VradiFormPageDTO executeQuery(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus, String[] statusIds, VradiFormPageDTO formPageDTO) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)query);
            }
            formPageDTO.setFormsToShow(null);
            formPageDTO.setTotalFoundFormNb(0);
            if (formPageDTO.getNbFormsToShow() == 0) {
                formPageDTO.setNbFormsToShow(10);
            }
            if (formPageDTO.getPageToShow() == 0) {
                formPageDTO.setPageToShow(1);
            }
            formPageDTO = VradiService.getVradiStorageService().findForms2(query, extension, dateType, beginDate, endDate, (List[])thesaurus, statusIds, formPageDTO);
            if (log.isDebugEnabled()) {
                log.debug((Object)(formPageDTO.getTotalFoundFormNb() + " forms found"));
                for (Form form : formPageDTO.getFormsToShow()) {
                    log.debug((Object)(form.getWikittyId() + " : " + form.getObjet()));
                }
            }
        }
        catch (VradiException eee) {
            log.error((Object)"Cant execute query : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
            formPageDTO = new VradiFormPageDTO();
        }
        catch (UnsupportedQueryException e) {
            log.error((Object)e.getMessage());
            ErrorDialogUI.showError((Exception)((Object)e));
            formPageDTO = new VradiFormPageDTO();
        }
        return formPageDTO;
    }

    public static String getFieldTypeDescription(FieldType fieldType) {
        return fieldType == null ? null : fieldType.getTagValue(TYPE_DESCRIPTION);
    }

    public static int getFieldTypeRank(FieldType fieldType) {
        int result;
        try {
            result = Integer.valueOf(fieldType.getTagValue(TYPE_RANK));
        }
        catch (NumberFormatException eee) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no tag value for rank");
            }
            result = -1;
        }
        return result;
    }

    public static String getLastVersion() {
        Properties userProperties = VradiHelper.getUserProperties();
        return userProperties.getProperty(LAST_VERSION);
    }

    public static void setLastVersion(String lastVersion) {
        Properties userProperties = VradiHelper.getUserProperties();
        userProperties.setProperty(LAST_VERSION, lastVersion);
        VradiHelper.storeUserProperties(userProperties);
    }

    public static boolean isVersionNewer(String version) {
        if (VradiHelper.getLastVersion() == null) {
            return true;
        }
        String[] versionToken = version.split("\\.");
        String[] lastVersionToken = VradiHelper.getLastVersion().split("\\.");
        for (int i = 0; i < versionToken.length && i < lastVersionToken.length; ++i) {
            if (Integer.valueOf(versionToken[i]) > Integer.valueOf(lastVersionToken[i])) {
                return true;
            }
            if (Integer.valueOf(versionToken[i]) >= Integer.valueOf(lastVersionToken[i])) continue;
            return false;
        }
        return false;
    }

    public static <O extends BusinessEntity> List<O> findAllEntityInRef(JAXXContextEntryDef<List<O>> ref, List<String> wikittyIds) {
        ArrayList<O> result = new ArrayList<O>();
        for (String id : wikittyIds) {
            result.add(VradiHelper.findEntityInRef(ref, id));
        }
        return result;
    }

    public static <O extends BusinessEntity> O findEntityInRef(JAXXContextEntryDef<List<O>> ref, String wikittyId) {
        for (BusinessEntity entity : (List)ref.getContextValue((JAXXContext)VradiContext.get())) {
            if (!entity.getWikittyId().equals(wikittyId)) continue;
            return (O)entity;
        }
        return null;
    }

    public static File generatePDF(VradiStorageService storageService, Form form) throws Exception {
        List<File> files = VradiHelper.generatePDF(storageService, Collections.singletonList(form));
        if (files != null && !files.isEmpty()) {
            return files.get(0);
        }
        return null;
    }

    public static List<File> generatePDF(VradiStorageService storageService, List<Form> forms) throws VradiException {
        ArrayList<File> files = new ArrayList<File>();
        for (Form form : forms) {
            String extensionName = null;
            for (String ext : form.getExtensionNames()) {
                if (ext.equals("Infogene") || ext.equals("Form")) continue;
                extensionName = ext;
                break;
            }
            WikittyExtension extension = storageService.getFormType(extensionName);
            String template = VradiHelper.getFormTypeTemplate(extension);
            File templateFile = storageService.getTemplate(extensionName, template);
            Map fieldMap = storageService.getAssociatedFields(extension.getName(), template);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generating PDF file for form " + form.getWikittyId() + " (template = " + template + ")"));
            }
            try {
                List<Form> currentForms = Collections.singletonList(form);
                List filesToAdd = VradiService.getMailingService().generateFilledDocumentInPDF(templateFile, currentForms, fieldMap, false);
                if (filesToAdd == null || filesToAdd.isEmpty()) continue;
                files.addAll(filesToAdd);
            }
            catch (Exception eee) {
                throw new VradiException("Cant generate pdf : ", (Throwable)eee);
            }
        }
        return files;
    }

    public static List<String> extractDTOIds(List<? extends VradiDTO<?>> dtos) {
        ArrayList<String> ids = new ArrayList<String>();
        for (VradiDTO<?> dto : dtos) {
            ids.add(dto.getWikittyId());
        }
        return ids;
    }

    public static List<String> extractIds(List<? extends BusinessEntity> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        for (BusinessEntity businessEntity : beans) {
            ids.add(businessEntity.getWikittyId());
        }
        return ids;
    }
}

