/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.admin;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdom.Element;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Infogene;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.models.FieldSelectModel;
import com.jurismarches.vradi.models.FieldTypeModel;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.content.AdminStatusUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FormNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.StatusEditionUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;

/**
 * @author letellier
 */
public class AdminHandler {
    static private final Log log = LogFactory.getLog(AdminHandler.class);

    static public final int TOOLTIP_LINE_MAX_CHAR_NB = 100;
    static public final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;

    public AdminPopupUI init(JAXXContext rootContext, Object... datas) {
        AdminPopupUI ui = VradiContext.ADMIN_UI_ENTRY_DEF
                .getContextValue(rootContext);

        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext()
                    .add(rootContext).add(this);

            VradiMainUI mainUI = VradiContext.MAIN_UI_ENTRY_DEF
                    .getContextValue(context);

            ui = new AdminPopupUI(context, mainUI);

            VradiContext.ADMIN_UI_ENTRY_DEF.setContextValue(rootContext, ui);
        } else {
            // Reinit thesaurus
            log.info("Reinit thesaurus");
            ui.getAdminThesaurus()
                    .reinit(new ThesaurusTreeHelper(ui, ThesaurusHandler.PREFIX_EDIT));
        }
        return ui;
    }

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI) context;
        }
        AdminPopupUI ui = VradiContext.ADMIN_UI_ENTRY_DEF
                .getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        AdminPopupUI ui = getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    protected XmlStreamService getXmlStreamService() {
        return ServiceHelper.getXmlStreamService();
    }

    // COMMON
    protected boolean answerToDelete(JAXXContext context, String name) {
        AdminPopupUI ui = getUI(context);

        int n = JOptionPane.showConfirmDialog(ui,
                _("vradi.admin.deleteAnswer") + name + " ?",
                _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);

        return n == JOptionPane.OK_OPTION;
    }

    protected void repaintSelectedNode(JAXXContext context,
                                       VradiNavigationTreeHelper helper) {
        helper.repaintNode(context, getSelectedNode(context, helper));
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context,
                                                 VradiNavigationTreeHelper helper) {
        return helper.getSelectedNode(context);
    }

    public void save(Object bean) {
        BusinessEntity entity = (BusinessEntity) bean;
        try {
            // up
            getVradiStorageService().updateEntity(entity);
        } catch (TechnicalException ex) {
            log.error("Cant saving bean : " + entity + " id : "
                    + entity.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
    }

    public void save(JAXXContext context, VradiNavigationTreeHelper helper,
                     Object... beans) {
        try {
            for (Object bean : beans) {
                log.debug("will save bean " + bean);
                save(bean);
            }

        } finally {
            // Refresh nav
            repaintSelectedNode(context, helper);
        }
    }
                 
    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null) {

            log.info("current content  to close "
                    + content.getClass().getSimpleName() + " : " + content
                    .isModified());
            if (content.isModified()) {
                int n = JOptionPane.showConfirmDialog(content,
                        _("vradi.admin.saveAnswer")
                                + VradiHelper.getEntityName(content.getBean())
                                + " ?", _("vradi.admin.saveTitle"),
                        JOptionPane.YES_NO_CANCEL_OPTION);
                switch (n) {
                    case JOptionPane.NO_OPTION:
                        // annule les modifications
                        cancel(content, content.getHelper(), false);
                        break;
                    case JOptionPane.OK_OPTION:
                        // sauvegarde les modifications
                        content.postSave();
                        break;
                    case JOptionPane.CANCEL_OPTION:
                        // annule le changement d'onglet
                        return false;

                }
            }
        }
        return true;
    }

    public void delete(JAXXContext context, VradiNavigationTreeHelper helper,
                       Object bean) {
        BusinessEntity entity = (BusinessEntity) bean;
        try {
            // up
            getVradiStorageService().deleteEntity(entity);

        } catch (TechnicalException ex) {
            log.error("Cant delete bean : " + entity + " id : "
                    + entity.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        } finally {

            // remove node
            NavigationTreeNode parent = helper
                    .removeChildNode(helper.getSelectedNode(context));

            // select parent node
            helper.selectNode(context, parent);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content,
                              VradiNavigationTreeHelper helper,
                              boolean trigerredByCancelButton) {
        int confirm = -1;
        if(trigerredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(content,
                    _("vradi.admin.cancel.message"),
                    _("vradi.admin.cancel.title"),
                    JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        if(!trigerredByCancelButton || confirm == JOptionPane.YES_OPTION) {
            B selectedBean = content.getSelectedEntity();
            try {
                content.openUI(helper.getSelectedNode(content));
            } catch (Exception e) {
                log.error(
                        "Cant cancel bean : " + selectedBean + " caused by : " + e,
                        e);
                ErrorDialogUI.showError(e);
            }
        }
    }

    public ComboBoxModel getTypesModel() {
        ComboBoxModel model = new FieldTypeModel();
        return model;
    }

    // REQUEST
    public void openRequest(final JAXXContext rootContext, List<VradiThesaurusDTO> thesaurus) {
        openRequest(rootContext, null, thesaurus);
    }

    public void openRequest(final JAXXContext rootContext, String request) {
        openRequest(rootContext, request, null);
    }
    
    public void openRequest(final JAXXContext rootContext, String request, List<VradiThesaurusDTO> thesaurus) {
        final JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        final SearchHandler searchHandler = new SearchHandler();
        final OfferListTableModel offerListTableModel = new OfferListTableModel();
        final OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        
        context.add(searchHandler);
        context.add(offerListTableModel);
        context.add(offerListColumnFactory);

        final AdminRequestUI requestUI = new AdminRequestUI(context);
        
        // add listeners
        final JXTable listTable = requestUI.getResultTable();
            
        final MouseListener offerListTableMouseListener =
            getOfferListTableMouseListener(requestUI, listTable, offerListTableModel);
        listTable.addMouseListener(offerListTableMouseListener);
        
        final TableModelListener offerListTableModelListener =
            getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        
        // listTable cellRenderer
        final OfferListTableModel.OfferListTableCellRenderer renderer =
                new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        
        // listTable highlighter
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
    
        // search ui
        final SearchUI searchUI = searchHandler.initCloneUI(context, offerListTableModel, thesaurus);
        if (request != null){
            searchUI.setRequest(request);
        } else {
            // If it's for visualisation
            if (thesaurus != null){
                requestUI.setCanSave(false);
                searchUI.setHidable(false);
            }
        }
        requestUI.getSearchPanel().add(searchUI, BorderLayout.CENTER);
        
        // execute search
        final VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
        searchHandler.executeQuery(searchUI, searchUI.getCriterias(), formPageDTO, null, request);
        offerListTableModel.setFormPageDTO(formPageDTO);
        
        requestUI.addPropertyChangeListener(AdminRequestUI.PROPERTY_REQUEST,
            new PropertyChangeListener() {
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String newValue = (String) evt.getNewValue();
                    RequestSelectUI ui = (RequestSelectUI) rootContext;
                    ui.setBean(newValue);
                }
            });
        
        requestUI.setVisible(true);
    }

    private MouseListener getOfferListTableMouseListener(
            final AdminRequestUI requestUI,
            final JTable resultTable,
            final OfferListTableModel offerListTableModel) {
        
        // double click on resultTable shows selected offer
        return new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    requestUI.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

                    int row = resultTable.getSelectedRow();
                    Form form = offerListTableModel.getFormPageDTO().getFormsToShow().get(row);
                    UIHelper.openFormPopup(requestUI, form);
                    
                    requestUI.setCursor(null);
                }
            }
        };
    }
    
    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    // STATUS
    public List<Status> getAllStatuses() {
        List<Status> values = new ArrayList<Status>();
        try {
            values.addAll(getVradiStorageService().getAllStatuses());
            Collections.sort(values, STATUSES_COMPARATOR);
        } catch(TechnicalException eee) {
            log.error("Cant get the statuses : " + eee);
            ErrorDialogUI.showError(eee);
        }
        // always return a safe copy
        return new ArrayList<Status>(values);
    }

    public void saveStatuses(AdminStatusUI ui) {
        List<Status> existingStatuses = getAllStatuses();
        List<String> existingStatusIds = new ArrayList<String>();
        for(Status status : existingStatuses) {
            existingStatusIds.add(status.getWikittyId());
        }
        List<Status> statusesToAdd = new ArrayList<Status>();
        int statusValue = 0;
        for(int i = 0 ; i < ui.getContent().getComponentCount() ; i++) {
            StatusEditionUI editionUI =
                    (StatusEditionUI) ui.getContent().getComponent(i);
            Status status = editionUI.getWikitty();
            editionUI.getBean().toWikitty(status);
            if(log.isDebugEnabled()) {
                log.debug("status to update : " + status.getName());
            }
            status.setValue(statusValue++);
            statusesToAdd.add(status);
        }

        List<String> statusesToDelete = new ArrayList<String>();
        for(int i = 0 ; i < ui.getDeletedContent().getComponentCount() ; i++) {
            StatusEditionUI editionUI =
                    (StatusEditionUI) ui.getDeletedContent().getComponent(i);
            if(existingStatusIds.contains(editionUI.getWikitty().getWikittyId())) {
                statusesToDelete.add(editionUI.getWikitty().getWikittyId());

                if(log.isDebugEnabled()) {
                    log.debug("status to delete : " + editionUI.getWikitty().getWikittyId());
                }
            }
        }
        ui.getDeletedContent().removeAll();

        try {
            getVradiStorageService().updateStatuses(statusesToAdd);
            getVradiStorageService().deleteStatuses(statusesToDelete);
        } catch(TechnicalException eee) {
            log.error("Cant update the statuses : " + eee);
            ErrorDialogUI.showError(eee);
        }

    }

    // CLIENT
    public List<Client> getAllClients(JAXXContext context) {
        List<Client> values = VradiNavigationTreeHelper.CLIENTS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<Client>(values);
    }

    public List<User> getAllUsers(JAXXContext context) {
        List<User> values = VradiNavigationTreeHelper.USERS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<User>(values);
    }

    public void createClient(JAXXContext context,
                             VradiNavigationTreeHelper helper) {
        NavigationTreeNode addClient = helper
                .addClientToSelected(context, null);
        helper.selectNode(context, addClient);
    }

    // USER
    public void createUser(JAXXContext context,
                           VradiNavigationTreeHelper helper) {
        NavigationTreeNode addUser = helper.addUserToSelected(context, null);
        helper.selectNode(context, addUser);
    }

    // GROUP

    public List<Group> getAllGroups(JAXXContext context) {
        List<Group> values = VradiNavigationTreeHelper.GROUPS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<Group>(values);
    }

    public void createGroup(JAXXContext context,
                            VradiNavigationTreeHelper helper) {
        NavigationTreeNode addGroup = helper.addGroupToSelected(context, null);
        helper.selectNode(context, addGroup);
    }

    // FORM
    public List<WikittyExtension> getAllForms(JAXXContext context) {
        List<WikittyExtension> values = VradiNavigationTreeHelper.FORMS
                .getContextValue(context);
        // always return a safe copy
        return new ArrayList<WikittyExtension>(values);
    }

    public void createFormType(JAXXContext context,
                               VradiNavigationTreeHelper helper) {
        String name = JOptionPane
                .showInputDialog(getUI(context), _("vradi.adminForm.askName"));

        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name,
                    WikittyUtil.DEFAULT_VERSION,
                    Form.EXT_FORM, new LinkedHashMap<String, FieldType>());
            NavigationTreeNode addFormType = helper
                    .addFormTypeToSelected(context, formType);
            helper.selectNode(context, addFormType);
        }
    }

    public void createForms(JAXXContext context) {
        AdminXmlStreamUI ui = getXmlStreamUI(context);
        XmlStream xmlStream = ui.getBean();
        VradiUser vradiUser = ui.getContextValue(VradiUser.class);
        if (xmlStream != null) {
            try {
                log.debug("create forms");
                Object[] formCreationResults = getVradiStorageService()
                        .getFormsFromXmlStream(xmlStream,
                                VradiHelper.getLastItemOfXmlStream(
                                        xmlStream.getName()), vradiUser);
                if(formCreationResults != null) {
                    String lastItem = (String)formCreationResults[0];
                    VradiHelper.setLastItemOfXmlStream(
                            xmlStream.getName(), lastItem);

                    String optionMessage;
                    Integer nbFormCreated = (Integer)formCreationResults[1];
                    if(log.isDebugEnabled()) {
                        log.debug("nbFormsCreated : " + nbFormCreated);
                    }
                    Integer dateErrorParsing = (Integer)formCreationResults[2];
                    Integer numberErrorParsing = (Integer)formCreationResults[3];
                    boolean warning = dateErrorParsing > 0 || numberErrorParsing > 0;
                    if(dateErrorParsing > 0) {
                        if(numberErrorParsing > 0) {
                            optionMessage = _(
                                    "vradi.admin.formsCreated.message.allWarning",
                                    nbFormCreated,
                                    dateErrorParsing,
                                    numberErrorParsing);
                        } else {
                            optionMessage = _(
                                    "vradi.admin.formsCreated.message.numberWarning",
                                    nbFormCreated, numberErrorParsing);
                        }
                    } else {
                        if(numberErrorParsing > 0) {
                           optionMessage = _(
                                    "vradi.admin.formsCreated.message.dateWarning",
                                    nbFormCreated,
                                    dateErrorParsing,
                                    numberErrorParsing);
                        } else {
                           optionMessage = _(
                                    "vradi.admin.formsCreated.message.noWarning",
                                    nbFormCreated);
                        }
                    }
                    JOptionPane.showMessageDialog(ui,
                            _("vradi.admin.formsCreated.message") + optionMessage,
                            _("vradi.admin.formsCreated.title"),
                            warning ?
                                    JOptionPane.WARNING_MESSAGE :
                                    JOptionPane.INFORMATION_MESSAGE);
                }

            } catch (Exception ex) {
                if(log.isErrorEnabled()) {
                    log.error("Cant create form : " + ex);
                }
                ErrorDialogUI.showError(ex);
            }
        }
    }

    public void saveFormType(JAXXContext context,
                             VradiNavigationTreeHelper helper,
                             java.util.List<FieldSelectModel> fields,
                             WikittyExtension formType) {
//        WikittyExtension newFormType = (WikittyExtension) helper.getSelectedBean(context);
        WikittyExtension newFormType = new WikittyExtension(formType.getName(),
                formType.getVersion(), formType.getRequires(), null);
        FieldSelectModel[] models = new FieldSelectModel[fields.size()];
        for (FieldSelectModel field : fields) {
            models[field.getPosition()] = field;
        }
        for (int i = 0; i < models.length; i++) {
            FieldSelectModel model = models[i];
            String name = model.getNameValue();
            if (name != null && model.getType() != null) {
                FieldType fieldType = model.getType().getFieldType();
                if (model.getDescValue() != null && !model.getDescValue()
                        .isEmpty()) {
                    fieldType.addTagValue(VradiHelper.TYPE_DESCRIPTION,
                            model.getDescValue());
                }
                newFormType.addField(name, fieldType);
            }
        }
        Date now = new Date();
        newFormType.addTagValue(VradiHelper.TYPE_LAST_MODIFIED_DATE,
                String.format("%1$td/%1$tm/%1$ty", now));
        newFormType.addTagValue(VradiHelper.TYPE_LAST_MODIFIED_TIME,
                String.format("%1$tk:%1$tM:%1$tS", now));
        newFormType.addTagValue(VradiHelper.TYPE_LAST_MODIFIED_BY,
                context.getContextValue(VradiUser.class).getName());
        try {
            // up
            getVradiStorageService().updateFormType(newFormType);

            NavigationTreeNode selectedNode = helper.getSelectedNode(context);
            List<WikittyExtension> forms = FormNavigationTreeHelper.FORMS
                    .getContextValue(context);
            forms.remove(selectedNode.getBean());
            forms.add(newFormType);
            selectedNode.setBean(newFormType);

            selectedNode.reload(context);

            UIHelper.getHandler(context, SearchHandler.class)
                    .getCriterias(context).getFormTypeSelection().setModel(
                    new DefaultComboBoxModel(VradiHelper.getFormTypes()));

            // Refresh main menu
            VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context)
                    .updateFormMenu();

        } catch (TechnicalException ex) {
            log.error("Cant adding formType : " + formType.getName() + " id : "
                    + formType.getId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return getVradiStorageService().getFormType(extensionName);
        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
                ErrorDialogUI.showError(e);
            }
            return null;
        }
    }
//    public void deleteForm(JAXXContext context, WikittyExtension form){
//        // del
//        if (answerToDelete(context, form.getName())){
//            try {
//                getVradiStorageService(context).deleteFormType(form);
//
//                // Refresh nav
//                AdminNavUI adminFormUI = getUI(context).getAdminFormUI();
//                delItemToNav(adminFormUI, form);
//            } catch (TechnicalException ex) {
//                log.error("Cant deleting user : " + form.getName() + " id : " + form.getId() + " caused by : " + ex);
//            }
//        }
//    }

    // RSS
    /**
     * Cache of the already loaded urls : keeps only the first Element parsed
     */
    public static final Map<String, Element> XML_STREAM_FIELDS_CACHE
            = new HashMap<String, Element>();

    public void createXmlStream(JAXXContext context,
                                VradiNavigationTreeHelper helper) {
        NavigationTreeNode addXmlStream = helper
                .addXmlStreamToSelected(context, null);
        helper.selectNode(context, addXmlStream);
    }

//    public void deleteXmlStream(JAXXContext context, XmlStream xmlStream) {
//        // del
//        if (answerToDelete(context, xmlStream.getUrl())) {
//            try {
//                getVradiStorageService().deleteXmlStream(xmlStream.getWikittyId());
//            } catch (TechnicalException ex) {
//                log.error("Cant deleting xmlStream : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex);
//            }
//        }
//    }

//    public VradiXmlStreamDTO saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper,
//                                           XmlStream xmlStream, List<XmlFieldBinding> bindings) {
//        VradiXmlStreamDTO result = new VradiXmlStreamDTO();
//        result.fromWikitty(xmlStream);
//        try {
//            getVradiStorageService().updateXmlFieldBindings(bindings);
//            xmlStream.clearXmlFieldBinding();
//            for (XmlFieldBinding binding : bindings) {
//                xmlStream.addXmlFieldBinding(binding.getWikittyId());
//            }
//            xmlStream = getVradiStorageService().updateXmlStream(xmlStream);
//            result.fromWikitty(xmlStream);
//
//            // Refresh nav
//            repaintSelectedNode(context, helper);
//        } catch (TechnicalException ex) {
//            log.error("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex);
//        }
//        return result;
//    }

    public XmlStream saveXmlStream(JAXXContext context,
                                   VradiNavigationTreeHelper helper,
                                   XmlStream xmlStream,
                                   List<XmlFieldBinding> bindings) {
        XmlStream result = null;
        try {
            bindings = getVradiStorageService()
                    .updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                if (log.isDebugEnabled()) {
                    log.debug(binding.getFormField() + " : " + (
                            binding.getXmlField() != null ? binding
                                    .getXmlField().size() : "null"));
                }
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            result = (XmlStream) getVradiStorageService()
                    .updateEntity(xmlStream);
            if (log.isDebugEnabled()) {
                if (result != null) {
                    for (String s : result.getXmlFieldBinding()) {
                        log.debug(getVradiStorageService()
                                .getXmlFieldBinding(s).getXmlField());
                    }
                }
            }

            // Refresh nav
            repaintSelectedNode(context, helper);
        } catch (TechnicalException ex) {
            log.error("Cant adding client : " + xmlStream.getUrl() + " id : "
                    + xmlStream.getWikittyId() + " caused by : " + ex);
            ErrorDialogUI.showError(ex);
        }
        return result;
    }

//    public List<String> getXmlStreamAttributes(String url) {
//        List<String> xmlFields = new ArrayList<String>();
//        try {
//            xmlFields = getXmlStreamService().getRSSFields(url);
//        } catch (TechnicalException eee) {
//            eee.printStackTrace();
//        }
//
//        return xmlFields;
//    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        List<XmlFieldBinding> result;
        try {
            result = getVradiStorageService().getXmlFieldBindings(xmlStream);
            if (log.isDebugEnabled()) {
                for (XmlFieldBinding xmlFieldBinding : result) {
                    log.debug(xmlFieldBinding.getFormField() + " : "
                            + xmlFieldBinding.getXmlField());
                }
            }
        } catch (TechnicalException eee) {
            log.error("Cant get xml stream : ", eee);
            ErrorDialogUI.showError(eee);
            result = new ArrayList<XmlFieldBinding>();
        }
        return result;
    }

    public WikittyExtension getFormType(XmlStream xmlStream) {
        if(xmlStream == null) {
            return null;
        }
        WikittyExtension result = getExtension(xmlStream.getFormTypeName());
        if(result == null) {
            List<XmlFieldBinding> bindings = getXmlStreamFields(xmlStream);
            for (XmlFieldBinding binding : bindings) {

                String formField = binding.getFormField();
                if (formField != null) {

                    String extensionName = formField.substring(0,
                            formField.lastIndexOf('.'));

                    if (!Form.EXT_FORM.equals(extensionName) &&
                            !Infogene.EXT_INFOGENE.equals(extensionName)) {

                        result = getExtension(extensionName);
                        if (result != null) {
                            break;
                        }
                    }
                }
            }
        }
        return result;
    }

    public void updateFieldsModel(JAXXContext context) {
        AdminXmlStreamUI ui = getXmlStreamUI(context);

        XmlStreamFieldTableModel fieldsModel = getXmlStreamUI(context)
                .getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);

        try {

            fieldsModel.clear();

            VradiXmlStreamDTO bean = ui.getBean();

            List<XmlFieldBinding> bindings = getXmlStreamFields(bean);

            WikittyExtension formType = bean.getFormType();
            if (formType == null) {

                // pas de type de formulaire
                if (log.isDebugEnabled()) {
                    log.debug("No form type, stop update");
                }
                return;
            }

            String url = bean.getUrl();
            if (url == null || url.trim().isEmpty()) {
                // pas d'url
                if (log.isDebugEnabled()) {
                    log.debug("No url, stop update");
                }
                return;
            }

            // recuperation des chanmps xml disponibles
            List<String> xmlFieldNames = new ArrayList<String>();
            Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
            if (xmlStreamFields.get(url) == null) {
                try {
                    Element firstElement = getXmlStreamService()
                            .getFirstElement(url);
                    xmlFieldNames = getXmlStreamService()
                            .getRSSFields(firstElement);
                    xmlStreamFields.put(url, firstElement);
                } catch (Exception eee) {
                    log.error("Can't bind xml stream : " + eee);
                    JOptionPane.showMessageDialog(ui,
                            _("vradi.adminXmlStream.badURL.message"),
                            _("vradi.adminXmlStream.badURL.title"),
                            JOptionPane.ERROR_MESSAGE);
                    return;
                }
            } else {
                xmlFieldNames = getXmlStreamService()
                        .getRSSFields(xmlStreamFields.get(url));
            }

            // mise a jour de l'univers des valeurs selectionnables
            ui.getContextValue(JListCellEditor.class)
                    .updateUniverse(xmlFieldNames);
            ui.getContextValue(JListCellRenderer.class)
                    .updateUniverse(xmlFieldNames);

            if (xmlFieldNames.size() > 0) {
                ui.getFieldsTable().setRowHeight(19 * xmlFieldNames.size());
            }

            // recuperation des noms des champs disponibles
            LinkedHashMap<String, XmlFieldBinding> fieldNames
                    = new LinkedHashMap<String, XmlFieldBinding>();

            fieldNames.put(Form.FQ_FIELD_OBJET, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DESCRIPTION,
                    new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DATEPUB, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DATEPEREMPTION,
                    new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_ENTITY, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_COUNTRY, new XmlFieldBindingImpl());
            fieldNames.put(Form.FQ_FIELD_DEPARTMENT, new XmlFieldBindingImpl());
            for (String fieldName : formType.getFieldNames()) {
                fieldNames.put(formType.getName() + "." + fieldName,
                        new XmlFieldBindingImpl());
            }

            // ajout des bindings existants
            for (XmlFieldBinding binding : bindings) {
                String formField = binding.getFormField();
                if (log.isDebugEnabled()) {
                    log.debug(formField);
                }
                if (fieldNames.get(formField) != null) {
                    fieldNames.put(formField, binding);
                }
            }

            // ajout des nouveaux bindings
            for (String fieldName : fieldNames.keySet()) {
                XmlFieldBinding binding = fieldNames.get(fieldName);
                if (binding != null) {
                    binding.setFormField(fieldName);
                    fieldsModel.addEntry(binding);
                }
            }

        } catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
                ErrorDialogUI.showError(e);
            }
        } finally {

            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }

    private AdminXmlStreamUI getXmlStreamUI(JAXXContext context) {
        if (context instanceof AdminXmlStreamUI) {
            return (AdminXmlStreamUI) context;
        }
        return null;
    }

    public String getFirstElementPreview(JAXXContext context, String url) {
        if (url == null || url.trim().isEmpty()) {
            return "";
        }
        
        Element firstElement = null;
        Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        
        if (xmlStreamFields.get(url) == null) {
            AdminXmlStreamUI ui = getXmlStreamUI(context);
            try {
                ui.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                firstElement = getXmlStreamService().getFirstElement(url);
                xmlStreamFields.put(url, firstElement);
            } catch (Exception eee) {
                return "";
            } finally {
                ui.setCursor(null);
            }
            
        } else {
            firstElement = xmlStreamFields.get(url);
        }
        
        if (firstElement == null) {
            return "";
        }
        
        try {
            Map<String, String> elementValues = getXmlStreamService()
                    .getFirstElementValues(firstElement);
            
            StringBuffer result = new StringBuffer();
            result.append("<html>");
            
            for (Map.Entry<String, String> entry : elementValues.entrySet()) {
                result.append("<strong>").append(entry.getKey())
                        .append("</strong>").append(" : ");
                
                String value = entry.getValue();
                if (value.length() > TOOLTIP_ELEMENT_MAX_CHAR_NB) {
                    value = StringUtils.replace(value, "\r", "");
                    value = StringUtils.replace(value, "\n\n", "\n");
                    value = StringUtils.abbreviate(value, TOOLTIP_ELEMENT_MAX_CHAR_NB);
                    value = StringUtils.replace(value, "\n", "<br/>");
                }
                result.append(value).append("<br/>");
            }
            result.append("</html>");

            return result.toString();

        } catch (TechnicalException e) {
            log.error(e.getMessage(), e);
            return "";
        }
    }

    /**
     * Create the model and store it in the given context.
     * <p/>
     *
     * @param context the context where to hold the model
     */
    public void createModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug("createModel");
        }
        try {
            List<WikittyExtension> allForms = getVradiStorageService()
                    .getAllFormTypes();
            Collections.sort(allForms, FORM_COMPARATOR);
            VradiNavigationTreeHelper.FORMS.setContextValue(context, allForms);

            List<Status> allStatuses = getVradiStorageService()
                    .getAllStatuses();
            Collections.sort(allStatuses, STATUSES_COMPARATOR);
            VradiNavigationTreeHelper.STATUSES.setContextValue(context, allStatuses);

            List<Group> allGroups = getVradiStorageService().getAllGroups();
            Collections.sort(allGroups, GROUP_COMPARATOR);
            VradiNavigationTreeHelper.GROUPS
                    .setContextValue(context, allGroups);

            List<Client> clients = getVradiStorageService().getAllClients();
            Collections.sort(clients, CLIENT_COMPARATOR);
            VradiNavigationTreeHelper.CLIENTS.setContextValue(context, clients);

            List<XmlStream> xmlStreams = getVradiStorageService()
                    .getAllXmlStreams();
            Collections.sort(xmlStreams, XML_STREAM_COMPARATOR);
            VradiNavigationTreeHelper.XMLSTREAMS
                    .setContextValue(context, xmlStreams);

            List<User> users = new ArrayList<User>();
            for (Client c : clients) {
                Set<String> usersId = c.getUser();
                if (usersId != null) {
                    for (String userId : usersId) {
                        User user = getVradiStorageService().getUser(userId);
                        users.add(user);
                    }
                }
            }
            Collections.sort(users, USER_COMPARATOR);
            VradiNavigationTreeHelper.USERS.setContextValue(context, users);
        } catch (TechnicalException ex) {
            log.error(ex);
            ErrorDialogUI.showError(ex);
            //FIXME should we do something ??? (return an empty model for example)
        }
    }

    protected static final Comparator<Client> CLIENT_COMPARATOR
            = new Comparator<Client>() {

        @Override
        public int compare(Client o1, Client o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<User> USER_COMPARATOR
            = new Comparator<User>() {

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Group> GROUP_COMPARATOR
            = new Comparator<Group>() {

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<WikittyExtension> FORM_COMPARATOR
            = new Comparator<WikittyExtension>() {

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Status> STATUSES_COMPARATOR
            = new Comparator<Status>() {

        @Override
        public int compare(Status o1, Status o2) {
            return o1.getValue() - o2.getValue();
        }
    };
    protected static final Comparator<XmlStream> XML_STREAM_COMPARATOR
            = new Comparator<XmlStream>() {

        @Override
        public int compare(XmlStream o1, XmlStream o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
}

