package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferListUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADVANCED_SEARCH_COLLAPSED = "advancedSearchCollapsed";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.OfferListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean advancedSearchCollapsed;
    protected javax.swing.JTabbedPane editTabs;
    protected javax.swing.JButton exportButton;
    protected org.jdesktop.swingx.JXTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.OfferListTableModel offerListTableModel;
    protected javax.swing.JPanel paginationPanel;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        final JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1) {
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    final String fqName = offerListTableModel.getColumnFqName(columnIndex);
                    offerListTableModel.setAscending(!offerListTableModel.isAscending());
                    offerListTableModel.setFieldToSort(fqName);
                } 
            }
        });
    
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "offerListTableModel", offerListTableModel) {
           @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                    getSearchHandler().executeQuery(offerList);
                    setCursor(null);
                }
            }
        };
      
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportButton(java.awt.event.ActionEvent event) {
        getSearchHandler().exportToCSV(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAdvancedSearchCollapsed() {
        return advancedSearchCollapsed;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public javax.swing.JButton getExportButton() {
        return exportButton;
    }

    public org.jdesktop.swingx.JXTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JPanel getPaginationPanel() {
        return paginationPanel;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean isAdvancedSearchCollapsed() {
        return advancedSearchCollapsed !=null && advancedSearchCollapsed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAdvancedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advancedSearchCollapsed;
        this.advancedSearchCollapsed = newValue;
        firePropertyChange(PROPERTY_ADVANCED_SEARCH_COLLAPSED, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void addChildrenToPaginationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        paginationPanel.add(paginationUI, BorderLayout.NORTH);
        paginationPanel.add(exportButton, BorderLayout.SOUTH);
    }

    protected void createAdvancedSearchCollapsed() {
        $objectMap.put("advancedSearchCollapsed", advancedSearchCollapsed = false);
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        editTabs.setName("editTabs");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new javax.swing.JButton());
        exportButton.setName("exportButton");
        exportButton.setText(_("vradi.export.cvs"));
        exportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportButton"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new org.jdesktop.swingx.JXTable());
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPaginationPanel() {
        $objectMap.put("paginationPanel", paginationPanel = new javax.swing.JPanel());
        paginationPanel.setName("paginationPanel");
        paginationPanel.setLayout(new BorderLayout());
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        paginationUI.setName("paginationUI");
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add(searchPanel, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationPanel, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listTable);
        addChildrenToPaginationPanel();
        
        // apply 16 property setters
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        offerListTableModel.setNbFormsPerPage(10);
        offerListTableModel.setPageToShow(1);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createAdvancedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createListTable();
        createPaginationPanel();
        createPaginationUI();
        createExportButton();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

}